/*
 * puz_app.h -- Copyright (C) 1998 by M. G"otze
 */

#include <ktopwidget.h>

class KLocale;
class KMenuBar;
class KSlidePuzzle;

class KSlideApp : public KTopLevelWidget
{
  Q_OBJECT

  public:
    KSlideApp();
    ~KSlideApp();

  public slots:
    void setModeCl3();
    void setModeCl4();
    void setModeCl5();
    void setModeCl6();
    void setModeCo();
    void setModeCr();
    void setModeDi();
    void setModeIs();
    void setModeTr();
    void scramblingStarted();
    void scramblingStopped();
    void orderingStarted();
    void orderingStopped();
    void toggleMissingTile();
    void toggleSound();
    void help();
    void about();
    void loadImage();
    void defaultImage();

  private:
    struct {
      QPopupMenu *mGame, *mPrefs;
      int scramble, order;
      int loadImg, defImg;
      int mode1, mode2;
      int modes[9];
      int mTile;
      int sound;
    } mIDs;  // ID's of modifyable menu options
    int curMode;
    KLocale *locale;
    KMenuBar *mBar;
    KSlidePuzzle *puzzle;

    void setMode(unsigned char mode);
    void enableModeChange(bool enable);
};
