/*
 * use.c
 *
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 *
 */

#include "rogue.h"
#include "dun.h"

short halluc = 0;
short blind = 0;
short confused = 0;
short levitate = 0;
short haste_self = 0;
boolean see_invisible = 0;
short extra_hp = 0;
boolean detect_monster = 0;
char *strange_feeling = _T("you have a strange feeling for a moment, then it passes");

extern short bear_trap;
extern char hunger_str[];
extern short cur_room;
extern long level_points[];
extern boolean being_held;
extern char *fruit, *you_can_move_again;
extern boolean sustain_strength;

quaff()
{
	short ch;
	char buf[MSGLEN];
	object *obj;

	ch = item;
	obj = item_o;
	
	switch(obj->which_kind) {
		case INCREASE_STRENGTH:
			message(_i18n("you feel stronger now, what bulging muscles!"),
			0);
			rogue.str_current++;
			if (rogue.str_current > rogue.str_max) {
				rogue.str_max = rogue.str_current;
			}
			break;
		case RESTORE_STRENGTH:
			rogue.str_current = rogue.str_max;
			message(_i18n("this tastes great, you feel warm all over"), 0);
			break;
		case HEALING:
			message(_i18n("you begin to feel better"), 0);
			potion_heal(0);
			break;
		case EXTRA_HEALING:
			message(_i18n("you begin to feel much better"), 0);
			potion_heal(1);
			break;
		case POISON:
			if (!sustain_strength) {
				rogue.str_current -= get_rand(1, 3);
				if (rogue.str_current < 1) {
					rogue.str_current = 1;
				}
			}
			message(_i18n("you feel very sick now"), 0);
			if (halluc) {
				unhallucinate();
			}
			break;
		case RAISE_LEVEL:
			rogue.exp_points = level_points[rogue.exp - 1];
			add_exp(1, 1);
			break;
		case BLINDNESS:
			go_blind();
			break;
		case HALLUCINATION:
			message(_i18n("oh wow, everything seems so cosmic"), 0);
			halluc += get_rand(500, 800);
			break;
		case DETECT_MONSTER:
			show_monsters();
			if (!(level_monsters.next_monster)) {
				message(transl(strange_feeling), 0);
			}
			break;
		case DETECT_OBJECTS:
			if (level_objects.next_object) {
				if (!blind) {
					show_objects();
				}
			} else {
				message(transl(strange_feeling), 0);
			}
			break;
		case CONFUSION:
			message((halluc ? _i18n("what a trippy feeling") :
			_i18n("you feel confused")), 0);
			confuse();
			break;
		case LEVITATION:
			message(_i18n("you start to float in the air"), 0);
			levitate += get_rand(15, 30);
			being_held = bear_trap = 0;
			break;
		case HASTE_SELF:
			message(_i18n("you feel yourself moving much faster"), 0);
			haste_self += get_rand(11, 21);
			if (!(haste_self % 2)) {
				haste_self++;
			}
			break;
		case SEE_INVISIBLE:
			snprintf(buf, MSGLEN, _i18n("hmm, this potion tastes like %s juice"), _i18n(fruit));
			message(buf, 0);
			if (blind) {
				unblind();
			}
			see_invisible = 1;
			relight();
			break;
	}
	print_stats((STAT_STRENGTH | STAT_HP));
	if (id_potions[obj->which_kind].id_status != CALLED) {
		id_potions[obj->which_kind].id_status = IDENTIFIED;
	}
	vanish(obj, 1, &rogue.pack);
}

read_scroll()
{
	short ch;
	object *obj;
	char msg[MSGLEN], *itemn;
	int itemid;

	if(blind)
	{
		message(_i18n("You can't see to read the scroll."),0);
		return;
	}

	ch = item;
	obj = item_o;
	
	switch(obj->which_kind) {
		case SCARE_MONSTER:
			message(_i18n("you hear a maniacal laughter in the distance"), 0);
			break;
		case HOLD_MONSTER:
			hold_monster();
			break;
		case ENCH_WEAPON:
			if (rogue.weapon) {
				if (rogue.weapon->what_is == WEAPON) {
					int i = get_ench_color();
					itemn = name_of(rogue.weapon, &itemid);
					format_str(msg, (rogue.weapon->quantity <= 1)?
					    "your ${0} glows ${1} for a moment":
					    "your ${0} glow ${1} for a moment", "enchw", 2,
					    OBJECT, itemid, itemn, COLOR, i, color_names[i]);
					message(msg, 0);
					if (coin_toss()) {
						rogue.weapon->hit_enchant++;
					} else {
						rogue.weapon->d_enchant++;
					}
				}
				rogue.weapon->is_cursed = 0;
			} else {
				message(_i18n("your hands tingle"), 0);
			}
			break;
		case ENCH_ARMOR:
			if (rogue.armor) {
				int i=get_ench_color();
				message(format_str(msg, "you armor glows ${0} for a moment", 
					"encha", 1, COLOR, i, color_names[i]), 0);
				rogue.armor->d_enchant++;
				rogue.armor->is_cursed = 0;
				print_stats(STAT_ARMOR);
			} else {
				message(_i18n("your skin crawls"), 0);
			}
			break;
		case IDENTIFY:
			message(_i18n("this is a scroll of identify"), 0);
			obj->identified = 1;
			id_scrolls[obj->which_kind].id_status = IDENTIFIED;
			ccmd=CMD_IDENTIFY;
			cmd_ask=2+256;
			cmd_mask=ALL_OBJECTS;
			cmd_q=_T("what would you like to identify");
			break;
		case TELEPORT:
			tele();
			break;
		case SLEEP:
			message(_i18n("you fall asleep"), 0);
			take_a_nap();
			break;
		case PROTECT_ARMOR:
			if (rogue.armor) {
				message( _i18n("your armor is covered by a shimmering gold shield"),0);
				rogue.armor->is_protected = 1;
				rogue.armor->is_cursed = 0;
			} else {
				message(_i18n("your acne seems to have disappeared"), 0);
			}
			break;
		case REMOVE_CURSE:
				message((!halluc) ?
					_i18n("you feel as though someone is watching over you") :
					_i18n("you feel in touch with the universal oneness"), 0);
			uncurse_all();
			break;
		case CREATE_MONSTER:
			create_monster();
			break;
		case AGGRAVATE_MONSTER:
			aggravate();
			break;
		case MAGIC_MAPPING:
			message(_i18n("this scroll seems to have a map on it"), 0);
			draw_magic_map();
			break;
	}
	if (id_scrolls[obj->which_kind].id_status != CALLED) {
		id_scrolls[obj->which_kind].id_status = IDENTIFIED;
	}
	vanish(obj, (obj->which_kind != SLEEP && obj->which_kind != IDENTIFY), 
		&rogue.pack);
}

/* vanish() does NOT handle a quiver of weapons with more than one
   arrow (or whatever) in the quiver.  It will only decrement the count.
*/

vanish(obj, rm, pack)
object *obj;
short rm;
object *pack;
{
	if (obj->quantity > 1) {
		obj->quantity--;
	} else {
		if (obj->in_use_flags & BEING_WIELDED) {
			unwield(obj);
		} else if (obj->in_use_flags & BEING_WORN) {
			unwear(obj);
		} else if (obj->in_use_flags & ON_EITHER_HAND) {
			un_put_on(obj);
		}
		take_from_pack(obj, pack);
		free_object(obj);
	}
	if (rm) {
		(void) reg_move();
	}
}

potion_heal(extra)
{
	float ratio;
	short add;

	rogue.hp_current += rogue.exp;

	ratio = (rogue.hp_current) / rogue.hp_max;

	if (ratio >= 1.00) {
		rogue.hp_max += (extra ? 2 : 1);
		extra_hp += (extra ? 2 : 1);
		rogue.hp_current = rogue.hp_max;
	} else if (ratio >= 0.90) {
		rogue.hp_max += (extra ? 1 : 0);
		extra_hp += (extra ? 1 : 0);
		rogue.hp_current = rogue.hp_max;
	} else {
		if (ratio < 0.33) {
			ratio = 0.33;
		}
		if (extra) {
			ratio += ratio;
		}
		add = (short)(ratio * (rogue.hp_max - rogue.hp_current));
		rogue.hp_current += add;
		if (rogue.hp_current > rogue.hp_max) {
			rogue.hp_current = rogue.hp_max;
		}
	}
	if (blind) {
		unblind();
	}
	if (confused && extra) {
			unconfuse();
	} else if (confused) {
		confused = (confused / 2) + 1;
	}
	if (halluc && extra) {
		unhallucinate();
	} else if (halluc) {
		halluc = (halluc / 2) + 1;
	}	
}

idntfy()
{
	short ch;
	object *obj;
	struct id *id_table;
	char desc[MSGLEN];
	ch = item;
	obj = item_o;

	obj->identified = 1;
	if (obj->what_is & (SCROLL | POTION | WEAPON | ARMOR | WAND | RING)) {
		id_table = get_id_table(obj);
		id_table[obj->which_kind].id_status = IDENTIFIED;
	}
	get_desc(obj, desc);
	message(desc, 0);
}

eat()
{
	short moves;
	object *obj;
	char buf[MSGLEN];

	obj=item_o;
	if ((obj->which_kind == FRUIT) || rand_percent(60)) {
		moves = get_rand(900, 1100);
		if (obj->which_kind == RATION) {
			message(_i18n("yum, that tasted good"), 0);
		} else {
			snprintf(buf, MSGLEN, _i18n("my, that was a yummy %s"), transl(fruit));
			message(buf, 0);
		}
	} else {
		moves = get_rand(700, 900);
		message(_i18n("yuk, that food tasted awful"), 0);
		add_exp(2, 1);
	}
	rogue.moves_left /= 3;
	rogue.moves_left += moves;
	hunger_str[0] = 0;
	print_stats(STAT_HUNGER);

	vanish(obj, 1, &rogue.pack);
}

hold_monster()
{
	short i, j;
	short mcount = 0;
	object *monster;
	short row, col;

	for (i = -2; i <= 2; i++) {
		for (j = -2; j <= 2; j++) {
			row = rogue.row + i;
			col = rogue.col + j;
			if ((row < MIN_ROW) || (row > (DROWS-2)) || (col < 0) ||
				 (col > (DCOLS-1))) {
				continue;
			}
			if (dungeon[row][col] & MONSTER) {
				monster = object_at(&level_monsters, row, col);
				monster->m_flags |= ASLEEP;
				monster->m_flags &= (~WAKENS);
				mcount++;
			}
		}
	}
	if (mcount == 0) {
		message(_i18n("you feel a strange sense of loss"), 0);
	} else if (mcount == 1) {
		message(_i18n("the monster freezes"), 0);
	} else {
		message(_i18n("the monsters around you freeze"), 0);
	}
}

tele()
{
	updatech(rogue.row, rogue.col);

	if (cur_room >= 0) {
		darken_room(cur_room);
	}
	put_player(get_room_number(rogue.row, rogue.col));
	being_held = 0;
	bear_trap = 0;	
}

hallucinate()
{
	object *obj, *monster;
	short ch;

	if (blind) return;

	obj = level_objects.next_object;

	while (obj) {
		ch = vdungeon[obj->row][obj->col]&OBJMASK;
		if (((ch < V_MONSTER) || (ch > V_MONSTER+25)) &&
			((obj->row != rogue.row) || (obj->col != rogue.col)))
		if (ch != V_NOTHING) {
			addobj(obj->row, obj->col, gr_obj_char());
		}
		obj = obj->next_object;
	}
	monster = level_monsters.next_monster;

	while (monster) {
		ch = vdungeon[monster->row][monster->col]&OBJMASK;
		if ((ch >= V_MONSTER) && (ch <= V_MONSTER+25)) {
			addobj(monster->row, monster->col, 
			  V_MONSTER+get_rand(0, 25));
		}
		monster = monster->next_monster;
	}
}

unhallucinate()
{
	int i, j, obj;
	halluc = 0;
	for (i=0; i<DROWS; i++)
	  for (j=0; j<DCOLS; j++)
	    if ((obj=(vdungeon[i][j]&OBJMASK))!=V_NOTHING && obj!=V_ROGUE)
	      addobj(i, j, get_dungeon_char(i, j)&OBJMASK);
	message(_i18n("everything looks SO boring now"), 1);
}

unblind()
{
	blind = 0;
	message(_i18n("the veil of darkness lifts"), 1);
	relight();
	if (halluc) {
		hallucinate();
	}
	if (detect_monster) {
		show_monsters();
	}	
}

relight()
{
	if (cur_room == PASSAGE) {
		light_passage(rogue.row, rogue.col);
	} else {
		light_up_room(cur_room, rogue.row, rogue.col);
	}
	addobj(rogue.row, rogue.col, V_ROGUE);	
}

take_a_nap()
{
	short i;

	i = get_rand(2, 5);

	while (i--) {
		mv_mons();
	}
	message(transl(you_can_move_again), 0);	
}

go_blind()
{
	short i, j;

	if (!blind) {
		message(_i18n("a cloak of darkness falls around you"), 0);
	}
	blind += get_rand(500, 800);

	if (detect_monster) {
		object *monster;

		monster = level_monsters.next_monster;

		while (monster) {
			addobj(monster->row, monster->col, monster->trail_char&OBJMASK);
			monster = monster->next_monster;
		}
	}
	if (cur_room >= 0) {
		for (i = rooms[cur_room].top_row + 1;
			 i < rooms[cur_room].bottom_row; i++) {
			for (j = rooms[cur_room].left_col + 1;
				 j < rooms[cur_room].right_col; j++) {
				vdungeon[i][j]=V_NOTHING;
				redraw(i, j);
			}
		}
	}
	vdungeon[rogue.row][rogue.col] = get_dungeon_char(rogue.row, rogue.col);
	addobj(rogue.row, rogue.col, V_ROGUE);
}

get_ench_color()
{
	if (halluc) {
		return(get_rand(0, POTIONS-1));
	}
	return 0;
}

confuse()
{
	confused += get_rand(12, 22);
}

unconfuse()
{
	confused = 0;
	if (!halluc) message(_i18n("you feel less confused now"), 1);
	  else message(_i18n("you feel less trippy now"), 1);
}

uncurse_all()
{
	object *obj;

	obj = rogue.pack.next_object;

	while (obj) {
		obj->is_cursed = 0;
		obj = obj->next_object;
	}
}
