#ifndef SPIELERWIDGET_H
#define SPIELERWIDGET_H

#include <qframe.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qstring.h>
#include <qslider.h>

#include "spieler.h"

typedef struct spielerReturn {
    QString	spieler[5];
};

class SpielerWidget : public QFrame {
  Q_OBJECT
  public:
    SpielerWidget (QWidget* parent, const char *name = 0);
    QPushButton*  startBtn;
    
  public slots:
    void startPressed ();
    void slChanged (int si);

  signals:
    void letsGo ( spielerReturn );
    
  private:
    QLineEdit*	  spieler[5];
    QLabel*	  dLabel;
    QSlider*      spielerSlider;
    QString	  s;
    spielerReturn dSR;
  
  protected:
    void resizeEvent (QResizeEvent *);
};    
#endif