#include "spieler.h"

typedef struct besitzStruct {
    QString name;
    int     id;
    struct besitzStruct* next;
};

typedef struct spielerStruct {
    QString name;
    int	   geld;
    int    id;
    int    bi;
    int    fe;
    struct besitzStruct* besitz;
    struct spielerStruct* next;
};

spielerStruct *cursor, *temp, *head, *last;
besitzStruct *bcursor, *btemp, *blast;

int si;
bool sinitialized = FALSE;

Feld* dummyFeld;

Spieler::Spieler ( QString name ) {
    if (name != "_m(0.0)m_") {
	if (!sinitialized) {
	    dummyFeld = new Feld ();
	    si = 0;
	    sinitialized = TRUE;
	};
	si++;
	last = head;
	temp = new spielerStruct;
	temp->next=NULL;
	temp->id=si;
    	temp->bi=0;
	temp->fe=1;
        temp->besitz=NULL;
        temp->name=name;
        temp->geld=26000;
        if ((cursor = head) == NULL) {	
    	    head = temp;
	    return;
        };
        if (cursor->id > temp->id) {
	    temp->next = cursor;
	    head = temp;
	    return;
	};
	last=cursor;
	while (cursor->next != NULL) {
	    if (cursor->id > temp->id) {
		temp->next = last->next;
		last->next = temp;
		return;
	    };
	    last = cursor;
	    cursor = cursor->next;
	};
	if (cursor->id > temp->id) {
	    temp->next = last->next;
	    last->next = temp;
	    return;
	};
	cursor->next = temp;
    };
};

int Spieler::ID ( QString name ) {
    cursor = head;
    while (cursor != NULL) {
	if (cursor->name == name) return (cursor->id);
	cursor = cursor->next;
    };
    return 0;
};

bool Spieler::besitzt ( QString name, QString str ) {
    cursor = head;
    while (cursor != NULL) {
	if (cursor->name == name) {
	    bcursor = cursor->besitz;
	    while (bcursor != NULL) {
		if (bcursor->name == str) return TRUE;
		bcursor = bcursor->next;
	    };
	};
	cursor = cursor->next;
    };
    return FALSE;
};

bool Spieler::kaufen ( QString name ) {
    int pos = positionLesen (name);
    cursor = head;
    while (cursor != NULL) {
        if (cursor->besitz != NULL) {
    	    bcursor = cursor->besitz;
	    while (bcursor->next != NULL) {
		if (bcursor->name == dummyFeld->name (pos)) return FALSE;
		bcursor = bcursor->next;
	    };
	    if (bcursor->name == dummyFeld->name (pos)) return FALSE;
	};
	cursor = cursor->next;
    };
    cursor = head;
    while (cursor != NULL) {
	if (cursor->name == name) {
	    if (dummyFeld->kaufen (name, pos)) {
		btemp = new besitzStruct;
		cursor->bi++;
		btemp->id = cursor->bi;
		btemp->name = dummyFeld->name (pos);
		btemp->next = NULL;
		if (cursor->besitz == NULL) {
		    cursor->besitz = btemp;
		    return TRUE;    
		} else {
		    bcursor = cursor->besitz;
		    while (bcursor->next != NULL) bcursor = bcursor->next;
		    bcursor->next = btemp;
		    return TRUE;
		};
	    };
	    return FALSE;
	};
	cursor = cursor->next;
    };
};

bool Spieler::bauen ( QString name, int feldNr, int gebaeude ) {
    if ((besitzt (name, dummyFeld->name (feldNr))) && (darfBauen (name, dummyFeld->name (feldNr)))) {
	if (dummyFeld->bauen (feldNr, gebaeude)) return TRUE;
    };
    return FALSE;
};

bool Spieler::zahlen ( QString name, int betrag ) {
    cursor = head;
    while (cursor != NULL) {
	if (cursor->name == name) {
	    if ((cursor->geld - betrag) > 0) {
		cursor->geld -= betrag;
		return TRUE;
	    } else {
		return FALSE;
	    };
	};
	cursor = cursor->next;
    };
    return FALSE;
};

bool Spieler::verdienen ( QString name, int betrag ) {
    cursor = head;
    while (cursor != NULL) {
	if (cursor->name == name) {
	    cursor->geld += betrag;
	    return TRUE;
	};
	cursor = cursor->next;
    };
    return FALSE;
};

int Spieler::bar ( QString name ) {
    cursor = head;
    while (cursor != NULL) {
	if (cursor->name == name) return (cursor->geld);
	cursor = cursor->next;
    };
    return 0;
};

bool Spieler::darfBauen ( QString name, QString str ) {
    if (besitzt (name, str)) {
	cursor = head;
	while (cursor != NULL) {
	    if (cursor->name == name) {
		switch (dummyFeld->farbe (str)) {
		    case 1 : { 
			       if ((besitzt (name, "Badstrasse")) && 
				   (besitzt (name, "Turmstrasse"))) return TRUE;
			       break;
			     };
		    case 2 : {
			       if ((besitzt (name, "Elisenstrasse")) &&
			           (besitzt (name, "Chausseestrasse")) &&
				   (besitzt (name, "Poststrasse"))) return TRUE;
			       break;
			     };
		    case 3 : {
			       if ((besitzt (name, "Hafenstrasse")) &&
			           (besitzt (name, "Neue Strasse")) &&
				   (besitzt (name, "Seestrasse"))) return TRUE;
			       break;
			     };
		    case 4 : {
			       if ((besitzt (name, "Berliner Strasse")) &&
			           (besitzt (name, "Muenchner Strasse")) &&
				   (besitzt (name, "Wiener Strasse"))) return TRUE;
			       break;
			     };
		    case 5 : {
			       if ((besitzt (name, "Opernplatz")) &&
			           (besitzt (name, "Museumsstrasse")) &&
				   (besitzt (name, "Theaterstrasse"))) return TRUE;
			       break;
			     };
		    case 6 : {
			       if ((besitzt (name, "Schillerstrasse")) &&
			           (besitzt (name, "Lessingstrasse")) &&
				   (besitzt (name, "Goethestrasse"))) return TRUE;
			       break;
			     };
		    case 7 : {
			       if ((besitzt (name, "Hauptstrasse")) &&
			           (besitzt (name, "Bahnhofstrasse")) &&
				   (besitzt (name, "Rathausplatz"))) return TRUE;
			       break;
			     };
		    case 8 : {
			       if ((besitzt (name, "Schlossallee")) &&
				   (besitzt (name, "Parkstrasse"))) return TRUE;
			       break;
			     };
		    default: return FALSE;
		};
		return FALSE;
	    };
	    cursor = cursor->next;
	};	     
    };
    return FALSE;
};

bool Spieler::positionSetzen (QString name, int feldNr) {
    cursor = head;
    while (cursor != NULL) {
	if (cursor->name == name) {
	    if ((feldNr < 1) || (feldNr > 40)) feldNr = 1;
	    cursor->fe = feldNr;
	    return TRUE;
	};
	cursor = cursor->next;
    };
    return FALSE;
};

int Spieler::positionLesen (QString name) {
    cursor = head;
    while (cursor != NULL) {
	if (cursor->name == name) return cursor->fe;
	cursor = cursor->next;
    };
    return FALSE;
};

int Spieler::gehen ( QString name, int schritte ) {
    di = positionLesen (name);
    di += schritte;
    
    while (di > 40) di -= 40;
    
    positionSetzen (name, di);
    return di;
};

QString Spieler::name ( int id ) {
    cursor = head;
    while (cursor != NULL) {
	if (cursor->id == id) return cursor->name;
	cursor = cursor->next;
    };
    return FALSE;
};

besitzReturn Spieler::gleicheStrassen (QString name) {
    besitzReturn tbr;
    
    cursor = head;
    while (cursor != NULL) {
        if (cursor->name == name) {
    	    bcursor = cursor->besitz;
	    while  (bcursor != NULL) {
		if (dummyFeld->ID (bcursor->name) == cursor->fe) {
		    switch (dummyFeld->farbe (bcursor->name)) {
			case 1 : { 
			       if ((besitzt (name, fDaten[1].name)) && 
				   (besitzt (name, fDaten[2].name))) {
			               tbr.besitzt[1] = fDaten[1].name;
				       tbr.besitzt[2] = fDaten[2].name;
				       tbr.wieviel = 2;
				};
				break;
			     };
			case 2 : {
			       if ((besitzt (name, fDaten[3].name)) &&
			           (besitzt (name, fDaten[4].name)) &&
				   (besitzt (name, fDaten[5].name))) {
			               tbr.besitzt[1] = fDaten[3].name;
				       tbr.besitzt[2] = fDaten[4].name;
				       tbr.besitzt[3] = fDaten[5].name;
				       tbr.wieviel = 3;
				};
			        break;
			     };
			case 3 : {
			       if ((besitzt (name, fDaten[6].name)) &&
			           (besitzt (name, fDaten[7].name)) &&
				   (besitzt (name, fDaten[8].name))) {
			               tbr.besitzt[1] = fDaten[6].name;
				       tbr.besitzt[2] = fDaten[7].name;
				       tbr.besitzt[3] = fDaten[8].name;
				       tbr.wieviel = 3;
				};
			        break;
			     };
			case 4 : {
			       if ((besitzt (name, fDaten[9].name)) &&
			           (besitzt (name, fDaten[10].name)) &&
				   (besitzt (name, fDaten[11].name))) {
			               tbr.besitzt[1] = fDaten[9].name;
				       tbr.besitzt[2] = fDaten[10].name;
				       tbr.besitzt[3] = fDaten[11].name;
				       tbr.wieviel = 3;
				};
			        break;
			     };
			case 5 : {
			       if ((besitzt (name, fDaten[12].name)) &&
			           (besitzt (name, fDaten[13].name)) &&
				   (besitzt (name, fDaten[14].name))) {
			               tbr.besitzt[1] = fDaten[12].name;
				       tbr.besitzt[2] = fDaten[13].name;
				       tbr.besitzt[3] = fDaten[14].name;
				       tbr.wieviel = 3;
				};
			        break;
			     };
			case 6 : {
			       if ((besitzt (name, fDaten[15].name)) &&
			           (besitzt (name, fDaten[16].name)) &&
				   (besitzt (name, fDaten[17].name))) {
			               tbr.besitzt[1] = fDaten[15].name;
				       tbr.besitzt[2] = fDaten[16].name;
				       tbr.besitzt[3] = fDaten[17].name;
				       tbr.wieviel = 3;
				};
			        break;
			     };
			case 7 : {
			       if ((besitzt (name, fDaten[18].name)) &&
			           (besitzt (name, fDaten[19].name)) &&
				   (besitzt (name, fDaten[20].name))) {
			               tbr.besitzt[1] = fDaten[18].name;
				       tbr.besitzt[2] = fDaten[19].name;
				       tbr.besitzt[3] = fDaten[20].name;
				       tbr.wieviel = 3;
				};
			        break;
			     };
			case 8 : { 
			       if ((besitzt (name, fDaten[21].name)) && 
				   (besitzt (name, fDaten[22].name))) {
			               tbr.besitzt[1] = fDaten[21].name;
				       tbr.besitzt[2] = fDaten[22].name;
				       tbr.wieviel = 2;
				};
				break;
			     };
			default: tbr.wieviel = 0;
		    };
		    return tbr;
		};
		bcursor = bcursor->next;
	    };
	cursor = cursor->next;    
	};	     
    };
    tbr.wieviel = 0;
    return tbr;
};
