#include "kmaster.h"

MainView::MainView(QWidget* parent) : QWidget(parent)
{
  kmasterColors* kmc = new kmasterColors();
  moveCounter = 1;

  // Farb-Auswahl-Felder erstellen
  for(int i = 0; i < 6; i++)
    {
      chooserField[i] = new ChooserField(this);
      chooserField[i]->setBackgroundColor(*kmc->kmColor[i]);
      chooserField[i]->colornum = i;
      chooserField[i]->setMaximumSize(FIELD_WIDTH, FIELD_WIDTH);
      chooserField[i]->setMinimumSize(FIELD_WIDTH, FIELD_WIDTH);
      chooserField[i]->move(FIELD_WIDTH+(i*FIELD_WIDTH), FIELD_WIDTH);
    }

  playGround = new PlayGround(this, "test");
  playGround->move(FIELD_WIDTH, 3*FIELD_WIDTH);

  hintField = new HintField(this);
  hintField->move(6*FIELD_WIDTH, 3*FIELD_WIDTH);

  btnQuit = new QPushButton(klocale->translate("E&xit"), this);
  btnQuit->setMinimumSize(4*FIELD_WIDTH, FIELD_WIDTH);

  btnCheck = new QPushButton(klocale->translate("&Check"), this);
  btnCheck->setMinimumSize(4*FIELD_WIDTH, FIELD_WIDTH);
  btnStart = new QPushButton(klocale->translate("&Start"), this);
  btnStart->setMinimumSize(4*FIELD_WIDTH, FIELD_WIDTH);

  btnStart->move(FIELD_WIDTH, 13*FIELD_WIDTH);
  btnCheck->move(6*FIELD_WIDTH, 13*FIELD_WIDTH);
  btnQuit->move(FIELD_WIDTH, 14*FIELD_WIDTH);

  btnCheck->setEnabled(false);

  lblMove = new QLabel(this);
  lblMove->move(6*FIELD_WIDTH, 14*FIELD_WIDTH);
  lblMove->setMinimumSize(4*FIELD_WIDTH, FIELD_WIDTH);
  //String* mystring = new String();
  char test[10];
  lblMove->setText((new QString("Move #"))->append(gcvt(moveCounter, 1, test)));

  connect(btnStart, SIGNAL(clicked()), this, SLOT(startGame()));
  connect(btnQuit, SIGNAL(clicked()), qApp, SLOT(quit()));
  connect(btnCheck, SIGNAL(clicked()), this, SLOT(checkMove()));
  
}

void MainView::checkMove()
{
  int posOK = 0;
  int colorOK = 0;
  
  #ifdef debug
  cout << "playGround->field[i]->colornum ";

  for(int i = 0; i < 4; i++)
    {
      cout << playGround->field[i]->colornum << " /  ";
    }
  cout << "\n";

  cout << "solutionField[i] ";
  
  for(int i = 0; i < 4; i++)
    {
      cout << solutionField[i] << " / ";
    }

  cout << "\n";
  #endif

  // Richtige Positionen zhlen
  for(int i = 0; i < 4; i++)
    {
      if(playGround->field[i]->colornum == solutionField[i])
	posOK++;
    }
  #ifdef debug
  cout << "posOK = " << posOK << "\n";
  #endif
  
  // Richtige Farben zhlen
  for(int i = 0; i < 4; i++)
    {
      for(int j = 0; j < 4; j++)
	{
	  if(playGround->field[i]->colornum == solutionField[j])
	    colorOK++;
	}
    }
  #ifdef debug
  cout << "colorOK = " << colorOK << "\n";
  #endif

  // Kreise zeichnen
  playGround->drawMove();
  hintField->drawHint(posOK, colorOK);
  //playGround->moveCounter++;

  if(posOK < 4)
    {
      // Zugfelder runtersetzen
      playGround->moveFields();

      if(moveCounter == 10)
	{
	  QMessageBox::information(this, "kmaster", "Ooops...\nYou loose!");
	  resetGame();
	}
      else moveCounter++;
      char test[10];
      lblMove->setText((new QString("Move #"))->append(gcvt(moveCounter, 1, test)));
    }
  else
    {
      QMessageBox::information(this, "kmaster", "Congratulation!!!\nYou win!!!");
      resetGame();
    }  
}

void MainView::resetGame()
{
  btnCheck->setEnabled(false);
  btnStart->setEnabled(true);
  playGround->erase();
  hintField->erase();
  playGround->setStartPosition();
  hintField->setStartPosition();
  moveCounter = 1;
  char test[10];
  lblMove->setText((new QString("Move #"))->append(gcvt(moveCounter, 1, test)));
}

void MainView::startGame()
{
  // Gesuchte Farbkombination durch Zufall ermitteln
  // im solutionField alle Werte auf -3
  for(int i = 0; i < 4; i++)
    {
      solutionField[i] = -1;
    }
  
  bool equal = false;
  srand((unsigned)time(NULL));

  for(int i = 0; i < 4; i++)
    {
      do
	{
	  solutionField[i] = (int)(((double)rand()*6)/RAND_MAX);
	  equal = false;
	  // Testen ob zwei Zahlen gleich sind
	  for(int j = 0; j < 4; j++)
	    {
	      if(i != j && solutionField[i] == solutionField[j]) equal = true;
	    }
	} while (equal);
    }

  #ifdef debug
  for(int i = 0; i < 4; i++)
    {
      cout << solutionField[i] << " / ";
    }
  cout << "\n--------------" << "\n";
  #endif

  btnCheck->setEnabled(true);
  btnStart->setEnabled(false);
  
}

MainWidget::MainWidget(const char* name) : KTopLevelWidget(name)
{
  KMenuBar *menubar = new KMenuBar(this);
  QPopupMenu* pmFile;
  pmFile = new QPopupMenu;
  pmFile->insertItem(klocale->translate("E&xit"), qApp, SLOT(quit()) );
  menubar->insertItem(klocale->translate("&File"), pmFile);
  QPopupMenu* pmHelp = kapp->getHelpMenu(FALSE, "kmaster,  written by Oliver Jaun\n<oliver.jaun@bigfoot.com>");
  menubar->insertItem(klocale->translate("&Help"), pmHelp);
  
  setMenu(menubar);

  MainView* mv = new MainView(this);
  setView(mv);
}

int main(int argc, char** argv)
{
  KApplication a(argc, argv);
  MainWidget m;
  m.setMinimumSize(11*FIELD_WIDTH, 17*FIELD_WIDTH);
  m.setMaximumSize(11*FIELD_WIDTH, 17*FIELD_WIDTH);
  a.setMainWidget(&m);
  m.show();
  return a.exec();
}
