/***************************************************************************
                          gamefield.h  -  description
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          gamefield.h  -  description
                             -------------------
    begin                : Tue Mar 28 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GAMEFIELD_H
#define GAMEFIELD_H

#include <kapp.h>
#include <kaudio.h>

#include <qwidget.h>
#include <qlist.h>
#include <qdir.h>

#include <QwSpriteField.h>
#include <qimage.h>
#include <qrect.h>
#include <qpainter.h>

#include <math.h>
#include <stdlib.h>
#include <time.h>

#include "sprites.h"
#include "MyQwSpriteFieldView.h"

/**
  *@author Frank von Daak
  */

class GameField : public QWidget  {
   Q_OBJECT
public:
	GameField(QWidget *parent=0, const char *name=0);
	~GameField();

    void showText( const char *text, const QColor &color );
    void newGame();
    void reset();
    void setGnatSpeed( int s ) { gnatSpeed = s; }
    void addGnats( int num );
    void addMag( int num );
    void addTux( int num );
    void setLevel(int);
    void showPause(bool);

    MyQwSpriteFieldView *view;
    QwTextSprite *textSprite;
    QwImageSpriteField *field;

    bool started, sound;
    int shots;

protected:
   	void readSprites();
    virtual void timerEvent( QTimerEvent * );

private:
    QList<QwRealMobileSprite> gnats;
    QwSpritePixmapSequence *leftMImg;
    QwSpritePixmapSequence *rightMImg;

    QwSpritePixmapSequence *leftBImg;
    QwSpritePixmapSequence *rightBImg;

    QList<QwRealMobileSprite> dgnats;
    QwSpritePixmapSequence *GnatKillImg;

    QList<QwRealMobileSprite> mags;
    QwSpritePixmapSequence *magImg;

    QList<QwRealMobileSprite> tuxs;
    QwSpritePixmapSequence *tuxImg;
    QList<QwRealMobileSprite> dtuxs;
    QwSpritePixmapSequence *TuxKillImg;


    QwTextSprite *pauseTextSprite;

	const char *IMG_BACKGROUND, *L_MUEKE, *R_MUEKE, *L_MMASK, *R_MMASK,
								*L_BUCK, *R_BUCK, *R_BMASK, *L_BMASK;
    int  textDy, x, y, fc, ft, shootWait, L_MFRAMES, R_MFRAMES, L_BFRAMES, R_BFRAMES, rnd;
    double gnatSpeed;

	void showDeadGnat(int x, int y);
	void showDeadTux(int x, int y);
	void removeDGnat();
	void removeDTux();

	KAudio *hitSnd;

private slots:
	void shoot(int x, int y);
	void reloadGun();

signals:
	void gnatKilled(bool hit);
	void magKilled(bool hit);
	void tuxKilled(bool hit);
	void reload();
	void gameReset(int);
};

#endif