/* kgo.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef KGO_H
#define KGO_H

#include "kgo_widget.h"
#include "go_view.h"
#include "go_board.h"
#include "includes.h"

#define ID_PIECES 0
#define ID_CAPTURED 2
#define ID_TIME 3
#define ID_PLAYER 4

/**
 * This is the top-widget for Kgo. It is used as a level between
 * the actual KGoWidget and things a the Menu, the StatusBar and
 * the config-files
 **/
class KGo : public KTopLevelWidget
{
	Q_OBJECT

public:
	/**
	 * The constructor method for class KGo
	 *
	 * @param parent Parent widget, used for QWidget
	 * @param name	Name for QWidget
	 *
	 */
	KGo( QWidget *parent=0, const char *name=0 );
	
	/**
	 * The destrucor method for class KFortune
	 */
	~KGo();

protected slots:

	/**
	 * Save the current configuration and quit
	 */
	void quitapp() ;

	/**
	 * Configure the keybindings
	 */
	void configKeys() ;

	static const char * about() ;

	/**
	 * Show online help
	 */
	void helpmenu() ;

	/**
	 * Update the status bar
	 */
	void menu_slot(int) ;
	void toggleMovesList() ;

	/**
	 * Update the status bar
	 */
	void status_slot(int) ;

	/**
	 * Switch the StatusBar on and off
	 */
	void toggleStatusBar() ;

	/**
	 * Switch the legenda on and off
	 */
	void toggleLegenda() ;

	void notImpl() ;

protected:
	void paintEvent( QPaintEvent * ) ;

private:
	// methods
	void createMenu() ;
	void createStatusBar() ;
	void createKeys() ;
 
	void loadconfig() ;
	void saveconfig() ;

	// objects
	KConfig *config;
	KAccel *accel;

	KGoWidget *main_widget ;
	KMenuBar *menu;
	QPopupMenu *file, *options, *help;
	KStatusBar *statusbar ;

	int use_statusbar ;	
} ;

#endif
