/* dialog.h
 *
 * Pieter Eendebak <pte@ddsw.nl>
 */

#ifndef DIALOG_H
#define DIALOG_H

#include <includes.h>

/**
 * This class can be used to show a temporary message.
 */
class TimeDialog : public QDialog
{
	Q_OBJECT
public:
	TimeDialog( const char *text, long time, QWidget *parent ) ;
	~TimeDialog() {} ;

protected slots:
	void timerEvent( QTimerEvent *) ;	
} ;

/**
 * This class can be used to show a temporary message.
 */
class SignalDialog : public QDialog
{
	Q_OBJECT
public:
	SignalDialog( const char *text ) ;
	~SignalDialog() { } ;

public slots:
	void deleteWidget() { delete this ; } ;
} ;

#define ID_NORMAL 0
#define ID_MEDIUM 1
#define ID_SMALL 2
#define ID_CUSTOM 3

/**
 * This dialog asks for the game type to be played
 * @short Select game type
 */
class NewGame : public QDialog
{
	Q_OBJECT
public:	
	NewGame( QWidget *parent ) ;
	~NewGame() ;

	int getGameType() ;

	int getXSize() ;
	int getYSize() ;

private slots:
	void radioButtonClicked( int ) ;

private:
	QButtonGroup *box ;
	QRadioButton *normal, *medium, *small, *custom ;

	QComboBox *choice ;
	KIntegerLine *xWidth, *yWidth ;
        QPushButton *ok, *cancel;  
} ;

#define COUNT 0
#define NEWGAME 1
#define QUIT 2

/**
 * The game has ended, ask if the scores should be counted.
 * @short Game over dialog
 */
class GameOver : public QDialog
{
	Q_OBJECT
public:	
	GameOver( QWidget *parent, const char *name) ;
	~GameOver() ;

private:
	QLabel *txt ;
	QPushButton *newgame ;
	QPushButton *count ;

private slots:
	void Count() ;
	void Newgame() ;
	void Quit() ;
} ;

#endif

