/* dialog.cpp
 *
 * Pieter Eendebak <pte@ddsw.nl>
 */

#include "includes.h"
#include "dialog.moc"
#include "kgo.h"
#include "go_board.h"

#define ADD_LABEL( label, str, parent, x, y, w, h ) \
	{	label = new QLabel(str, parent); \
		label->setGeometry(x, y, w, h); \
	}

#define ADD_INT_LINE( line, value, parent, x, y, w, h ) \
	{	line = new KIntegerLine( parent ); \
		line->setValue( value ) ; \
		line->setGeometry(x, y, w, h); \
	}
#define ADD_RADIOBUTTON( rbutton, text, parent, x, y, w, h ) \
	{	rbutton = new QRadioButton( text, parent, 0 ) ; \
		rbutton->setGeometry(x, y, w, h); \
	}

/* ##########################
 * #	class TimeDialog    #
 * ##########################
 */
TimeDialog::TimeDialog( const char *text, long time, QWidget * )
	: QDialog( 0, 0, FALSE, WStyle_NoBorder )
{
	QLabel *t ;
	ADD_LABEL( t, text, this, 10, 10, 200, 30 ) ;
	QSize s = t->sizeHint() ;
	t->setGeometry( 10, 10, s.width()+5, s.height()+5 ) ;

	startTimer( time ) ;
	adjustSize() ; 
}

void TimeDialog::timerEvent( QTimerEvent * )
{
	delete this ;
}

/* ##########################
 * #	class SignalDialog  #
 * ##########################
 */
SignalDialog::SignalDialog( const char *text )
	: QDialog( 0, 0, FALSE, WStyle_NoBorder )
{
	QLabel *t ;
	ADD_LABEL( t, text, this, 10, 10, 200, 30 ) ;
	QSize s = t->sizeHint() ;
	t->setGeometry( 10, 10, s.width()+5, s.height()+5 ) ;

	adjustSize() ; 
}

/* ##########################
 * #	class NewGame       #
 * ##########################
 */

NewGame::NewGame( QWidget *parent )
        : QDialog( parent, 0, TRUE)
{
	// debug("creating NewGame dialog") ;

	setCaption( klocale->translate("Select game type to play") ) ;

	choice = new QComboBox( this ) ;
	choice->insertItem( klocale->translate( "Play against the computer"),
				COMPUTER_GAME ) ;
 	choice->insertItem( klocale->translate( "Play with two people"),
			TWO_PLAYER_GAME ) ;
 	choice->insertItem( klocale->translate( "Play over the Internet"),
			 NETWORK_GAME );
	choice->move( 10, 10 ) ;
	choice->adjustSize() ;
	// choice->setGeometry( 10, 10, 230, 30 ) ;

	/* ##### */
	box = new QButtonGroup( i18n("Select board size"),
			this, 0 ) ;
	box->setExclusive( true ) ;

	ADD_RADIOBUTTON( normal, i18n("Normal"), box, 
				10, 20, 160, 20 )
	ADD_RADIOBUTTON( medium, i18n("Medium size (13*13)"), box, 
				10, 50, 160, 20 )
	ADD_RADIOBUTTON( small, i18n("Small size (9*9)"), box, 
				10, 80, 160, 20 )
	ADD_RADIOBUTTON( custom, i18n("Custom size"), box, 
				10, 110, 160, 20 )

	box->insert( normal, ID_NORMAL ) ;
	box->insert( medium, ID_MEDIUM ) ;
	box->insert( small, ID_SMALL ) ;
	box->insert( custom, ID_CUSTOM ) ;

	QLabel *xW, *yW ;
	ADD_LABEL( xW, i18n("Width of the board: "), box,
			10, 150, 140, 20 ) ;
	ADD_LABEL( yW, i18n("Height of the board: "), box,
			10, 180, 140, 20 ) ;
 	ADD_INT_LINE( xWidth, DEFAULT_X_SIZE, box,
			160, 150, 40, 20 ) ; 
	ADD_INT_LINE( yWidth, DEFAULT_Y_SIZE, box,
			160, 180, 40, 20 ) ;
/*	//TODO: wait for new kdelibs
	xWidth->setMaximumValue( 30 ) ;
	xWidth->setMinimumValue( 5 ) ;
	yWidth->setMaximumValue( 30 ) ;
	yWidth->setMinimumValue( 5 ) ;
*/
	box->adjustSize() ;
	box->move( 10, 50 ) ;

	connect( box, SIGNAL(clicked(int)),
		SLOT(radioButtonClicked(int)) ) ;
	/* ##### */

	ok = new QPushButton( "&Ok", this );
        connect( ok, SIGNAL(clicked()), SLOT(accept()) );
	cancel = new QPushButton( "&Cancel", this );
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) ); 

	int off = 50 + box->size().height() + 10 ;
        ok->setGeometry( 10, off, 80 , 25 );
 	cancel->setGeometry( 100, off, 80 , 25 );  

	adjustSize() ;

	normal->setChecked( true ) ;
	radioButtonClicked( ID_NORMAL ) ;
}

NewGame::~NewGame()
{
	delete choice; delete box; 
}

int NewGame::getGameType()
{
	return choice->currentItem() ;	 
}

void NewGame::radioButtonClicked( int b )
{
	xWidth->setEnabled( b==ID_CUSTOM ) ;
	yWidth->setEnabled( b==ID_CUSTOM ) ;
}

int NewGame::getXSize()
{
	if ( custom->isChecked() )
		return xWidth->value() ;
	else
	{
		if( normal->isChecked() )
			return 19 ;
		if( medium->isChecked() )
			return 13 ;
		if( small->isChecked() )
			return 9 ;
	}
	return 0 ;
}

int NewGame::getYSize()
{
	if ( custom->isChecked() )
		return yWidth->value() ;
	else
	{
		if( normal->isChecked() )
			return 19 ;
		if( medium->isChecked() )
			return 13 ;
		if( small->isChecked() )
			return 9 ;
	}
	return 0 ;
}

/* ##########################
 * #	class GameOver	    #
 * ##########################
 */

GameOver::GameOver( QWidget *parent, const char *name )
        : QDialog( parent, name, TRUE )
{
	setCaption( klocale->translate("Game ended") ) ;

	txt = new QLabel( klocale->translate(
		"The game has ended.\nPlease choose one of the options below" 
					),
			this
			) ; 
  	count = new QPushButton( klocale->translate("Count scores"), this );
        connect( count, SIGNAL(clicked()), SLOT(Count()) );
        newgame = new QPushButton( klocale->translate("Start new game"), this );
  	connect( newgame, SIGNAL(clicked()), SLOT(Newgame()) ); 

	const int b = 100 ;
	const int width=20 + 2*b + 60 ;
	const int height=100 ;
	txt->setGeometry( 10, 10, width-20, 40 ) ;
        count->setGeometry( 10, 50, b ,30 );
 	newgame->setGeometry( width-10-b, 50, b ,30 );  

	resize( width, height ) ;
}

GameOver::~GameOver()
{
}

void GameOver::Count()
{
	done( COUNT ) ;
}

void GameOver::Newgame()
{
	done( NEWGAME ) ;
}

void GameOver::Quit()
{
	done( QUIT ) ;
}

