/*
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "config.h"
#include "playerShip.h"
#include "DebugInfo.h"

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

#define PLAYER_SPRITE_DATA    "/player_%d.ppm"
#define PLAYER_SPRITE_MASK    "/player_%d.pbm"
#define PLAYER_SPRITE_COUNT   2

#define PLAYER_VELOCITY       2
#define PLAYER_BOUND_LEFT     PLAYER_L_BOUND
#define PLAYER_BOUND_RIGHT    PLAYER_R_BOUND
#define PLAYER_BOUND_TOP      PLAYER_T_BOUND 
#define PLAYER_BOUND_BOTTOM   PLAYER_B_BOUND



/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/

//
//      Name:  playerShip
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
playerShip::playerShip( QString spritesPath )
             :QwMobileSprite()
{
  dprintf( "START::()\n");
  
	player = new QwSpritePixmapSequence( spritesPath+PLAYER_SPRITE_DATA, spritesPath+PLAYER_SPRITE_MASK, PLAYER_SPRITE_COUNT );
  setSequence( player );
  setVelocity( PLAYER_VELOCITY, PLAYER_VELOCITY );
  bounds( PLAYER_BOUND_LEFT, PLAYER_BOUND_TOP, PLAYER_BOUND_RIGHT, PLAYER_BOUND_BOTTOM );
  setBoundsAction( Stop );
  curImage = 0;
                                                                          
  printf( "famecount:=>%d<\n", frameCount() ); 
  dprintf( "END::()\n");
}

//
//      Name:  playerShip
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
playerShip::~playerShip()
{
  dprintf( "START::()\n");
  hide();
    
  if ( player != NULL )
  {
    delete player;
  }
  
  dprintf( "END::()\n");
}


//
//      Name:  movePlayer
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void playerShip::movePlayer(MovePlayerTo direction )
{
  dprintf( "START::()\n");

  curImage = ( curImage==0 ) ? 1 : 0 ;
  frame( curImage );
  
  switch( direction )
  {
    case Left:
      moveBy( -PLAYER_VELOCITY, 0 );
    break;
    case Right:   
      moveBy( PLAYER_VELOCITY, 0 );
    break;
    case Top:   
      moveBy( 0, -PLAYER_VELOCITY );
    break;
    case Bottom:
      moveBy( 0, PLAYER_VELOCITY );
    break;
    case TopLeft:
      moveBy( -PLAYER_VELOCITY, -PLAYER_VELOCITY );
    break;
    case TopRight:
      moveBy( PLAYER_VELOCITY, -PLAYER_VELOCITY );
    break;
    case BottomLeft:
      moveBy( -PLAYER_VELOCITY, PLAYER_VELOCITY );
    break;
    case BottomRight:
      moveBy( PLAYER_VELOCITY, PLAYER_VELOCITY );
    break;
    default:
    
    break;  
  }
  dprintf( "END::()\n");
}


//
//      Name:  playerShip::movePlayer
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void playerShip::movePlayer(unsigned int x, unsigned int y)
{
  dprintf( "START::()\n");
  curImage = ( curImage==0 ) ? 1 : 0 ;
  moveTo( x, y, curImage );
  dprintf( "END::()\n");
}






