/***************************************************************************
    khistorydlg.h  -  Command history dialog interface

    begin                : Mon Dec 20 1999
    copyright            : (C) 1999 by Yury Lebedev
    email                : yurylebedev@mail.ru
    home page            : http://devel-home.kde.org/~ksqlplus
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KHISTORYDLG_H
#define KHISTORYDLG_H

// platform configuration stuff
#if defined(HAVE_CONFIG_H) && !defined(CONFIG_H)
#define CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qstrlist.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qlistbox.h>

/**
 * Dialog for show SQL command history.
 *
 * @author Yury Lebedev
 **/
class KHistoryDlg : public QDialog
{
  Q_OBJECT

private:
  /** Command history list */
  QListBox* historyList;

public:
  /** Constructs dialog and internal widgets. */
  KHistoryDlg(QStrList* history, QWidget* parent = 0, const char* name = 0);
  /** Destructor */
  ~KHistoryDlg();

  /** Returns current selected history item index. */
  int selected() { return historyList->currentItem(); };

protected slots:
  /** slot for history list item double click signal. */
  void historyDoubleClicked(int index);
};

#endif
