/***************************************************************************
    khistorydlg.cpp  -  Command history dialog implementation

    begin                : Mon Dec 20 1999
    copyright            : (C) 1999 by Yury Lebedev
    email                : yurylebedev@mail.ru
    home page            : http://devel-home.kde.org/~ksqlplus
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qlayout.h>
#include <qpushbutton.h>

// include files for KDE
#include <kapp.h>

#include "khistorydlg.h"

KHistoryDlg::KHistoryDlg(QStrList* history, QWidget* parent, const char* name) :
  QDialog(parent, name, true)
{
  // set dialog caption
  setCaption(i18n("Command history"));

  // calculate widgets size
  QFontMetrics metrics = fontMetrics();
  int h = metrics.height() + 8;
  int w = metrics.width(i18n("Cancel")) + 32;

  // init layouts
  QVBoxLayout* topLayout = new QVBoxLayout(this, 12, 12);
  QHBoxLayout* buttonLayout = new QHBoxLayout(6);

  // init history list
  historyList = new QListBox(this);
  historyList->insertStrList(history);
  historyList->setMultiSelection(false);
  historyList->setFixedVisibleLines(12);
  historyList->setFixedWidth(w * 3);
  historyList->setCurrentItem(history->at());
  historyList->centerCurrentItem();

  // add components to top layout
  topLayout->addWidget(historyList);
  topLayout->addLayout(buttonLayout);

  // init buttons
  QPushButton* okButton = new QPushButton(this);
  okButton->setText(i18n("Get"));
  okButton->setMinimumSize(w + 6, h + 6);
  okButton->setDefault(true);

  QPushButton* cancelButton = new QPushButton(this);
  cancelButton->setText(i18n("Cancel"));
  cancelButton->setMinimumSize(w + 6, h + 6);

  // add components to button layout
  buttonLayout->addWidget(okButton);
  buttonLayout->addWidget(cancelButton);

  // focus item
  historyList->setFocus();

  // center dialog inside parent
  if( parent )
    move(parent->x() + (parent->width() - width()) / 2,
      parent->y() + (parent->height() - height()) / 2);

  // setup slots
  connect(cancelButton, SIGNAL(clicked()), SLOT(reject()));
  connect(okButton, SIGNAL(clicked()), SLOT(accept()));
  connect(historyList, SIGNAL(selected(int)), SLOT(historyDoubleClicked(int)));
}

KHistoryDlg::~KHistoryDlg()
{
}

void KHistoryDlg::historyDoubleClicked(int index)
{
  accept();
}
