#include <qfiledlg.h>
#include "kpsqlman.moc"

// GLOBALS
KConfig  *config;

#define FRAME_BORDER_WIDTH 6
// -- class MApp implementation
 
MApp::MApp(const char *)
{
  setCaption("PGSQL Manager");

  setupToolBar();
  setupStatusBar();
  setupMenuBar();


  setupTabCtl();
//------- Reading configuration -----
QString t;
config = kapp->getConfig();
config->setGroup("PGSQLManager");

  if(config->readEntry("pghost",0L)) { sql.pghost=strdup(config->readEntry("pghost",0L));};
  if(config->readEntry("pgport",0L)) sql.pgport=strdup(config->readEntry("pgport",0L));


//-------
  setupTree();


connect( tree, SIGNAL(highlighted(int)), SLOT(slotItemPoppedUp(int)) );
connect( tree, SIGNAL(collapsed(int)), SLOT(slotChangeExpColl(int)) );
connect( tree, SIGNAL(expanded(int)), SLOT(slotChangeExpColl(int)) );

  setMinimumSize(600, 300);
  resize(600, 300);
}

MApp::~MApp()
{

  delete statusbar;  
  delete toolbar;
  delete file; 
  delete help;
  delete tree;
  delete pop;
  delete conf;
  delete menubar;
  delete tabctl;
}
 /* *********************************************************************** */

void MApp::setupMenuBar()
{ 
//----
pop = new QPopupMenu;
  pop->insertItem(i18n("Not implemented"),
                   this, SLOT(slotReadSystem()));
  pop->insertItem(i18n("Wait for next release"),
                   this, SLOT(slotReadSystem()));
//----

  file    = new QPopupMenu;
  help    = kapp->getHelpMenu(FALSE, "PGSQL Manager 0.2.0\n\n" 
	                      "(c) 1998  by Denis Loginov \n <ldu@cons.tsk.ru>");
	
  file->insertItem(i18n("&New query"),
                   this, SLOT(slotNew()));
  file->insertItem(i18n("&Load query"),
                   this, SLOT(slotRead()));

  file->insertItem(i18n("&Save query"),
                     this, SLOT(slotWriteQuery()));

  file->insertItem(i18n("Save &query results"),
                   this, SLOT(slotWriteResults()));

  file->insertSeparator();
  file->insertItem(i18n("E&xit"),
                   this, SLOT(slotExit()));

  conf = new QPopupMenu;
  conf->insertItem(i18n("&Execute"),
                   this, SLOT(slotExecQuery()));
  conf->insertItem(i18n("&Config"),
                   this, SLOT(slotConfigure()));
  conf->insertItem(i18n("&Save Config"),
                   this, SLOT(slotSaveConfig()));

  menubar = new KMenuBar(this, "menubar");
  menubar->insertItem(i18n("&File"), file); 
  menubar->insertItem(i18n("&Configure"), conf); 
  menubar->insertSeparator();
  menubar->insertItem(i18n("&Help"), help);

  setMenu(menubar);
}

void MApp::setupTabCtl()
{


 tabctl = new KTabCtl(this);
  CHECK_PTR(tabctl);

 w = new QWidget( tabctl, "page three" ); 
     CHECK_PTR(w);
 QGridLayout * g = new QGridLayout( w, 1, 1, 5 );
    tree = new sKTreeList( w );
    CHECK_PTR(tree);
    g->addWidget( tree,  0, 0 );
tree->setSmoothScrolling(TRUE);
tree->pop=pop;
tabctl->addTab( w, "Data &Structure" );


 w = new QWidget( tabctl, "page_one" ); 
     CHECK_PTR(w);
  g = new QGridLayout( w, 1, 1, 5 );
    //  multilineedit in column 1
    QueryMLE = new QMultiLineEdit( w );
    g->addWidget( QueryMLE, 0, 0 );
    QueryMLE->setText( "" );
tabctl->addTab( w, "&Query" );

 w = new QWidget( tabctl, "page two" ); 
     CHECK_PTR(w);
 g = new QGridLayout( w, 1, 1, 5 );
    //  multilineedit in column 1
    ResultsMLE =  new QMultiLineEdit( w );
    ResultsMLE->setFont("courier");
    g->addWidget( ResultsMLE, 0, 0 );
    ResultsMLE->setText( "" );

tabctl->addTab( w, "&Results" );

 w = new QWidget( tabctl, "page four" ); 
 g = new QGridLayout( w, 1, 1, 5 );
tabctl->addTab( w, "&Tracing" );

	
  setFrameBorderWidth(FRAME_BORDER_WIDTH);

  setView(tabctl);		// for KTopLevelWidget
  adjustSize();

}

void MApp::setupTree()
{
FillTree();
}

void MApp::setupToolBar()
{
  KIconLoader *loader = kapp->getIconLoader();
  QPixmap     pixmap;

  toolbar = new KToolBar(this, "toolbar");

  pixmap = loader->loadIcon("filenew.xpm");
  toolbar->insertButton(pixmap, 0,
                        SIGNAL(clicked()), this, SLOT(slotNew()),
                        TRUE, i18n("New Query"));

  pixmap = loader->loadIcon("fileopen.xpm");
  toolbar->insertButton(pixmap, 1,
                        SIGNAL(clicked()), this, SLOT(slotRead()),
                        TRUE, i18n("Load Query"));

  pixmap = loader->loadIcon("filefloppy.xpm");
 toolbar->insertButton(pixmap, 2,
                                  SIGNAL(clicked()), this, SLOT(slotWriteQuery()),
                                  TRUE, i18n("Save Query"));

  pixmap = loader->loadIcon("filefloppy.xpm");
 toolbar->insertButton(pixmap, 2,
                                  SIGNAL(clicked()), this, SLOT(slotWriteResults()),
                                  TRUE, i18n("Save Query Results"));

 
  toolbar->insertSeparator();

  pixmap = loader->loadIcon("forward.xpm");
  toolbar->insertButton( pixmap, 3,
                        SIGNAL(clicked()), this, SLOT(slotExecQuery()), 
                        TRUE, i18n("Execute Query"));

    strlist.insert(0,"Databases");
    toolbar->insertCombo(&strlist,20,FALSE,(const char*)SIGNAL(activated(const char*)),(QObject*)this,(const char*)SLOT(slotComboSelected()),TRUE,"Databases");
    KCombo *combo = toolbar->getCombo(20);
    combo->setMaximumSize(100,23);
			  
  pixmap = loader->loadIcon("configure.xpm");
  toolbar->insertButton( pixmap, 4,
                        SIGNAL(clicked()), this, SLOT(slotConfigure()),
                        TRUE, i18n("Configure"));
			  
  toolbar->insertSeparator();

  pixmap = loader->loadIcon("help.xpm");
  toolbar->insertButton(pixmap, 6,
                        SIGNAL(clicked()), this, SLOT(slotHelp()),
                        TRUE, i18n("Help"));

  toolbar->setBarPos(KToolBar::Top);
  addToolBar(toolbar); 
}

void MApp::setupStatusBar()
{
  statusbar = new KStatusBar(this, "statusbar");
  statusbar->insertItem("", 0);
  setStatusBar(statusbar);
}


// -- Slots 
 
void MApp::slotNew()
{
QueryMLE->setText("");
ResultsMLE->setText("");

 tabctl->setTabEnabled("page four",FALSE); 
 tabctl->setTabEnabled("page two",FALSE); 
 tabctl->setTabEnabled("page three",FALSE); 

 tabctl->setTabEnabled("page four",TRUE); 
 tabctl->setTabEnabled("page two",TRUE); 
 tabctl->setTabEnabled("page three",TRUE); 
} 

void MApp::slotItemPoppedUp(int)
{
} 
 
void MApp::slotChangeExpColl(int)
{
tree->ExpColl=TRUE;
};
 
void MApp::slotRead()
{
QString filename;
 filename=QFileDialog::getOpenFileName(0,"*.qry",this,"open dlg");
    if ( !filename.isEmpty() ) 
{

    QFile f( filename );
    if ( !f.open( IO_ReadOnly ) )  {return;};

    QueryMLE->clear();

    QTextStream t(&f);
    while ( !t.eof() ) {
	QString s = t.readLine();
	QueryMLE->append( s );
    }
    f.close();
}
tabctl->setTabEnabled("page two",FALSE); 
tabctl->setTabEnabled("page three",FALSE); 
tabctl->setTabEnabled("page four",FALSE); 

tabctl->setTabEnabled("page two",TRUE); 
tabctl->setTabEnabled("page three",TRUE); 
tabctl->setTabEnabled("page four",TRUE); 
}

void MApp::slotSaveConfig()
{
printf("saving conf");
      config = kapp->getConfig();
      config->setGroup("PGSQLManager");
      config->writeEntry("pghost",sql.pghost,true,false,false); 
      config->writeEntry("pgport",sql.pgport,true,false,false); 
      config->sync();
}
void MApp::slotReadSystem()
{

}

void MApp::slotWriteResults() 
{
QString text;
text=ResultsMLE->text();
 QString filename=QFileDialog::getSaveFileName(0,"*.res",this,"save dlg");
          if ( !filename.isEmpty() )     
{

    QFile f( filename );
    if ( !f.open( IO_ReadWrite ) )  {return;};

    QTextStream t(&f);
    t << text;
    f.close();
}
}

void MApp::slotWriteQuery() 
{
QString text;
text=QueryMLE->text();
 QString filename=QFileDialog::getSaveFileName(0,"*.qry",this,"save dlg");
          if ( !filename.isEmpty() )     
{

    QFile f( filename );
    if ( !f.open( IO_ReadWrite ) )  {return;};

    QTextStream t(&f);

               t << text;
    f.close();
}
}

void MApp::slotExit()
{
  kapp->quit(); 
}

void MApp::tree_clicked(QMouseEvent* e)
{
  mouseRightButDown = (e->button() == RightButton) ? TRUE : FALSE;
}


void MApp::slotHelp()
{
  kapp->invokeHTMLHelp("", "");
}

void MApp::slotComboSelected()
{

}
void MApp::slotConfigure()
{
  conf_dlg conf_Dlg; 
  conf_Dlg.setCaption("Connect");

 conf_Dlg.dPGhost->setText(sql.pghost);
 conf_Dlg.dPGport->setText(sql.pgport);

  if (conf_Dlg.exec()) 
   {
  // OK pressed 
 sql.pghost=conf_Dlg.dPGhost->text();
 sql.pgport=conf_Dlg.dPGport->text();
 FillTree();
   };
}

void MApp::slotExecQuery()
{
 QString s,t;
 int rs;
       t=QueryMLE->text();
       s=t.stripWhiteSpace();

 
 rs=sql.ExecuteQuery(toolbar->getComboItem(20),s); // EXECUTING QUERY

  switch (rs)
   {
 case SUCCESS_NO_RESULTS:
  sql.CleanUp();
  ResultsMLE->setText("query executed successfully");
  break; 
 case SUCCESS_RESULTS:
  OutPutResults(sql.res);
  sql.CleanUp();
  break; 
 case ERRORS_RETURNED:
  ResultsMLE->setText(sql.ErrorText);
  break; 
   };

// now let the user see the output 

 tabctl->setTabEnabled("page_one",FALSE); 
 tabctl->setTabEnabled("page three",FALSE); 
 tabctl->setTabEnabled("page four",FALSE); 

 tabctl->setTabEnabled("page_one",TRUE); 
 tabctl->setTabEnabled("page three",TRUE); 
 tabctl->setTabEnabled("page four",TRUE); 

}

int MApp::OutPutResults(PGresult *res)
{
 int lengths[512];
 QString str,spaces;
 int nFields,i,j,maxl;

ResultsMLE->setText("");

           nFields = PQnfields(res);
           for (i=0; i < nFields; i++)  
 {
  if (PQfsize(res,i)!=-1) 
{      // fixed length field
 if  ((uint)PQfsize(res,i)>strlen(PQfname(res,i))) {lengths[i]=PQfsize(res,i)+2;} else {lengths[i]=strlen(PQfname(res,i))+2;};
}
else
{     // variable lenght field
    maxl=strlen(PQfname(res,i));  
    for (j=0; j < PQntuples(res); j++) 
{
   if ((uint)maxl< strlen(PQgetvalue(res,j,i))) {maxl=strlen(PQgetvalue(res,j,i));};
};
 lengths[i]=maxl+2;
};
 };

  //Output itself
str="";
           for (i=0; i < nFields; i++)  
           {
            spaces.fill(' ',lengths[i]-strlen(PQfname(res,i)));
            str=str+PQfname(res,i)+spaces;          
          };
ResultsMLE->append(str); 
 str.fill('-',-1);
ResultsMLE->append(str); 
str="";
           // next, print out the instances 
           for (i=0; i < PQntuples(res); i++) {
             for (j=0  ; j < nFields; j++) {
           spaces.fill(' ',lengths[j]-strlen(PQgetvalue(res,i,j)));
           str=str+PQgetvalue(res,i,j)+spaces;      
             };
      str=str+"\n";
           };

ResultsMLE->append(str); str="";
return 0;
}

int MApp::FillTree()
{
int  i,j, itemN,itemN2,itemN3;
SQLQuerier tmpSQL;
tmpSQL.pghost=sql.pghost;
tmpSQL.pgport=sql.pgport;

if (sql.ExecuteQuery("template1","select * from pg_user")!=SUCCESS_RESULTS) 
 {  ResultsMLE->setText("Current configuration failed"); 
    ResultsMLE->append(sql.ErrorText);
    ResultsMLE->append("Choose [Configure] in menu to adjust settings");

 tabctl->setTabEnabled("page_one",FALSE); 
 tabctl->setTabEnabled("page three",FALSE); 
 tabctl->setTabEnabled("page four",FALSE); 

 tabctl->setTabEnabled("page_one",TRUE); 
 tabctl->setTabEnabled("page three",TRUE); 
 tabctl->setTabEnabled("page four",TRUE); 

    return 1;};

while (strlist.removeFirst()){};
toolbar->clearCombo(20);
tree->clear();
tree->setExpandLevel(30);
     KIconLoader *loader = kapp->getIconLoader();
     QPixmap p1;
     QPixmap p2;
     QPixmap p3;
 p1 = loader->loadIcon("flag.xpm");

tree->insertItem("Server - localhost",&p1,-1,TRUE); 
 p1 = loader->loadIcon("rightjust.xpm");
tree->addChildItem("Users",&p1,0);
 p1 = loader->loadIcon("tick.xpm");
           for (i=0; i < PQntuples(sql.res); i++) 
             {
           tree->addChildItem(PQgetvalue(sql.res,i,0),&p1,1);
             }
sql.CleanUp();


 p1 = loader->loadIcon("filefloppy.xpm");
sql.ExecuteQuery("template1","select * from pg_database");
tree->addChildItem("Databases",&p1,0);
 p1 = loader->loadIcon("editcopy.xpm"); 
 p2 = loader->loadIcon("filenew.xpm"); 
 p3 = loader->loadIcon("prev.xpm");
itemN=tree->count()-1;
           for (i=0; i < PQntuples(sql.res); i++) 
             {
           strlist.insert(i,PQgetvalue(sql.res,i,0));
           tree->addChildItem(PQgetvalue(sql.res,i,0),&p1,itemN);
//--------
 itemN2=tree->count()-1;
 tree->addChildItem("Tables",&p2,itemN2);
 itemN3=tree->count()-1;
 tree->addChildItem("Indices",&p3,itemN2);
 itemN2=tree->count()-1;
tmpSQL.ExecuteQuery(PQgetvalue(sql.res,i,0), "SELECT relname,relkind FROM pg_class  WHERE relname !~ '^pg_'   and relname !~ '^Inv' order by relkind");

   for (j=0; j < PQntuples(tmpSQL.res); j++) 
             {
  if (PQgetvalue(tmpSQL.res,j,1)[0]=='r') {tree->addChildItem(PQgetvalue(tmpSQL.res,j,0),&p2,itemN3);}
        else
                            {tree->addChildItem(PQgetvalue(tmpSQL.res,j,0),&p3,itemN2);}
              };
tmpSQL.CleanUp();
//--------
             }
sql.CleanUp();
 tree->setExpandLevel(2);
 toolbar->insertComboList (20, &strlist,0);
 ResultsMLE->clear();
 return 0;
};
