/***************************************************************************
                                 KTableViewer.cpp
                             -------------------
    begin                : 01.06.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qlayout.h>
#include "ktableviewer.h"
#include "serverwork.h"
#include <kmsgbox.h>
#include "korapic.xpm"

KTableViewer::KTableViewer(QWidget* parent, const char* name) :
		KDialog( parent, name, TRUE, 0 )
{
	QString	oraMessage;

	QPixmap picture((const char**) kora_xpm);
	setIcon(picture);
	

	tableListLabel = new QLabel( this, "tableListWLabel" );
	tableListLabel->setGeometry( 15, 16, 120, 20 );
	tableListLabel->setMinimumSize( 120, 20 );
	tableListLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		tableListLabel->setFont( font );
	}
	tableListLabel->setFocusPolicy( QWidget::NoFocus );
	tableListLabel->setBackgroundMode( QWidget::PaletteBackground );
	tableListLabel->setFontPropagation( QWidget::NoChildren );
	tableListLabel->setPalettePropagation( QWidget::NoChildren );
	tableListLabel->setFrameStyle( 0 );
	tableListLabel->setLineWidth( 1 );
	tableListLabel->setMidLineWidth( 0 );
	tableListLabel->QFrame::setMargin( 0 );
	tableListLabel->setText( i18n("List of User Tables:") );
	tableListLabel->setAlignment( 289 );
	tableListLabel->setMargin( -1 );

	tableList = new QListBox( this, "tableWList" );
	tableList->setGeometry( 10, 47, 640, 121 );
	tableList->setMinimumSize( 640, 121 );
	tableList->setMaximumSize( 32767, 32767 );
	connect( tableList, SIGNAL(highlighted(int)), SLOT(tableListClickedCB(int)) );
	tableList->setFocusPolicy( QWidget::StrongFocus );
	tableList->setBackgroundMode( QWidget::PaletteBase );
	tableList->setFontPropagation( QWidget::SameFont );
	tableList->setPalettePropagation( QWidget::SameFont );
	tableList->setFrameStyle( 51 );
	tableList->setLineWidth( 2 );
	tableList->setMidLineWidth( 0 );
	tableList->QFrame::setMargin( 0 );
	tableList->setDragSelect( TRUE );
	tableList->setAutoScroll( TRUE );
	tableList->setScrollBar( FALSE );
	tableList->setAutoScrollBar( TRUE );
	tableList->setBottomScrollBar( FALSE );
	tableList->setAutoBottomScrollBar( TRUE );
	tableList->setSmoothScrolling( TRUE );
	tableList->setMultiSelection( FALSE );
	tableList->setAutoUpdate( TRUE );

	baseFrame = new QFrame( this, "baseWFrame" );
	baseFrame->setGeometry( 10, 178, 640, 300 );
	baseFrame->setMinimumSize( 510, 240 );
	baseFrame->setMaximumSize( 32767, 32767 );
	baseFrame->setFocusPolicy( QWidget::NoFocus );
	baseFrame->setBackgroundMode( QWidget::PaletteBackground );
	baseFrame->setFontPropagation( QWidget::NoChildren );
	baseFrame->setPalettePropagation( QWidget::NoChildren );
	baseFrame->setFrameStyle( 50 );
	baseFrame->setLineWidth( 2 );
	baseFrame->setMidLineWidth( 0 );
	baseFrame->QFrame::setMargin( 0 );

	tableDataLabel = new QLabel( baseFrame, "tableDataWLabel" );
	tableDataLabel->setGeometry( 10, 32, 70, 20 );
	tableDataLabel->setMinimumSize( 70, 20 );
	tableDataLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		tableDataLabel->setFont( font );
	}
	tableDataLabel->setFocusPolicy( QWidget::NoFocus );
	tableDataLabel->setBackgroundMode( QWidget::PaletteBackground );
	tableDataLabel->setFontPropagation( QWidget::NoChildren );
	tableDataLabel->setPalettePropagation( QWidget::NoChildren );
	tableDataLabel->setFrameStyle( 0 );
	tableDataLabel->setLineWidth( 1 );
	tableDataLabel->setMidLineWidth( 0 );
	tableDataLabel->QFrame::setMargin( 0 );
	tableDataLabel->setText( i18n("Table Info:") );
	tableDataLabel->setAlignment( 289 );
	tableDataLabel->setMargin( -1 );

	tableDataMultiText = new QMultiLineEdit( baseFrame, "tableDataWMultiText" );
	tableDataMultiText->setGeometry( 10, 78, 620, 212 );
	tableDataMultiText->setMinimumSize( 470, 170 );
	tableDataMultiText->setMaximumSize( 32767, 32767 );
	{
		QFont font( "courier", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		tableDataMultiText->setFont( font );
	}
	tableDataMultiText->setFocusPolicy( QWidget::StrongFocus );
	tableDataMultiText->setBackgroundMode( QWidget::PaletteBase );
	tableDataMultiText->setFontPropagation( QWidget::SameFont );
	tableDataMultiText->setPalettePropagation( QWidget::SameFont );
	tableDataMultiText->setFrameStyle( 51 );
	tableDataMultiText->setLineWidth( 2 );
	tableDataMultiText->setMidLineWidth( 0 );
	tableDataMultiText->QFrame::setMargin( 0 );
	tableDataMultiText->insertLine( "" );
	tableDataMultiText->setReadOnly( TRUE );
	tableDataMultiText->setOverwriteMode( FALSE );
	tableDataMultiText->setAutoUpdate( TRUE );

	closeButton = new QPushButton( this, "closeWButton" );
	closeButton->setGeometry( 550, 494, 100, 30 );
	closeButton->setMinimumSize( 100, 30 );
	closeButton->setMaximumSize( 100, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		closeButton->setFont( font );
	}
	connect( closeButton, SIGNAL(clicked()), SLOT(closeButtonClickedCB()) );
	closeButton->setFocusPolicy( QWidget::TabFocus );
	closeButton->setBackgroundMode( QWidget::PaletteBackground );
	closeButton->setFontPropagation( QWidget::NoChildren );
	closeButton->setPalettePropagation( QWidget::NoChildren );
	closeButton->setText( i18n("Close") );
	closeButton->setAutoRepeat( FALSE );
	closeButton->setAutoResize( FALSE );
	closeButton->setToggleButton( FALSE );
	closeButton->setDefault( FALSE );
	closeButton->setAutoDefault( TRUE );
	closeButton->setIsMenuButton( FALSE );

	QBoxLayout* layout1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, "base" );
	layout1->addStrut( 0 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_2 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "listbase" );
	layout1->addLayout( layout1_2, 1 );
	layout1_2->addStrut( 0 );
	layout1_2->addSpacing( 10 );
	layout1_2->addWidget( tableListLabel, 1, 36 );
	layout1_2->addStretch( 10 );
	QBoxLayout* layout1_3 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "list" );
	layout1->addLayout( layout1_3, 10 );
	layout1_3->addStrut( 0 );
	layout1_3->addSpacing( 5 );
	layout1_3->addWidget( tableList, 1, 36 );
	layout1_3->addSpacing( 5 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_5 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "frame" );
	layout1->addLayout( layout1_5, 5 );
	layout1_5->addStrut( 0 );
	layout1_5->addSpacing( 5 );
	layout1_5->addWidget( baseFrame, 1, 36 );
	QBoxLayout* layout1_5_2 = new QBoxLayout( baseFrame, QBoxLayout::TopToBottom, 5, 5, "frameBase" );
	layout1_5_2->addStrut( 0 );
	layout1_5_2->addSpacing( 5 );
	QBoxLayout* layout1_5_2_2 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "infobase" );
	layout1_5_2->addLayout( layout1_5_2_2, 1 );
	layout1_5_2_2->addStrut( 0 );
	layout1_5_2_2->addSpacing( 5 );
	layout1_5_2_2->addWidget( tableDataLabel, 1, 36 );
	layout1_5_2_2->addStretch( 10 );
	QBoxLayout* layout1_5_2_3 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "info" );
	layout1_5_2->addLayout( layout1_5_2_3, 1 );
	layout1_5_2_3->addStrut( 0 );
	layout1_5_2_3->addSpacing( 5 );
	layout1_5_2_3->addWidget( tableDataMultiText, 1, 36 );
	layout1_5_2_3->addSpacing( 5 );
	layout1_5_2->addSpacing( 5 );
	layout1_5->addSpacing( 5 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_7 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "buttons" );
	layout1->addLayout( layout1_7, 1 );
	layout1_7->addStrut( 0 );
	layout1_7->addStretch( 10 );
	layout1_7->addWidget( closeButton, 1, 36 );
	layout1_7->addSpacing( 5 );
	layout1->addSpacing( 5 );
	resize( 660,540 );
	setMinimumSize( 0, 0 );
	setMaximumSize( 32767, 32767 );

	setCaption( i18n("View Tables") );

	KApplication::setOverrideCursor(waitCursor);
	// fill the listbox of the tables
	if (ServerWork::fillTableList(tableList, oraMessage))
	{
		// an error occured
		KApplication::restoreOverrideCursor();
		KMsgBox::message(this, i18n("Oracle Error"), oraMessage, KMsgBox::STOP);
	}

	KApplication::restoreOverrideCursor();

}


KTableViewer::~KTableViewer()
{
}

void KTableViewer::tableListClickedCB(int item)
{
	QString	tableResult;
	QString	oraMessage;

	if (!ServerWork::getTableData(item, oraMessage, tableResult))
	{
		KMsgBox::message(this, i18n("Table Error"), oraMessage, KMsgBox::STOP);
		return;
	}

	// ok, we have the data. Put it into the text field
	tableDataMultiText->clear();
	tableDataMultiText->insertLine(tableResult);
}
void KTableViewer::closeButtonClickedCB()
{
	this->close();
}
