/***************************************************************************
                                 KSqlReplace.h
                             -------------------
    begin                : 01.06.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSqlReplace_included
#define KSqlReplace_included

#include <kwizard.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>

class KSqlReplace : public KDialog
{
	Q_OBJECT

	public:
	KSqlReplace(QWidget* parent = NULL, const char* name = NULL);
	virtual ~KSqlReplace();

	void setReplacementText(const char* replacement)
	{
		toReplaceLabel->setText(replacement);
	}

	const char* getReplacement() const
	{
		return replacementText->text();
	}

	protected slots:
	void replaceButtonClickedCB();

	protected:
	QLabel*		toReplaceLabel;
	QLineEdit*	replacementText;
	QPushButton*	replaceButton;
};

#endif // KSqlReplace_included
