/***************************************************************************
                                 KSqlMain.cpp
                             -------------------
    begin                : 01.06.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kpixmap.h>
#include <qlayout.h>
#include <kmsgbox.h>
#include <kfiledialog.h>
#include <qkeycode.h>
#include "ksqlmain.h"
#include "ksqlabout.h"
#include "ksqllogon.h"
#include "serverwork.h"
#include "ksequenceviewer.h"
#include "ksynonymviewer.h"
#include "ktableviewer.h"
#include "kpackageviewer.h"
#include <ktopwidget.h>

#include <qlabel.h>
#include <kmenubar.h>
#include <qpopmenu.h>
#include <qfile.h>
#include "korapic.xpm"

KSqlMain::KSqlMain() :
		KTopLevelWidget()
{
	QPixmap picture((const char**) kora_xpm);
	setIcon(picture);

	KMenuBar* mainWMenuBar;
	// define a top layout
	QBoxLayout* topLayout = new QVBoxLayout(this, 5);

	mainWMenuBar = new KMenuBar( this, "mainWMenuBar" );
	setMenu(mainWMenuBar);

	// here follows code for the menu bar
	QPopupMenu* fileMenu = new QPopupMenu;
	fileMenu->insertItem(i18n("&Open"), this, SLOT(fileMenuOpenCB()), CTRL+Key_O);
	fileMenu->insertItem(i18n("E&xecute"), this, SLOT(executeButtonClickedCB()), CTRL+Key_E);
	fileMenu->insertSeparator();
	fileMenu->insertItem(i18n("&Exit"), this, SLOT(exitButtonClickedCB()), CTRL+Key_X);

	QPopupMenu* connectionMenu = new QPopupMenu;
	connectionMenu->insertItem(i18n("&Reconnect to Oracle"), this, SLOT(connectionMenuReconnectCB()));

	QPopupMenu* viewerMenu = new QPopupMenu;
	viewerMenu->insertItem(i18n("&Sequences"), this, SLOT(viewerMenuSequencesCB()));
	viewerMenu->insertItem(i18n("S&ynonyms"), this, SLOT(viewerMenuSynonymsCB()));
	viewerMenu->insertItem(i18n("&Tables"), this, SLOT(viewerMenuTablesCB()));
	viewerMenu->insertItem(i18n("&Packages"), this, SLOT(viewerMenuPackagesCB()));

	QPopupMenu* helpMenu = new QPopupMenu;
	helpMenu->insertItem(i18n("&Contents"), this, SLOT(helpMenuContentsCB()));
	helpMenu->insertSeparator();
	helpMenu->insertItem(i18n("&About KOra"), this, SLOT(helpMenuAboutCB()));


	mainWMenuBar->insertItem(i18n("&File"), fileMenu);
	mainWMenuBar->insertItem(i18n("&Connection"), connectionMenu);
	mainWMenuBar->insertItem(i18n("&View"), viewerMenu);
	mainWMenuBar->insertSeparator();
	mainWMenuBar->insertItem(i18n("&Help"), helpMenu);

	// add a spacing to the top layout. So we can see the menu
	topLayout->addSpacing(20);

	// define a base layout to let the base Frame grow
	QBoxLayout* baseLayout = new QHBoxLayout();
	topLayout->addLayout(baseLayout);

	// define the base frame
	QFrame* baseFrame = new QFrame(this, "baseWFrame");
	baseFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	baseFrame->setLineWidth(2);
	//baseFrame->setGeometry(10, 30, 780, 550);
	baseFrame->setMinimumSize(780, 550);

	// add this frame to the base Layout
	baseLayout->addWidget(baseFrame);

	QBoxLayout* frameBaseLayout = new QVBoxLayout(baseFrame,1);

	// add a non writeable area to the top layout
	topLayout->addSpacing(15);

	// define a layout for the input base area
	QBoxLayout* inputBaseLayout = new QHBoxLayout();
	frameBaseLayout->addSpacing(10);
	frameBaseLayout->addLayout(inputBaseLayout);
	// define a label for the input area
	QLabel* sqlInputWLabel;
	sqlInputWLabel = new QLabel( baseFrame, "sqlInputWLabel" );
	sqlInputWLabel->setMinimumSize( 100, 20 );
	sqlInputWLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		sqlInputWLabel->setFont( font );
	}
	sqlInputWLabel->setFocusPolicy( QWidget::NoFocus );
	sqlInputWLabel->setBackgroundMode( QWidget::PaletteBackground );
	sqlInputWLabel->setFontPropagation( QWidget::NoChildren );
	sqlInputWLabel->setPalettePropagation( QWidget::NoChildren );
	sqlInputWLabel->setFrameStyle( 0 );
	sqlInputWLabel->setLineWidth( 1 );
	sqlInputWLabel->setMidLineWidth( 0 );
	sqlInputWLabel->QFrame::setMargin( 0 );
	sqlInputWLabel->setText( i18n("SQL Input:") );
	sqlInputWLabel->setAlignment( 289 );
	sqlInputWLabel->setMargin( -1 );
	// store the label within the inputBaseLayout
	inputBaseLayout->addSpacing(10);
	inputBaseLayout->addWidget(sqlInputWLabel);

	// create a purge button for the input area
	purgeInputButton = new QPushButton( baseFrame, "purgeInputWButton" );
	purgeInputButton->setMinimumSize( 100, 20 );
	purgeInputButton->setMaximumSize( 100, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		purgeInputButton->setFont( font );
	}
	connect( purgeInputButton, SIGNAL(clicked()), SLOT(purgeInputButtonClickedCB()) );
	purgeInputButton->setFocusPolicy( QWidget::TabFocus );
	purgeInputButton->setBackgroundMode( QWidget::PaletteBackground );
	purgeInputButton->setFontPropagation( QWidget::NoChildren );
	purgeInputButton->setPalettePropagation( QWidget::NoChildren );
	purgeInputButton->setText( i18n("Purge") );
	purgeInputButton->setAutoRepeat( FALSE );
	purgeInputButton->setAutoResize( FALSE );
	purgeInputButton->setToggleButton( FALSE );
	purgeInputButton->setDefault( FALSE );
	purgeInputButton->setAutoDefault( FALSE );
	purgeInputButton->setIsMenuButton( FALSE );
	// store the purge button within the inputBase Layout
	inputBaseLayout->addWidget(purgeInputButton);

	inputBaseLayout->addStretch(30);


	QLabel* sqlDBWLabel;
	sqlDBWLabel = new QLabel( baseFrame, "sqlDBWLabel" );
	sqlDBWLabel->setMinimumSize( 150, 20 );
	sqlDBWLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		sqlDBWLabel->setFont( font );
	}
	sqlDBWLabel->setFocusPolicy( QWidget::NoFocus );
	sqlDBWLabel->setBackgroundMode( QWidget::PaletteBackground );
	sqlDBWLabel->setFontPropagation( QWidget::NoChildren );
	sqlDBWLabel->setPalettePropagation( QWidget::NoChildren );
	sqlDBWLabel->setFrameStyle( 0 );
	sqlDBWLabel->setLineWidth( 1 );
	sqlDBWLabel->setMidLineWidth( 0 );
	sqlDBWLabel->QFrame::setMargin( 0 );
	sqlDBWLabel->setText( i18n("Active Connection:") );
	sqlDBWLabel->setAlignment( AlignRight );
	sqlDBWLabel->setMargin( -1 );
	// store the label within the inputBaseLayout
	inputBaseLayout->addWidget(sqlDBWLabel);
	inputBaseLayout->addSpacing(10);


	activeDbLabel = new QLabel( baseFrame, "activeDBWLabel" );
	activeDbLabel->setMinimumSize( 300, 20 );
	activeDbLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		activeDbLabel->setFont( font );
	}
	activeDbLabel->setFocusPolicy( QWidget::NoFocus );
	activeDbLabel->setBackgroundMode( QWidget::PaletteBackground );
	activeDbLabel->setFontPropagation( QWidget::NoChildren );
	activeDbLabel->setPalettePropagation( QWidget::NoChildren );
	activeDbLabel->setFrameStyle( 0 );
	activeDbLabel->setLineWidth( 1 );
	activeDbLabel->setMidLineWidth( 0 );
	activeDbLabel->QFrame::setMargin( 0 );
	activeDbLabel->setText( "---" );
	activeDbLabel->setAlignment( 292 );
	activeDbLabel->setMargin( -1 );
	activeDbLabel->setPalette(QPalette(QColor(80,255,80)));
	// store the label within the inputBaseLayout
	inputBaseLayout->addWidget(activeDbLabel);
	inputBaseLayout->addSpacing(10);




	// define a input layout for the text input
	QBoxLayout* inputLayout = new QHBoxLayout();
	frameBaseLayout->addSpacing(10);
	frameBaseLayout->addLayout(inputLayout,75);


	// create the input box for the sql
	sqlInputMultiText = new QMultiLineEdit( baseFrame, "sqlInputWMultiText" );
	sqlInputMultiText->setMinimumSize( 740, 100 );
	sqlInputMultiText->setFocusPolicy( QWidget::StrongFocus );
	sqlInputMultiText->setBackgroundMode( QWidget::PaletteBase );
	sqlInputMultiText->setFontPropagation( QWidget::SameFont );
	sqlInputMultiText->setPalettePropagation( QWidget::SameFont );
	sqlInputMultiText->setFrameStyle( 51 );
	sqlInputMultiText->setLineWidth( 2 );
	sqlInputMultiText->setMidLineWidth( 0 );
	sqlInputMultiText->QFrame::setMargin( 0 );
	sqlInputMultiText->insertLine( "" );
	sqlInputMultiText->setReadOnly( FALSE );
	sqlInputMultiText->setOverwriteMode( FALSE );
	sqlInputMultiText->setAutoUpdate( TRUE );
	// store the input are into the layout
	inputLayout->addSpacing(10);
	inputLayout->addWidget(sqlInputMultiText);
	inputLayout->addSpacing(10);


	QBoxLayout* outputBaseLayout = new QHBoxLayout();
	frameBaseLayout->addSpacing(10);
	frameBaseLayout->addLayout(outputBaseLayout);

	QLabel* sqlOutputWLabel;
	sqlOutputWLabel = new QLabel( baseFrame, "sqlOutputWLabel" );
	sqlOutputWLabel->setMinimumSize( 100, 20 );
	sqlOutputWLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		sqlOutputWLabel->setFont( font );
	}
	sqlOutputWLabel->setFocusPolicy( QWidget::NoFocus );
	sqlOutputWLabel->setBackgroundMode( QWidget::PaletteBackground );
	sqlOutputWLabel->setFontPropagation( QWidget::NoChildren );
	sqlOutputWLabel->setPalettePropagation( QWidget::NoChildren );
	sqlOutputWLabel->setFrameStyle( 0 );
	sqlOutputWLabel->setLineWidth( 1 );
	sqlOutputWLabel->setMidLineWidth( 0 );
	sqlOutputWLabel->QFrame::setMargin( 0 );
	sqlOutputWLabel->setText( i18n("SQL Output:") );
	sqlOutputWLabel->setAlignment( 289 );
	sqlOutputWLabel->setMargin( -1 );
	outputBaseLayout->addSpacing(10);
	outputBaseLayout->addWidget(sqlOutputWLabel);

	purgeOutputButton = new QPushButton( baseFrame, "purgeOutputWButton" );
	purgeOutputButton->setMinimumSize( 100, 20 );
	purgeOutputButton->setMaximumSize( 100, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		purgeOutputButton->setFont( font );
	}
	connect( purgeOutputButton, SIGNAL(clicked()), SLOT(purgeOutputButtonClickedCB()) );
	purgeOutputButton->setFocusPolicy( QWidget::TabFocus );
	purgeOutputButton->setBackgroundMode( QWidget::PaletteBackground );
	purgeOutputButton->setFontPropagation( QWidget::NoChildren );
	purgeOutputButton->setPalettePropagation( QWidget::NoChildren );
	purgeOutputButton->setText( i18n("Purge") );
	purgeOutputButton->setAutoRepeat( FALSE );
	purgeOutputButton->setAutoResize( FALSE );
	purgeOutputButton->setToggleButton( FALSE );
	purgeOutputButton->setDefault( FALSE );
	purgeOutputButton->setAutoDefault( FALSE );
	purgeOutputButton->setIsMenuButton( FALSE );
	outputBaseLayout->addWidget(purgeOutputButton);

	outputBaseLayout->addStretch(10);


        QBoxLayout* outputLayout = new QHBoxLayout();
	frameBaseLayout->addSpacing(10);
	frameBaseLayout->addLayout(outputLayout,100);
	sqlOutputMultiText = new QMultiLineEdit( baseFrame, "sqlOutputWMultiText" );
	sqlOutputMultiText->setMinimumSize( 740, 300 );
	{
		QFont font( "courier", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		sqlOutputMultiText->setFont( font );
	}
	sqlOutputMultiText->setFocusPolicy( QWidget::StrongFocus );
	sqlOutputMultiText->setBackgroundMode( QWidget::PaletteBase );
	sqlOutputMultiText->setFontPropagation( QWidget::SameFont );
	sqlOutputMultiText->setPalettePropagation( QWidget::SameFont );
	sqlOutputMultiText->setFrameStyle( 51 );
	sqlOutputMultiText->setLineWidth( 2 );
	sqlOutputMultiText->setMidLineWidth( 0 );
	sqlOutputMultiText->QFrame::setMargin( 0 );
	sqlOutputMultiText->insertLine( "" );
	sqlOutputMultiText->setReadOnly( TRUE );
	sqlOutputMultiText->setOverwriteMode( FALSE );
	sqlOutputMultiText->setAutoUpdate( TRUE );
	outputLayout->addSpacing(10);
	outputLayout->addWidget(sqlOutputMultiText);
	outputLayout->addSpacing(10);

	QBoxLayout* buttonLayout = new QHBoxLayout();
	frameBaseLayout->addSpacing(10);
	frameBaseLayout->addLayout(buttonLayout);
	frameBaseLayout->addSpacing(10);
	executeButton = new QPushButton( baseFrame, "executeWButton" );
	executeButton->setMinimumSize( 100, 30 );
	executeButton->setMaximumSize( 100, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		executeButton->setFont( font );
	}
	connect( executeButton, SIGNAL(clicked()), SLOT(executeButtonClickedCB()) );
	executeButton->setFocusPolicy( QWidget::TabFocus );
	executeButton->setBackgroundMode( QWidget::PaletteBackground );
	executeButton->setFontPropagation( QWidget::NoChildren );
	executeButton->setPalettePropagation( QWidget::NoChildren );
	executeButton->setText( i18n("Execute SQL") );
	executeButton->setAutoRepeat( FALSE );
	executeButton->setAutoResize( FALSE );
	executeButton->setToggleButton( FALSE );
	executeButton->setDefault( TRUE );
	executeButton->setAutoDefault( FALSE );
	executeButton->setIsMenuButton( FALSE );
	buttonLayout->addSpacing(10);
	buttonLayout->addWidget(executeButton);
	

	exitButton = new QPushButton( baseFrame, "exitWButton" );
	exitButton->setMinimumSize( 100, 30 );
	exitButton->setMaximumSize( 100, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		exitButton->setFont( font );
	}
	connect( exitButton, SIGNAL(clicked()), SLOT(exitButtonClickedCB()) );
	exitButton->setFocusPolicy( QWidget::TabFocus );
	exitButton->setBackgroundMode( QWidget::PaletteBackground );
	exitButton->setFontPropagation( QWidget::NoChildren );
	exitButton->setPalettePropagation( QWidget::NoChildren );
	exitButton->setText( i18n("Exit") );
	exitButton->setAutoRepeat( FALSE );
	exitButton->setAutoResize( FALSE );
	exitButton->setToggleButton( FALSE );
	exitButton->setDefault( FALSE );
	exitButton->setAutoDefault( FALSE );
	exitButton->setIsMenuButton( FALSE );

	buttonLayout->addSpacing(10);
	buttonLayout->addWidget(exitButton);
	buttonLayout->addStretch(10);

	

	resize( 800,600 );
	setMinimumSize( 800, 600 );

	setCaption( i18n("K ORACLE Sql Communicator") );

	sqlInputMultiText->setFocus();

	// before we display the logon window, we establish the connection to the server
	QString	logonMessage;

	if (!ServerWork::connectKOraServer(logonMessage))
	{
		// we couldn't connect to server
		KMsgBox::message(this, "KOra Server", logonMessage, KMsgBox::STOP);
	}
	else
	{
		KMsgBox::message(this, "KOra Server", logonMessage, KMsgBox::INFORMATION);

		KSqlLogon	logonWindow;
		logonWindow.show();
		activeDbLabel->setText(logonWindow.getActiveDb());
		if (logonWindow.getActiveDb() == "---")
			activeDbLabel->setPalette(QPalette(QColor(255,0,0)));
		else
			activeDbLabel->setPalette(QPalette(QColor(80,255,80)));
	}
}


KSqlMain::~KSqlMain()
{
}

void KSqlMain::executeButtonClickedCB()
{
	QString	sqlInput;
	QString	oraMessage;
	int	processedRows = 0;
	QString	sqlResult;

	sqlInput = sqlInputMultiText->text();
	KApplication::setOverrideCursor(waitCursor);

	if (ServerWork::executeSql(sqlInput, oraMessage, &processedRows, sqlResult))
	{
		KApplication::restoreOverrideCursor();
		sqlOutputMultiText->insertLine(sqlResult);
		sqlOutputMultiText->setCursorPosition(sqlOutputMultiText->numLines(), 1);
		KMsgBox::message(this, i18n("ORACLE Error"), oraMessage, KMsgBox::STOP);
	}
	else
	{
		sqlOutputMultiText->insertLine(sqlResult);
		sqlOutputMultiText->setCursorPosition(sqlOutputMultiText->numLines(), 1);
	}
	KApplication::restoreOverrideCursor();
}

void KSqlMain::exitButtonClickedCB()
{
	// First we have to terminate the connection to Oracle
	ServerWork::releaseFromOracle();
	ServerWork::releaseFromKOraS();
	exit(0);
}



void KSqlMain::fileMenuOpenCB()
{
	QString	fileName;
	QString	sqlInput;

	fileName = KFileDialog::getOpenFileName(NULL, "*.sql", this, i18n("Load ORACLE SQL File"));
	if (! fileName.isNull())
	{
		QFile file(fileName);

		if (! file.open(IO_ReadOnly))
		{
			KMsgBox::message(this, i18n("File open error"), i18n("Unable to open the specified file"), KMsgBox::STOP);
			return;
		}

		QTextStream text(&file);

		// ok, we have opened the file. Now read it line by line
		while(!text.eof())
		{
			sqlInput += text.readLine();
			sqlInput += "\n";
		}

		// close the file
		file.close();

		// fill the data into the input textfield
		sqlInputMultiText->clear();
		sqlInputMultiText->insertLine(sqlInput);
	}
}





void KSqlMain::connectionMenuReconnectCB()
{
	// close active connection to oracle
	ServerWork::releaseFromOracle();

	// define logon dialog
	KSqlLogon logonWindow;

	// show the logon window
	logonWindow.show();
	activeDbLabel->setText(logonWindow.getActiveDb());
	if (logonWindow.getActiveDb() == "---")
		activeDbLabel->setPalette(QPalette(QColor(255,0,0)));
	else
		activeDbLabel->setPalette(QPalette(QColor(80,255,80)));
}

void KSqlMain::helpMenuContentsCB()
{
	KApplication::getKApplication()->invokeHTMLHelp("","");
}

void KSqlMain::helpMenuAboutCB()
{
	KSqlAbout	aboutWindow;
	
	aboutWindow.show();
}

void KSqlMain::purgeInputButtonClickedCB()
{
	sqlInputMultiText->clear();
}

void KSqlMain::purgeOutputButtonClickedCB()
{
	sqlOutputMultiText->clear();
}

void KSqlMain :: viewerMenuSequencesCB()
{
	KSequenceViewer	sequenceViewerWindow;

	sequenceViewerWindow.show();
}

void KSqlMain :: viewerMenuSynonymsCB()
{
	KSynonymViewer	synonymViewerWindow;

	synonymViewerWindow.show();
}

void KSqlMain :: viewerMenuTablesCB()
{
	KTableViewer	tableViewerWindow;

	tableViewerWindow.show();
}

void KSqlMain :: viewerMenuPackagesCB()
{
	KPackageViewer	packageViewerWindow;
	
	packageViewerWindow.show();
}

