#include "TableViewData.h"
#include "kpanner.h"

#define Inherited QDialog

#ifndef rcsid
static const char rcsid[]="$Id: TableViewData.cpp,v 2.2 1999/07/04 22:30:44 ral Exp $";
const char*tableviewdata_rcs(){return rcsid;}
#endif

#include <kapp.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qlayout.h>

CTableViewData::CTableViewData
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name, FALSE,1028096 )
{
	QLabel* dlgedit_Label_15;
	dlgedit_Label_15 = new QLabel( this, "Label_15" );
	dlgedit_Label_15->setGeometry( 0, 0, 77, 15 );
	dlgedit_Label_15->setMinimumSize( 77, 15 );
	dlgedit_Label_15->setMaximumSize( 77, 15 );
	{
		QFont font( "helvetica", 10, 50, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		dlgedit_Label_15->setFont( font );
	}
	dlgedit_Label_15->setText( i18n("Select Data") );
	dlgedit_Label_15->setAlignment( 289 );
	dlgedit_Label_15->setMargin( -1 );

	ColumnDisplay = new QListBox( this, "ColumnDisplay" );
	ColumnDisplay->setGeometry( 0, 15, 179, 123 );
	ColumnDisplay->setMinimumSize( 10, 123 );
	ColumnDisplay->setMaximumSize( 32767, 123 );
	connect( ColumnDisplay, SIGNAL(selectionChanged()), SLOT(column_sel_change()) );
	ColumnDisplay->setFrameStyle( 51 );
	ColumnDisplay->setLineWidth( 2 );
	ColumnDisplay->setMultiSelection( TRUE );

	QLabel* dlgedit_Label_16;
	dlgedit_Label_16 = new QLabel( this, "Label_16" );
	dlgedit_Label_16->setGeometry( 0, 0, 70, 15 );
	dlgedit_Label_16->setMinimumSize( 70, 15 );
	dlgedit_Label_16->setMaximumSize( 70, 15 );
	{
		QFont font( "helvetica", 10, 50, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		dlgedit_Label_16->setFont( font );
	}
	dlgedit_Label_16->setText( i18n("Database") );
	dlgedit_Label_16->setAlignment( 289 );
	dlgedit_Label_16->setMargin( -1 );

	SelectDB = new QComboBox( FALSE, this, "ComboBox_4" );
	SelectDB->setGeometry( 0, 15, 121, 31 );
	SelectDB->setMinimumSize( 10, 31 );
	SelectDB->setMaximumSize( 32767, 31 );
	connect( SelectDB, SIGNAL(activated(int)), SLOT(db_select(int)) );
	SelectDB->setSizeLimit( 10 );
	SelectDB->setAutoResize( FALSE );
	SelectDB->insertItem( " Nothing selected" );

	QLabel* dlgedit_Label_17;
	dlgedit_Label_17 = new QLabel( this, "Label_17" );
	dlgedit_Label_17->setGeometry( 0, 46, 60, 15 );
	dlgedit_Label_17->setMinimumSize( 60, 15 );
	dlgedit_Label_17->setMaximumSize( 60, 15 );
	{
		QFont font( "helvetica", 10, 50, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		dlgedit_Label_17->setFont( font );
	}
	dlgedit_Label_17->setText( i18n("Table") );
	dlgedit_Label_17->setAlignment( 289 );
	dlgedit_Label_17->setMargin( -1 );

	TableSelect = new QComboBox( FALSE, this, "ComboBox_5" );
	TableSelect->setGeometry( 0, 61, 121, 31 );
	TableSelect->setMinimumSize( 10, 31 );
	TableSelect->setMaximumSize( 32767, 31 );
	connect( TableSelect, SIGNAL(activated(int)), SLOT(table_select(int)) );
	TableSelect->setSizeLimit( 10 );
	TableSelect->setAutoResize( FALSE );
	TableSelect->insertItem( " Nothing selected" );

	QLabel* dlgedit_Label_18;
	dlgedit_Label_18 = new QLabel( this, "Label_18" );
	dlgedit_Label_18->setGeometry( 0, 92, 70, 15 );
	dlgedit_Label_18->setMinimumSize( 70, 15 );
	dlgedit_Label_18->setMaximumSize( 70, 15 );
	{
		QFont font( "helvetica", 10, 50, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		dlgedit_Label_18->setFont( font );
	}
	dlgedit_Label_18->setText( i18n("Sort by") );
	dlgedit_Label_18->setAlignment( 289 );
	dlgedit_Label_18->setMargin( -1 );

	SortListBox = new QComboBox( FALSE, this, "SortList" );
	SortListBox->setGeometry( 0, 107, 121, 31 );
	SortListBox->setMinimumSize( 10, 31 );
	SortListBox->setMaximumSize( 32767, 31 );
	connect( SortListBox, SIGNAL(activated(int)), SLOT(sort_select(int)) );
	SortListBox->setSizeLimit( 10 );
	SortListBox->setAutoResize( FALSE );
	SortListBox->insertItem( " Nothing selected" );

	QLabel* dlgedit_Label_19;
	dlgedit_Label_19 = new QLabel( this, "Label_19" );
	dlgedit_Label_19->setGeometry( 0, 0, 77, 15 );
	dlgedit_Label_19->setMinimumSize( 77, 15 );
	dlgedit_Label_19->setMaximumSize( 77, 15 );
	{
		QFont font( "helvetica", 10, 50, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		dlgedit_Label_19->setFont( font );
	}
	dlgedit_Label_19->setText( i18n("Limit Offset") );
	dlgedit_Label_19->setAlignment( 289 );
	dlgedit_Label_19->setMargin( -1 );

	OffsetDisplay = new QLCDNumber( this, "LCDNumber_3" );
	OffsetDisplay->setGeometry( 0, 15, 90, 39 );
	OffsetDisplay->setMinimumSize( 90, 39 );
	OffsetDisplay->setMaximumSize( 90, 39 );
	OffsetDisplay->setFrameStyle( 34 );
	OffsetDisplay->setSmallDecimalPoint( FALSE );
	OffsetDisplay->setNumDigits( 5 );
	OffsetDisplay->setMode( QLCDNumber::DEC );
	OffsetDisplay->setSegmentStyle( QLCDNumber::Outline );

	OffsetSlider = new QScrollBar( this, "OffsetSlider" );
	OffsetSlider->setGeometry( 0, 54, 90, 15 );
	OffsetSlider->setMinimumSize( 90, 15 );
	OffsetSlider->setMaximumSize( 90, 15 );
	connect( OffsetSlider, SIGNAL(valueChanged(int)), SLOT(OffsetSet(int)) );
	OffsetSlider->setOrientation( QScrollBar::Horizontal );
	OffsetSlider->setRange( 0, 99 );

	QLabel* dlgedit_Label_20;
	dlgedit_Label_20 = new QLabel( this, "Label_20" );
	dlgedit_Label_20->setGeometry( 0, 69, 77, 15 );
	dlgedit_Label_20->setMinimumSize( 77, 15 );
	dlgedit_Label_20->setMaximumSize( 77, 15 );
	{
		QFont font( "helvetica", 10, 50, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		dlgedit_Label_20->setFont( font );
	}
	dlgedit_Label_20->setText( i18n("Limit Count") );
	dlgedit_Label_20->setAlignment( 289 );
	dlgedit_Label_20->setMargin( -1 );

	CountDisplay = new QLCDNumber( this, "LCDNumber_4" );
	CountDisplay->setGeometry( 0, 84, 90, 39 );
	CountDisplay->setMinimumSize( 90, 39 );
	CountDisplay->setMaximumSize( 90, 39 );
	CountDisplay->setFrameStyle( 34 );
	CountDisplay->setSmallDecimalPoint( FALSE );
	CountDisplay->setNumDigits( 5 );
	CountDisplay->setMode( QLCDNumber::DEC );
	CountDisplay->setSegmentStyle( QLCDNumber::Outline );

	CountSlider = new QScrollBar( this, "CountSlider" );
	CountSlider->setGeometry( 0, 123, 90, 15 );
	CountSlider->setMinimumSize( 90, 15 );
	CountSlider->setMaximumSize( 90, 15 );
	connect( CountSlider, SIGNAL(valueChanged(int)), SLOT(CountSet(int)) );
	CountSlider->setOrientation( QScrollBar::Horizontal );
	CountSlider->setRange( 0, 99 );

	AddRow = new QPushButton( this, "AddRow" );
	AddRow->setGeometry( 0, 0, 115, 46 );
	AddRow->setMinimumSize( 115, 46 );
	AddRow->setMaximumSize( 115, 46 );
	connect( AddRow, SIGNAL(clicked()), SLOT(addRow()) );
	AddRow->setText( i18n("&Add Row") );
	AddRow->setAutoRepeat( FALSE );
	AddRow->setAutoResize( FALSE );

	ModifyRow = new QPushButton( this, "ModifyRow" );
	ModifyRow->setGeometry( 0, 46, 115, 46 );
	ModifyRow->setMinimumSize( 115, 46 );
	ModifyRow->setMaximumSize( 115, 46 );
	connect( ModifyRow, SIGNAL(clicked()), SLOT(modifyRow()) );
	ModifyRow->setText( i18n("&Modify Row") );
	ModifyRow->setAutoRepeat( FALSE );
	ModifyRow->setAutoResize( FALSE );

	DeleteButton = new QPushButton( this, "DeleteButton" );
	DeleteButton->setGeometry( 0, 92, 115, 46 );
	DeleteButton->setMinimumSize( 115, 46 );
	DeleteButton->setMaximumSize( 115, 46 );
	connect( DeleteButton, SIGNAL(clicked()), SLOT(delete_row()) );
	DeleteButton->setText( i18n("Delete selected") );
	DeleteButton->setAutoRepeat( FALSE );
	DeleteButton->setAutoResize( FALSE );

	searchButton = new QPushButton( this, "searchButton" );
	searchButton->setGeometry( 0, 0, 115, 46 );
	searchButton->setMinimumSize( 115, 46 );
	searchButton->setMaximumSize( 115, 46 );
	connect( searchButton, SIGNAL(clicked()), SLOT(search_rows()) );
	searchButton->setText( i18n("&Search") );
	searchButton->setAutoRepeat( FALSE );
	searchButton->setAutoResize( FALSE );

	saveButton = new QPushButton( this, "saveButton" );
	saveButton->setGeometry( 0, 46, 115, 46 );
	saveButton->setMinimumSize( 115, 46 );
	saveButton->setMaximumSize( 115, 46 );
	connect( saveButton, SIGNAL(clicked()), SLOT(saveResult()) );
	saveButton->setText( i18n("Sa&ve") );
	saveButton->setAutoRepeat( FALSE );
	saveButton->setAutoResize( FALSE );

	EmptyTableButton = new QPushButton( this, "PushButton_6" );
	EmptyTableButton->setGeometry( 0, 92, 115, 46 );
	EmptyTableButton->setMinimumSize( 115, 46 );
	EmptyTableButton->setMaximumSize( 115, 46 );
	connect( EmptyTableButton, SIGNAL(clicked()), SLOT(emptyTable()) );
	EmptyTableButton->setText( i18n("Delete All") );
	EmptyTableButton->setAutoRepeat( FALSE );
	EmptyTableButton->setAutoResize( FALSE );

	//	OutputList = new QListBox( this, "OutputList" );
	//	KPanner*panner = new KPanner(this, "paner", KPanner::O_VERTICAL | KPanner::U_PERCENT, 30); 
	
	OutputList = new TabView(this);
	OutputList->setGeometry( 0, 0, 630, 277 );
	OutputList->setMinimumSize( 10, 10 );
	OutputList->setMaximumSize( 32767, 32767 );
	{
		QFont font( "Courier", 12, 50, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		OutputList->setFont( font );
	}
	OutputList->setSeparator('\t');
	OutputList->setAutoUpdate(true);
	connect( OutputList, SIGNAL(highlighted(int,int)), SLOT(OutputSelected(int,int)) );
	/*	OutputList->setFrameStyle( 51 );
	OutputList->setLineWidth( 2 );
	OutputList->setMultiSelection( FALSE );*/

	Go_Button = new QPushButton( this, "PushButton_7" );
	Go_Button->setGeometry( 0, 0, 158, 25 );
	Go_Button->setMinimumSize( 10, 25 );
	Go_Button->setMaximumSize( 32767, 25 );
	connect( Go_Button, SIGNAL(clicked()), SLOT(MakeRequest()) );
	Go_Button->setText( i18n("&Go!") );
	Go_Button->setAutoRepeat( FALSE );
	Go_Button->setAutoResize( FALSE );

	QPushButton* dlgedit_PushButton_8;
	dlgedit_PushButton_8 = new QPushButton( this, "PushButton_8" );
	dlgedit_PushButton_8->setGeometry( 473, 0, 157, 25 );
	dlgedit_PushButton_8->setMinimumSize( 10, 25 );
	dlgedit_PushButton_8->setMaximumSize( 32767, 25 );
	connect( dlgedit_PushButton_8, SIGNAL(clicked()), SLOT(hide()) );
	dlgedit_PushButton_8->setText( i18n("&Close") );
	dlgedit_PushButton_8->setAutoRepeat( FALSE );
	dlgedit_PushButton_8->setAutoResize( FALSE );

	RefreshListButton = new QPushButton( this, "RefreshButton" );
	RefreshListButton->setGeometry( 158, 0, 157, 25 );
	RefreshListButton->setMinimumSize( 10, 25 );
	RefreshListButton->setMaximumSize( 32767, 25 );
	connect( RefreshListButton, SIGNAL(clicked()), SLOT(RefreshLists()) );
	RefreshListButton->setText( i18n("&Refresh DB-List") );
	RefreshListButton->setAutoRepeat( FALSE );
	RefreshListButton->setAutoResize( FALSE );

	HelpButton = new QPushButton( this, "PushButton_10" );
	HelpButton->setGeometry( 315, 0, 158, 25 );
	HelpButton->setMinimumSize( 10, 25 );
	HelpButton->setMaximumSize( 32767, 25 );
	connect( HelpButton, SIGNAL(toggled(bool)), SLOT(showHelp(bool)) );
	HelpButton->setText( i18n("&Help") );
	HelpButton->setAutoRepeat( FALSE );
	HelpButton->setAutoResize( FALSE );

	QBoxLayout* dlgedit_layout_1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 3, NULL );
	dlgedit_layout_1->addStrut( 0 );
	QBoxLayout* dlgedit_layout_1_1 = new QBoxLayout( QBoxLayout::LeftToRight, 2, NULL );
	dlgedit_layout_1->addLayout( dlgedit_layout_1_1, 0 );
	dlgedit_layout_1_1->addStrut( 0 );
	QBoxLayout* dlgedit_layout_1_1_1 = new QBoxLayout( QBoxLayout::TopToBottom, 0, NULL );
	dlgedit_layout_1_1->addLayout( dlgedit_layout_1_1_1, 1 );
	dlgedit_layout_1_1_1->addStrut( 0 );
	dlgedit_layout_1_1_1->addWidget( dlgedit_Label_16, 0, 9 );
	dlgedit_layout_1_1_1->addWidget( SelectDB, 1, 9 );
	dlgedit_layout_1_1_1->addWidget( dlgedit_Label_17, 0, 9 );
	dlgedit_layout_1_1_1->addWidget( TableSelect, 1, 9 );
	dlgedit_layout_1_1_1->addWidget( dlgedit_Label_18, 0, 9 );
	dlgedit_layout_1_1_1->addWidget( SortListBox, 1, 9 );

	QBoxLayout* dlgedit_layout_1_1_2 = new QBoxLayout( QBoxLayout::TopToBottom, 0, NULL );
	dlgedit_layout_1_1->addLayout( dlgedit_layout_1_1_2, 2 );
	dlgedit_layout_1_1_2->addStrut( 0 );
	dlgedit_layout_1_1_2->addWidget( dlgedit_Label_15, 0, 9 );
	dlgedit_layout_1_1_2->addWidget( ColumnDisplay, 1, 36 );

	QBoxLayout* dlgedit_layout_1_1_3 = new QBoxLayout( QBoxLayout::TopToBottom, 0, NULL );
	dlgedit_layout_1_1->addLayout( dlgedit_layout_1_1_3, 0 );
	dlgedit_layout_1_1_3->addStrut( 0 );
	dlgedit_layout_1_1_3->addWidget( dlgedit_Label_19, 1, 9 );
	dlgedit_layout_1_1_3->addWidget( OffsetDisplay, 1, 9 );
	dlgedit_layout_1_1_3->addWidget( OffsetSlider, 1, 9 );
	dlgedit_layout_1_1_3->addWidget( dlgedit_Label_20, 1, 9 );
	dlgedit_layout_1_1_3->addWidget( CountDisplay, 1, 9 );
	dlgedit_layout_1_1_3->addWidget( CountSlider, 1, 9 );

	QBoxLayout* dlgedit_layout_1_1_4 = new QBoxLayout( QBoxLayout::LeftToRight, 0, NULL );
	dlgedit_layout_1_1->addLayout( dlgedit_layout_1_1_4, 0 );
	dlgedit_layout_1_1_4->addStrut( 0 );
	QBoxLayout* dlgedit_layout_1_1_4_1 = new QBoxLayout( QBoxLayout::TopToBottom, 0, NULL );
	dlgedit_layout_1_1_4->addLayout( dlgedit_layout_1_1_4_1, 0 );
	dlgedit_layout_1_1_4_1->addStrut( 0 );
	dlgedit_layout_1_1_4_1->addWidget( AddRow, 1, 9 );
	dlgedit_layout_1_1_4_1->addWidget( ModifyRow, 1, 9 );
	dlgedit_layout_1_1_4_1->addWidget( DeleteButton, 1, 9 );

	QBoxLayout* dlgedit_layout_1_1_4_2 = new QBoxLayout( QBoxLayout::TopToBottom, 0, NULL );
	dlgedit_layout_1_1_4->addLayout( dlgedit_layout_1_1_4_2, 0 );
	dlgedit_layout_1_1_4_2->addStrut( 0 );
	dlgedit_layout_1_1_4_2->addWidget( searchButton, 1, 9 );
	dlgedit_layout_1_1_4_2->addWidget( saveButton, 1, 9 );
	dlgedit_layout_1_1_4_2->addWidget( EmptyTableButton, 1, 9 );



	QBoxLayout* dlgedit_layout_1_2 = new QBoxLayout( QBoxLayout::TopToBottom, 0, NULL );
	dlgedit_layout_1->addLayout( dlgedit_layout_1_2, 1 );
	dlgedit_layout_1_2->addStrut( 0 );
	dlgedit_layout_1_2->addWidget(OutputList,1,36);	
	/*	QBoxLayout *rightLayout = new QBoxLayout(panner, QBoxLayout::LeftToRight);
		rightLayout->addWidget( OutputList, 1, 36 );*/

	QBoxLayout* dlgedit_layout_1_3 = new QBoxLayout( QBoxLayout::LeftToRight, 0, NULL );
	dlgedit_layout_1->addLayout( dlgedit_layout_1_3, 0 );
	dlgedit_layout_1_3->addStrut( 0 );
	dlgedit_layout_1_3->addWidget( Go_Button, 1, 36 );
	dlgedit_layout_1_3->addWidget( RefreshListButton, 1, 36 );
	dlgedit_layout_1_3->addWidget( HelpButton, 1, 36 );
	dlgedit_layout_1_3->addWidget( dlgedit_PushButton_8, 1, 36 );


	resize( 640,460 );
	setMinimumSize( 550, 350 );
	setMaximumSize( 32767, 32767 );
}


CTableViewData::~CTableViewData()
{
}
void CTableViewData::column_sel_change()
{
}
void CTableViewData::db_select(int)
{
}
void CTableViewData::table_select(int)
{
}
void CTableViewData::sort_select(int)
{
}
void CTableViewData::OffsetSet(int)
{
}
void CTableViewData::CountSet(int)
{
}
void CTableViewData::addRow()
{
}
void CTableViewData::modifyRow()
{
}
void CTableViewData::delete_row()
{
}
void CTableViewData::search_rows()
{
}
void CTableViewData::saveResult()
{
}
void CTableViewData::emptyTable()
{
}
void CTableViewData::OutputSelected(int)
{
}
void CTableViewData::MakeRequest()
{
}
void CTableViewData::RefreshLists()
{
}
void CTableViewData::showHelp(bool)
{
}
