/***************************************************************************
                          bibletimeprinter.h  -  description                              
                             -------------------                                         
    begin                : Thu Jul 8 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

/* $Header: /cvs/bibletime/bibletime/bibletime/printing/bibletimeprinter.h,v 1.4 1999/11/03 05:46:29 uhl Exp $ */
/* $Revision: 1.4 $ */

#ifndef BIBLETIMEPRINTER_H
#define BIBLETIMEPRINTER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>
#include <qfont.h>
#include <qcolor.h>
#include <qlist.h>

#include "advancedprinter.h"

struct KeyVerse
{
	QString key;
	QString data;
	bool		printKey;
	bool		printData;
};

typedef QList<KeyVerse> KeyVerseList;

/**	BibleTimePrinter is an abstraction layer for the printing functionality
		of BibleTime. All setting dialogs, font, color choosing are controlled
		by BibleTimePrinter
  *	@author Torsten Uhlmann
  */
class BibleTimePrinter : public QObject
{
	Q_OBJECT
	
public: 
	BibleTimePrinter(QObject *parent, const char * name=0);
	~BibleTimePrinter();
	/** start the printing process */
	bool printQueue();
	
public slots:
	/** set up the data to print */
	void slotSetPrintData(KeyVerseList*);
	/** if true, print key */
	void slotPrintKey(bool);
	/** if true, print data (verses or comments) */
	void slotPrintData(bool);
	/** set the new defaults from KConfig file */
	void slotSetDefaults();

signals:
	/** emitted when user aborted printing */
	void sigPrintingAborted(void);
	/** emitted when printing ended successfully */
	void sigPrintingDone(void);

protected:
	/** Handler of one object to print */
	bool printOneItem(AdvancedPrinter *btPrinter,QPainter *btPainter,KeyVerse *keyVerse);
	void printHeader(AdvancedPrinter *btPrinter, QPainter *btPainter);
	void printFooter(AdvancedPrinter *btPrinter, QPainter *btPainter);
	void initPrintValues(AdvancedPrinter*);
  /** start the application that handles previews */
  void startPreviewer(AdvancedPrinter*);
	
	// variables to store printing options
	/** store the printer font for the data to print */
	QFont					dataFont;
	/** store the printer font for the key of the verse */
	QFont					keyFont;
	QColor				dataColor;
	QColor				keyColor;
	bool					printKey;
	bool					printData;
	bool					printHeaderText;
	bool					printFooterText;
	QString				headText;
	QString				footText;
	int						leftBorder;
	int						rightBorder;
	int						upperBorder;
	int						lowerBorder;
	int						pageWidth;
	int						pageHeight;
	int						newLineSpace;
	int						newParagraphSpace;
	int						printFlag;
	int						currentPageNumber;
	int						totalPageNumber;
	KeyVerseList	*verseList;
	
	// variables that store the current state
	QRect					cR;
	
};

#endif

