/***************************************************************************
                          clinkmanagement.h  -  description                              
                             -------------------                                         
    begin                : Thu Oct 7 1999                                           
    copyright            : (C) 1999 by The team of BibleTime                         
    email                : BibleTime@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CLINKMANAGEMENT_H
#define CLINKMANAGEMENT_H

//Qt includes
#include <qwidget.h>
#include <qlistview.h>
#include <qheader.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qgroupbox.h>
#include <kapp.h>
#include <qlist.h>

//kde includes
#include <kseparator.h>

//own includes
#include "../structdef.h"

/**Manages the links.
	*You can define for
	*the filextesnion the program.
  *@author The team of BibleTime
  */

class CLinkManagement : public QWidget
{
   Q_OBJECT
public:
	CLinkManagement(QWidget *parent=0, const char *name=0);
	~CLinkManagement();
  /** Saves the entries to the config file */
  void saveSettings();
  /**  */
  void readSettings();

protected:
  /** Initialize the view. Creates the wigdgets and sets up Quickhelp  */
  virtual void initView();

	KSeparator	*main_Separator;
	QListView		*mainListView;
  QLabel			*ext_Label;
	QLineEdit		*ext_Edit;
  QLabel			*command_Label;
	QLineEdit		*command_Edit;
	QPushButton	*add_Button;		
	QPushButton	*change_Button;			
	QPushButton	*delete_Button;		
	QListViewItem	*currentItem;
  KConfig				* config;
	QList<QListViewItem>	*linkList;

protected slots: // Protected slots
  /** The resizeevent implementation
  	*/
  void resizeEvent( QResizeEvent *event );

  /** This is called when the extension of the currently selcted enttry chnaged.
  	*/
  void slotExtensionChanged(const char*);

  /** This slot deletes the currently selected entry in the list.
  	*/
  void slotDeleteClicked();

  /** This slot adds an entry to the list.
  	*/
  void slotAddClicked();

  /** This slot changes the current item
  	*/
  void slotChangeClicked();

  /** This is called when another entry was selected
  	*/
  void slotListSelectionChanged( QListViewItem* );

  /**	This is called when the commandline editline changed.
  */
  void slotCommandlineChanged(const char*);

signals:
  /** This is emitted whille saving the list.
  	*/
  void sigRefreshLinkLists();
};

#endif

























