/***************************************************************************
    kappldialog.h  -  Header file of class KApplDialog
    				  This is the Dialog for all applications found in the
    				  KDE directories
    ------------------------------------------------------------------------
    begin                : Thu Mar 18 1999                                           
    copyright            : (C) 1999 by Geri House                         
    email                : ge_ha@yahoo.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KAPPLDIALOG_H
#define KAPPLDIALOG_H

#include <qdialog.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qstrlist.h>

#include "kappllistbox.h"

/**
  * This class provides the list of all KDE application. It searches in the default KDE directories
  * for applications and displays them in a ListBox with their icons.
  * If your appication can't be found in the list the Dialog provides a FileDialog Button.
  * @author Geri House
  * @see KUninstallerView
  */


class KApplDialog : public QDialog  {

Q_OBJECT

public: 
  	/** Constructor */
	KApplDialog(QWidget * parent=0, const char * name=0, bool modal=FALSE);
  	/** Destructor */
	~KApplDialog();
  	/** overloaded  for change resize*/
  	void resizeEvent ( QResizeEvent * );
  	/** For inserting Applications into the Selction Box*/
  	void insertApplications();

signals:
  	/** signal for setting the Application Name in the View*/
	void setApplName(QStrList);
	
private slots:
	void closeWithSelection();	
	void openFileDialog();
	void doubleClickEvent(QListViewItem *);
private:
  	void insertApplications(QString, QListViewItem *);

  KApplListBox *listBox;
	QPushButton *backBtn;
 	QPushButton *forwardBtn;
 	};

#endif




































