/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <iostream.h>

#include "resbaseconf.h"


ResourceBaseConfig::ResourceBaseConfig()
{
  _iolist.setAutoDelete(true);
  _irqlist.setAutoDelete(true);
  _dma0list.setAutoDelete(true);
  _dma1list.setAutoDelete(true);
}


/*
 * Public methods
 *****************/
 
void  ResourceBaseConfig::addDMAPort(DMAPort *dma)
{
  if (dma->bits() == 8) _dma0list.append(dma);
  else 			_dma1list.append(dma);
}
 
 
bool  ResourceBaseConfig::contains(QList<Resource>& reslist)
{
  Resource  *res;
  
  for (res = reslist.first(); res; reslist.next())
  {
    if (reslist.at() < 0) break; // Qt bug? QList::at() yields -1, but QList::next() != 0L...
  
    switch (res->resourceType())
    {
      case Resource::ResIOAddress : if (!matchIOAddress((IOAddress *) res)) return false;
      				    break;
      case Resource::ResInterrupt : if (!matchIRQ((Interrupt *) res))       return false;
      				    break;
      case Resource::ResDMAPort   : if (!matchDMAPort((DMAPort *) res))     return false;
      				    break;
      default                     : return false;
    }
  }

  return true; 
}


QList<Resource>  ResourceBaseConfig::resourceList()
{
        QList<Resource>  reslist;
        IOBaseConfig	 *ioconf;
  const IOAddress        *port;
        Interrupt	 *irq;
        DMAPort 	 *dma0, *dma1;
  
  for (ioconf = _iolist.first(); ioconf; ioconf = _iolist.next())
    if ((port = ioconf->firstPort())) reslist.append(port);
    
  if ((irq  = _irqlist.first()))  reslist.append(irq);
  if ((dma0 = _dma0list.first())) reslist.append(dma0);
  if ((dma1 = _dma1list.first())) reslist.append(dma1);
  
  return reslist;
}


/*
 * Private methods
 ******************/

bool  ResourceBaseConfig::matchDMAPort(DMAPort *dmaport)
{
  DMAPort  *dma;
  
  if (dmaport->bits() == 8)
  {
    for (dma = _dma0list.first(); dma; dma = _dma0list.next())
      if (*dma == *dmaport) return true;
  }
  else
  {
    for (dma = _dma1list.first(); dma; dma = _dma1list.next())
      if (*dma == *dmaport) return true;  
  }  
  
  return false;
}


bool  ResourceBaseConfig::matchIOAddress(IOAddress *ioaddr)
{
        IOBaseConfig  *ioconf;
  const IOAddress     *io;
  
  for (ioconf = _iolist.first(); ioconf; ioconf = _iolist.next())
    for (io = ioconf->firstPort(); io; io = ioconf->nextPort())
      if (*io == *ioaddr) return true;
    
  return false;
}



bool  ResourceBaseConfig::matchIRQ(Interrupt *interrupt)
{
  Interrupt  *irq;

  for (irq = _irqlist.first(); irq; irq = _irqlist.next())
    if (*irq == *interrupt) return true;
    
  return false;
}


