/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <kapp.h>
#include <kiconloader.h>

#include "propsettab.h"
#include "scsidevice.h"


SettingsPropertiesTab::SettingsPropertiesTab(Device *device, QWidget *parent, 
					     const char *name) : QWidget(parent, name),
					     			 _device(device)
{
  QString  devname   = _device->deviceName();
  QString  classname = _device->deviceClassName();
  QString  target    = i18n("Target ID:");
  QString  lun       = i18n("Logical device unit:");
  QString  firm      = i18n("Firmware revision:");
  QString  numstr;
  bool     scsi;
  
  if (!classname.isEmpty()) devname += " ("+classname+")";
  
  _devtitle = new DeviceTitle(_device->bigPixmapFile(), devname, this, "devtitle");

  _targetlabel = new QLabel(this, "targetlabel");
  _lunlabel    = new QLabel(this, "lunlabel");
  _firmlabel   = new QLabel(this, "firmlabel");
  
  if ((scsi = (device->busType() == Device::BusSCSI)))
  {
    SCSIDevice  *scsidev = (SCSIDevice *) device;
    
    target += "     "+numstr.setNum(scsidev->targetID());
    lun    += "     "+numstr.setNum(scsidev->logicalUnit());
    firm   += "     "+numstr.setNum(scsidev->firmwareRevision());
  }
  
  _targetlabel->setText(target.data());
  _targetlabel->setEnabled(scsi);
  _targetlabel->adjustSize();
  
  _lunlabel->setText(lun.data());
  _lunlabel->setEnabled(scsi);
  _lunlabel->adjustSize();
  
  _firmlabel->setText(firm.data());
  _firmlabel->setEnabled(scsi);
  _firmlabel->adjustSize();
}


/*
 * Protected methods
 ********************/
 
void  SettingsPropertiesTab::resizeEvent(QResizeEvent *)
{
  uint  margin = 16;
  uint  w      = width();
  uint  infoy  = ((uint) 1.5*margin)+50;
  uint  infox;
  
  _devtitle->setGeometry(margin, margin, w-2*margin, 50);
  
  _targetlabel->move(margin, infoy);
  _lunlabel->move(margin, infoy+_targetlabel->height()+4);
  
  infox = QMAX(_targetlabel->width(), _lunlabel->width())+3*margin;
  
  _firmlabel->move(infox, infoy);
}

