/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include "isapnpdb.h"


ISAPnPDataBase::ISAPnPDataBase()
{
  setAutoDelete(true);
  clear();
  
  append(new ISAPnPDeviceInfo("CTL", 0x0024, 0x0031, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x0026, 0x0031, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x0027, 0x0031, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x002b, 0x0031, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x0039, 0x0031, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x0039, 0x0021, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x0042, 0x0031, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x0042, 0x0021, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x0044, 0x0031, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x0044, 0x0021, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x0048, 0x0031, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x0048, 0x0021, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x0070, 0x0001, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x009c, 0x0041, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x009c, 0x0021, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x009d, 0x0042, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x009d, 0x0022, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x009e, 0x0044, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x009e, 0x7002, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassInputOther));
  append(new ISAPnPDeviceInfo("CTL", 0x009e, 0x0023, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x00c1, 0x0042, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x00c1, 0x0022, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x00c3, 0x0045, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x00c3, 0x0022, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x00c5, 0x0045, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x00c5, 0x0022, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x00c7, 0x0045, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x00c7, 0x0022, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x00e4, 0x0045, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x00e4, 0x0022, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("CTL", 0x00f0, 0x0043, Device::BaseClassPCIMultimedia, ISAPnPDevice::ISAPnPClassMultimediaAudio));
  append(new ISAPnPDeviceInfo("ELS", 0x0133, 0x0133, Device::BaseClassPCINetwork,    ISAPnPDevice::ISAPnPClassNetworkOther));
}


ISAPnPDeviceInfo  *ISAPnPDataBase::find(const QString& vid, uint did, uint lid)
{
  ISAPnPDeviceInfo  *info;

  for (info = first(); info; info = next())
    if ((info->vendorID()  == vid) && 
        (info->deviceID()  == did) && 
	(info->logicalID() == lid)) return info;
    
  return 0L;
}
