/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __DMAPORT_H
#define __DMAPORT_H

#include <kapp.h>

#include "resource.h"


class DMAPort : public Resource
{
  public:
  
    DMAPort(ushort, ushort);
    ~DMAPort() {}
  
    bool     operator==(const DMAPort&);

    ushort   bits()         const { return _bits;       }
    QString  resourceName() const { return i18n("DMA"); }
    restype  resourceType() const { return ResDMAPort;  }

  private:
  
    ushort  _bits;
};


#endif
