/***************************************************************************
    $Id: kpcapi.cpp,v 1.8 1999/10/03 14:04:35 stephan Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: kpcapi.cpp,v $
    Revision 1.8  1999/10/03 14:04:35  stephan
    Cleanup.

    Revision 1.7  1999/10/01 17:42:27  stephan
    Bughunting.

    Revision 1.6  1999/09/30 20:46:47  wdl
    fixed some things with pointers in kpclib for removeprinter

    Revision 1.5  1999/09/29 17:51:10  stephan
    Fixed printer remove method in kpcAPI.

    Revision 1.4  1999/09/26 15:43:03  stephan
    Bugfixes.

    Revision 1.3  1999/09/20 13:40:52  stephan
    Added a filter for KpcAPI::getInstalledPrinters

    Revision 1.2  1999/09/19 13:45:14  wdl
     name change getInstalledPrinter to getInstalledPrinters

    Revision 1.1  1999/09/14 00:26:24  wdl
    Restructuring of directories

    Revision 1.11  1999/09/12 10:28:11  stephan
    Bugfixes and some changes for the shared lib

    Revision 1.10  1999/09/09 11:28:43  stephan
    Fixed some things for the new spool handling

    Revision 1.9  1999/09/09 06:01:57  stephan
    Added OO style spool handling (by using KpcSpool)

    Revision 1.8  1999/08/30 15:48:19  stephan
    Bug fixes

    Revision 1.7  1999/08/29 15:03:40  stephan
    Added 2 methods for user specific printers which are not in the db

    Revision 1.6  1999/08/27 16:43:01  wdl
    Standard Headers

 ***************************************************************************/
#include "kpcapi.h"

KpcAPI::KpcAPI(){
	tmpPrinterDB = new printerDB();
	t_cfg = new KSimpleConfig(kapp->kde_configdir() + "/kpc");
	t_cfg->setGroup("global");
	pn = t_cfg->readNumEntry("PrinterNo");
	int count;
	QString *t_Str = new QString;
	QString *t_grp = new QString;
	QString *t_mdl = new QString;
	KpcPrinter *t_prt = new KpcPrinter;
	if(pn > 0) {
		for( count = 1; count <= pn; count++) {
			t_cfg->setGroup("global");
			t_Str->setNum(count);
			t_Str->prepend("Printer");
			*t_grp = t_cfg->readEntry(t_Str->data());
			t_cfg->setGroup(t_grp->data());			
			*t_mdl = t_cfg->readEntry("Model");
			t_prt->setModel(t_mdl->data());
			t_prt->setDbName(t_grp->data());
      t_prt->setManufactor(t_cfg->readEntry("Manufactor").data());
			t_prt->setDefaultPrinter(t_cfg->readBoolEntry("Default"));

			if(strcmp(t_cfg->readEntry("Network","local").data(),"local") == 0) t_prt->setNetworkType(KpcPrinter::local);
			if(strcmp(t_cfg->readEntry("Network","local").data(),"lpd") == 0) t_prt->setNetworkType(KpcPrinter::lpd);
			if(strcmp(t_cfg->readEntry("Network","local").data(),"smb") == 0) t_prt->setNetworkType(KpcPrinter::smb);			
			if(strcmp(t_cfg->readEntry("Network","local").data(),"appletalk") == 0) t_prt->setNetworkType(KpcPrinter::appletalk);
			if(strcmp(t_cfg->readEntry("Network","local").data(),"netware") == 0) t_prt->setNetworkType(KpcPrinter::netware);
			if(strcmp(t_cfg->readEntry("Network","local").data(),"ethernet") == 0) t_prt->setNetworkType(KpcPrinter::ethernet);

			t_prt->setPaperFormat(t_cfg->readEntry("PaperFormat").data());
			t_prt->setPort(t_cfg->readEntry("Port").data());
			t_prt->setRemoteMachine(t_cfg->readEntry("RemoteMachine").data());
			t_prt->setRemoteQueue(t_cfg->readEntry("RemoteQueue").data());

			t_prt->setGSOptions(t_cfg->readEntry("GSOptions").data());
			t_prt->setGSDriver(t_cfg->readEntry("GSDriver").data());
			// printer spools handling
			printf("\n%s {\n",t_prt->getDbName());
			int spl_count;
			QString *t_spl_str = new QString;
			KpcSpool *t_spl = new KpcSpool;
			for(spl_count = 1; spl_count <= t_cfg->readNumEntry("SpoolCount"); spl_count++){
				t_spl_str->setNum(spl_count);
				t_spl_str->prepend("Spool_Name");
				t_spl->setName(t_cfg->readEntry(t_spl_str->data()));
	      t_spl_str->setNum(spl_count);
				t_spl_str->prepend("Spool_Color");
				if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"color") == 0)
				{ t_spl->setColor(KpcSpool::color); } else {t_spl->setColor(KpcSpool::mono); }
				t_spl_str->setNum(spl_count);
				t_spl_str->prepend("Spool_PaperFormat");
        if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"default") == 0) t_spl->setPaperFormat(KpcSpool::def);
				if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"a2") == 0) t_spl->setPaperFormat(KpcSpool::a2);
				if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"a3") == 0) t_spl->setPaperFormat(KpcSpool::a3);
				if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"a4") == 0) t_spl->setPaperFormat(KpcSpool::a4);
				if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"a5") == 0) t_spl->setPaperFormat(KpcSpool::a5);
				if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"b5") == 0) t_spl->setPaperFormat(KpcSpool::b5);
				if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"Letter") == 0) t_spl->setPaperFormat(KpcSpool::Letter);
				if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"legal") == 0) t_spl->setPaperFormat(KpcSpool::legal);
				t_spl_str->setNum(spl_count);
				t_spl_str->prepend("Spool_TypeRecognition");
				if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"automatic") == 0) t_spl->setTypeRecognition(KpcSpool::automatic);
				if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"raw") == 0) t_spl->setTypeRecognition(KpcSpool::raw);
				if(strcmp(t_cfg->readEntry(t_spl_str->data()).data(),"ascii") == 0) t_spl->setTypeRecognition(KpcSpool::ascii);
			  t_spl_str->setNum(spl_count);
				t_spl_str->prepend("Spool_DefaultSpool");
				if(t_cfg->readBoolEntry( t_spl_str->data() ) ) { t_spl->setDefaultSpool(true); } else { t_spl->setDefaultSpool(false);}
				t_spl_str->setNum(spl_count);
				t_spl_str->prepend("Spool_Xres");
				t_spl->setXres(t_cfg->readNumEntry(t_spl_str->data()));
        t_spl_str->setNum(spl_count);
				t_spl_str->prepend("Spool_Yres");
				t_spl->setYres(t_cfg->readNumEntry(t_spl_str->data()));
		    t_prt->addSpool(new KpcSpool(*t_spl));
				printf("\t%s\n",t_spl->getName());
			}
			delete(t_spl); delete(t_spl_str);
			printf("}\n");
			installedPrinter.append(new KpcPrinter(*t_prt));
		}
	} else {
		// no printer installed (by kpc)
		installedPrinter.clear();
	}
	delete(t_Str); delete(t_prt); delete(t_grp); delete(t_mdl);
}

KpcAPI::~KpcAPI(){
}


QList<QString> KpcAPI::getManufactorList(){
	return tmpPrinterDB->getManufactorNameLst();	
}

QList<QString> KpcAPI::getPrinterLst(const char *val){

	return tmpPrinterDB->getPrinterLst(val);	
}

QList<QString> KpcAPI::getInstalledPrinters(){
	KpcPrinter *t_kpcPrt = new KpcPrinter();
	QList<QString> t_lst;
	QString *t_str = new QString;
	t_lst.clear();
	for(t_kpcPrt = installedPrinter.first(); t_kpcPrt != 0; t_kpcPrt = installedPrinter.next()){
		*t_str = t_kpcPrt->getManufactor();
		t_str->append(" ");
		t_str->append(t_kpcPrt->getModel());
		t_lst.append(new QString(*t_str));
	}		
	delete(t_str);
	delete(t_kpcPrt);
	return t_lst;
}

QList<QString> KpcAPI::getInstalledPrinters(KpcPrinter::netType net_type)
{
  KpcPrinter *t_kpcPrt = new KpcPrinter();
	QList<QString> t_lst;
	QString *t_str = new QString;
	t_lst.clear();
	for(t_kpcPrt = installedPrinter.first(); t_kpcPrt != 0; t_kpcPrt = installedPrinter.next()){
		if(t_kpcPrt->getNetworkType() == net_type) {
			*t_str = t_kpcPrt->getManufactor();
			t_str->append(" ");
			t_str->append(t_kpcPrt->getModel());
			t_lst.append(new QString(*t_str));
		}
	}		
	delete(t_str);
	delete(t_kpcPrt);
	return t_lst;
}

bool KpcAPI::isDbNamePresent(const char *val){
	KpcPrinter *t_prtChk = new KpcPrinter;
	
	for( t_prtChk = installedPrinter.first(); t_prtChk != 0; t_prtChk = installedPrinter.next() ){
		if(strcmp(t_prtChk->getDbName(),val) == 0) { printf("\nKpcAPI::isDbNamePresent() == true\n"); return true; }
	}
	delete(t_prtChk);
	printf("\nKpcAPI::isDbNamePresent() == false\n");
	return false;
}

void KpcAPI::addPrinter(KpcPrinter *t_add){
	// requirements check
	if((t_add->getNetworkType() == KpcPrinter::lpd) && (LPDfilter::check() == false))
	{
		
		if(QMessageBox::critical(0,"Error!","To print to a unix/lpd host (conf. with kpc) the rlpr programm is needed\n\nYou can get it at metalab.unc.edu/pub/Linux/system/printing/.\nInstall it and try again")==0) exit(0);
	}
  if((t_add->getNetworkType() == KpcPrinter::smb) && (SMBfilter::check() == false))
	{
		
		if(QMessageBox::critical(0,"Error!","To print to a Windows/LanMan/SMB host (conf. with kpc) SAMBA(smblcient) programm is needed\n\nYou can get it at www.samba.org.\nInstall and configure samba and try again")==0) exit(0);
	}
	// check if a printer with same manufact. + model. is already present

	QString *t_dbname = new QString;
	QString *t_name = new QString(t_add->getModel());
	QList<KpcSpool> *t_spoolLst = new QList<KpcSpool>;
	KpcSpool *t_spool = new KpcSpool;
	int t_c,spl_c;
	t_c = 0; spl_c = 0;
	*t_spoolLst = t_add->getSpoolLst();
  while(isDbNamePresent(t_add->getDbName())){
		t_c++; t_dbname->setNum(t_c);
		t_dbname->prepend(" ");
		t_dbname->prepend(t_name->data());
		t_add->setDbName(t_dbname->data());
	}
	delete(t_name);
	delete(t_dbname);
	// look up specs if necessary
   printerDBentry *t_DbEntry = new printerDBentry();
	 *t_DbEntry = tmpPrinterDB->getPrinterSPEC(t_add->getManufactor(),t_add->getModel());
	 if(t_add->getGSDriver() == 0) t_add->setGSDriver(*(new QString(t_DbEntry->getGSdriver())));
	 if(t_add->getGSOptions() == 0) t_add->setGSOptions(*(new QString(t_DbEntry->getGSoptions())));
   delete(t_DbEntry);
  // --
	installedPrinter.append(new KpcPrinter(*t_add));
	QString *t_str = new QString;
	pn++;
	
	t_str->setNum(pn);
	t_str->prepend("Printer");
	t_cfg->setGroup("global");
	t_cfg->writeEntry("PrinterNo",pn);
	t_cfg->writeEntry(t_str->data(),t_add->getDbName());
	t_cfg->setGroup(t_add->getDbName());
	t_cfg->writeEntry("Model",t_add->getModel());
	t_cfg->writeEntry("Manufactor",t_add->getManufactor());
	t_cfg->writeEntry("Default",t_add->isDefaultPrinter());
	t_cfg->writeEntry("Port",t_add->getPort());
	t_cfg->writeEntry("PaperFormat",t_add->getPaperFormat());
	t_cfg->writeEntry("GSDriver",t_add->getGSDriver());
	t_cfg->writeEntry("GSOptions",t_add->getGSOptions());
	for(t_spool = t_spoolLst->first(); t_spool != 0; t_spool = t_spoolLst->next()){
		spl_c++;
		t_str->setNum(spl_c);
		t_str->prepend("Spool_Name");
		t_cfg->writeEntry(t_str->data(),t_spool->getName());
		printf("\nspoolnames: %s\n",t_str->data());
		t_str->setNum(spl_c);
		t_str->prepend("Spool_Color");
    if(t_spool->getColor() == KpcSpool::color) t_cfg->writeEntry(t_str->data(),"color");
		if(t_spool->getColor() == KpcSpool::mono) t_cfg->writeEntry(t_str->data(),"mono");
		t_str->setNum(spl_c);
		t_str->prepend("Spool_PaperFormat");
		if(t_spool->getPaperFormat() == KpcSpool::def) t_cfg->writeEntry(t_str->data(),"default");
		if(t_spool->getPaperFormat() == KpcSpool::a2) t_cfg->writeEntry(t_str->data(),"a2");
		if(t_spool->getPaperFormat() == KpcSpool::a3) t_cfg->writeEntry(t_str->data(),"a3");
		if(t_spool->getPaperFormat() == KpcSpool::a4) t_cfg->writeEntry(t_str->data(),"a4");
		if(t_spool->getPaperFormat() == KpcSpool::a5) t_cfg->writeEntry(t_str->data(),"a5");
		if(t_spool->getPaperFormat() == KpcSpool::b5) t_cfg->writeEntry(t_str->data(),"b5");
		if(t_spool->getPaperFormat() == KpcSpool::legal) t_cfg->writeEntry(t_str->data(),"legal");
		if(t_spool->getPaperFormat() == KpcSpool::Letter) t_cfg->writeEntry(t_str->data(),"Letter");		
    t_str->setNum(spl_c);
		t_str->prepend("Spool_TypeRecognition");
		if(t_spool->getTypeRecognition() == KpcSpool::automatic) t_cfg->writeEntry(t_str->data(),"automatic");
		if(t_spool->getTypeRecognition() == KpcSpool::raw) t_cfg->writeEntry(t_str->data(),"raw");
		if(t_spool->getTypeRecognition() == KpcSpool::ascii) t_cfg->writeEntry(t_str->data(),"ascii");
		t_str->setNum(spl_c);
		t_str->prepend("Spool_DefaultSpool");
		if(t_spool->isDefaultSpool()) t_cfg->writeEntry(t_str->data(),true);
		if(!t_spool->isDefaultSpool()) t_cfg->writeEntry(t_str->data(),false);		
		t_str->setNum(spl_c);
		t_str->prepend("Spool_Xres");
		t_cfg->writeEntry(t_str->data(),t_spool->getXres());
    t_str->setNum(spl_c);
		t_str->prepend("Spool_Yres");
		t_cfg->writeEntry(t_str->data(),t_spool->getYres());
	}

	t_cfg->writeEntry("SpoolCount",spl_c);
	
	if(t_add->getNetworkType() == KpcPrinter::lpd) {
		t_cfg->writeEntry("Network","lpd");
		t_cfg->writeEntry("RemoteMachine",t_add->getRemoteMachine());
		t_cfg->writeEntry("RemoteQueue",t_add->getRemoteQueue());
	}
	if(t_add->getNetworkType() == KpcPrinter::smb) {
		t_cfg->writeEntry("Network","smb");
		t_cfg->writeEntry("RemoteMachine",t_add->getRemoteMachine());
		t_cfg->writeEntry("RemoteQueue",t_add->getRemoteQueue());
	}
	if(t_add->getNetworkType() == KpcPrinter::appletalk) {
		t_cfg->writeEntry("Network","appletalk");
		t_cfg->writeEntry("RemoteMachine",t_add->getRemoteMachine());
		t_cfg->writeEntry("RemoteQueue",t_add->getRemoteQueue());
	}
	if(t_add->getNetworkType() == KpcPrinter::netware) {
		t_cfg->writeEntry("Network","netware");
		t_cfg->writeEntry("RemoteMachine",t_add->getRemoteMachine());
		t_cfg->writeEntry("RemoteQueue",t_add->getRemoteQueue());
	}
	if(t_add->getNetworkType() == KpcPrinter::ethernet) {
		t_cfg->writeEntry("Network","ethernet");
		t_cfg->writeEntry("RemoteMachine",t_add->getRemoteMachine());
		t_cfg->writeEntry("RemoteQueue",t_add->getRemoteQueue());
	}
	
}

void KpcAPI::removePrinter(KpcPrinter *t_rmv){
	QString *t_SpoolDir = new QString;
	QString *t_str = new QString;
	QString *t_key = new QString;
	QList<QString> *t_lst = new QList<QString>;
	printerDBentry *t_DbEntry = new printerDBentry();
	QList<KpcSpool> *t_splLst = new QList<KpcSpool>;
	KpcSpool *t_spl = new KpcSpool;
	int count;
	// remove spool dirs
	KpcPrinter *t_prt = 0;
	KpcPrinter *t_rmv_prt = 0;
	for(t_prt = installedPrinter.first(); t_prt != 0; t_prt = installedPrinter.next()){
		if(strcmp(t_rmv->getDbName(),t_prt->getDbName()) == 0){
			t_rmv_prt = t_prt;
			installedPrinter.remove();
		}
	}
	if( t_rmv_prt != 0 ) {
		*t_DbEntry = tmpPrinterDB->getPrinterSPEC(t_rmv->getManufactor(), t_rmv->getModel());
	 	*t_splLst = t_rmv_prt->getSpoolLst();
		for(t_spl = t_splLst->first(); t_spl != 0; t_spl = t_splLst->next()) {
			*t_SpoolDir = t_spl->getName();
			//t_SpoolDir->prepend(" ");
			//t_SpoolDir->prepend(t_rmv->getManufactor());
			t_SpoolDir->replace(QRegExp(" "),"-");
			t_SpoolDir->prepend("rm -r /var/spool/lpd/");
			system(t_SpoolDir->data());
			printf("\nremove -> %s\n",t_SpoolDir->data());
		}
		// remove entry from kpcs db
		t_cfg->setGroup("global");
		printf("Num: %d\n",pn);
		for(count = 1; count <= pn; count++) {
			t_str->setNum(count);
			t_str->prepend("Printer");
			t_lst->append(new QString(t_cfg->readEntry(t_str->data()).data()));					
			t_cfg->deleteEntry(t_str->data(),false);
			printf("\ndeleteEntry(%s);\n",t_str->data());
		}
		count = 0;
		for(t_str = t_lst->first(); t_str != 0; t_str = t_lst->next()){
			count++;
			t_key->setNum(count); t_key->prepend("Printer");
			if(strcmp(t_str->data(),t_rmv->getDbName()) != 0) t_cfg->writeEntry(t_key->data(), t_str->data());
		}
		delete(t_str);
		t_str = new QString();
		t_str->setNum(pn);
		t_str->prepend("Printer");
		t_cfg->deleteEntry(t_rmv->getDbName(),true);
	
		pn--;
		t_cfg->writeEntry("PrinterNo",pn);
		t_cfg->deleteGroup(t_rmv->getDbName());
		t_cfg->sync();
		// clean up
		delete(t_SpoolDir);
		delete(t_DbEntry);
		delete(t_lst); delete(t_str); delete(t_key);
	}
}

void KpcAPI::removePrinter(int no){
	removePrinter(installedPrinter.at(no));
}

void KpcAPI::sync(){
	KpcPrinter *t_kpcPrt = new KpcPrinter;
	printcap *t_Printcap = new printcap("/etc/printcap");	
  QDir *t_dir = new QDir();
	QString *t_SpoolDir = new QString;
	QString *t_alias = new QString;
	printerDBentry *t_DbEntry = new printerDBentry();

  apsfilterConfig *t_apsCfgMono =	new apsfilterConfig();
	apsfilterConfig *t_apsCfgColor = new apsfilterConfig();
	apsfilter *t_aps = new apsfilter(kapp->kde_datadir() + "/kpcwizard/filter/");

	KpcSpool *t_spool = new KpcSpool();
	QList<KpcSpool> *t_spoolLst = new QList<KpcSpool>;

	for( t_kpcPrt = installedPrinter.first(); t_kpcPrt != 0; t_kpcPrt = installedPrinter.next() ) {
	  *t_DbEntry = tmpPrinterDB->getPrinterSPEC(t_kpcPrt->getManufactor(),t_kpcPrt->getModel());

// LOCAL
    if(t_kpcPrt->getNetworkType() == KpcPrinter::local){
			printcapEntry *t_PrintcapEntryColor = new printcapEntry();

			*t_spoolLst = t_kpcPrt->getSpoolLst();
      for(t_spool = t_spoolLst->first(); t_spool != 0; t_spool = t_spoolLst->next()){
				// 1st step: do the spooldir stuff
					*t_SpoolDir = t_spool->getName(); t_SpoolDir->append("/");
					t_SpoolDir->replace(QRegExp(" "),"-");
					t_SpoolDir->prepend("/var/spool/lpd/");
					t_dir->mkdir(t_SpoolDir->data());
        // 2nd step: do the apsfilter stuff
					if(t_spool->getColor() == KpcSpool::color) t_apsCfgColor->setEnableColor(true);
					if(t_spool->getColor() == KpcSpool::mono) t_apsCfgColor->setEnableColor(false);
					t_apsCfgColor->setFilterDir(t_SpoolDir->data());
					t_apsCfgColor->setGSDriver(t_kpcPrt->getGSDriver());
					t_apsCfgColor->setGSoptions(t_kpcPrt->getGSOptions());
					if(t_spool->getTypeRecognition() == KpcSpool::automatic) t_apsCfgColor->setTypeRecognition("auto");
		      if(t_spool->getTypeRecognition() == KpcSpool::raw) t_apsCfgColor->setTypeRecognition("raw");
					if(t_spool->getTypeRecognition() == KpcSpool::ascii)t_apsCfgColor->setTypeRecognition("ascii");
					if(t_spool->getPaperFormat() == KpcSpool::def) t_apsCfgColor->setPaperSize("default");
          if(t_spool->getPaperFormat() == KpcSpool::a2)  t_apsCfgColor->setPaperSize("a2");
					if(t_spool->getPaperFormat() == KpcSpool::a3) t_apsCfgColor->setPaperSize("a3");
					if(t_spool->getPaperFormat() == KpcSpool::a4) t_apsCfgColor->setPaperSize("a4");
					if(t_spool->getPaperFormat() == KpcSpool::a5) t_apsCfgColor->setPaperSize("a5");
					if(t_spool->getPaperFormat() == KpcSpool::b5) t_apsCfgColor->setPaperSize("b5");
          if(t_spool->getPaperFormat() == KpcSpool::Letter) t_apsCfgColor->setPaperSize("Letter");
	        if(t_spool->getPaperFormat() == KpcSpool::legal) t_apsCfgColor->setPaperSize("legal");
          t_aps->setup(*(new apsfilterConfig(*t_apsCfgColor)));
				// 3rd step: do the printcap stuff
					*t_alias = t_spool->getName();
					if(t_spool->isDefaultSpool()) t_PrintcapEntryColor->setDefaultQueue(true);
					t_PrintcapEntryColor->addAlias(t_spool->getName());
					t_PrintcapEntryColor->setLogFile(*(new QString(*t_SpoolDir + "/log")));
          t_PrintcapEntryColor->setAccountFile(*(new QString(*t_SpoolDir + "/acct")));
					t_PrintcapEntryColor->setSpoolDir(t_SpoolDir->data());
					t_PrintcapEntryColor->setPrinterPort(t_kpcPrt->getPort());
					t_PrintcapEntryColor->setFilterName(*(new QString(t_aps->getFilterName())));
					t_Printcap->write(new printcapEntry(*t_PrintcapEntryColor));
			}

				
			// last but not least...mem cleanup
      delete(t_PrintcapEntryColor);
// LPD NETWORK PRINTER
		} else if(t_kpcPrt->getNetworkType() == KpcPrinter::lpd) {
				 printcapEntry *t_PrintcapEntryColor = new printcapEntry();

				*t_spoolLst = t_kpcPrt->getSpoolLst();
	      for(t_spool = t_spoolLst->first(); t_spool != 0; t_spool = t_spoolLst->next()){
				// 1st step: do the spooldir stuff
					*t_SpoolDir = t_spool->getName(); t_SpoolDir->append("/");
					t_SpoolDir->replace(QRegExp(" "),"-");
					t_SpoolDir->prepend("/var/spool/lpd/");
					t_dir->mkdir(t_SpoolDir->data());
        // 2nd step: do the apsfilter stuff
					if(t_spool->getColor() == KpcSpool::color) t_apsCfgColor->setEnableColor(true);
					if(t_spool->getColor() == KpcSpool::mono) t_apsCfgColor->setEnableColor(false);
					t_apsCfgColor->setFilterDir(t_SpoolDir->data());
					t_apsCfgColor->setGSDriver(t_kpcPrt->getGSDriver());
					t_apsCfgColor->setGSoptions(t_kpcPrt->getGSOptions());
					if(t_spool->getTypeRecognition() == KpcSpool::automatic) t_apsCfgColor->setTypeRecognition("auto");
		      if(t_spool->getTypeRecognition() == KpcSpool::raw) t_apsCfgColor->setTypeRecognition("raw");
					if(t_spool->getTypeRecognition() == KpcSpool::ascii)t_apsCfgColor->setTypeRecognition("ascii");
					if(t_spool->getPaperFormat() == KpcSpool::def) t_apsCfgColor->setPaperSize("default");
          if(t_spool->getPaperFormat() == KpcSpool::a2)  t_apsCfgColor->setPaperSize("a2");
					if(t_spool->getPaperFormat() == KpcSpool::a3) t_apsCfgColor->setPaperSize("a3");
					if(t_spool->getPaperFormat() == KpcSpool::a4) t_apsCfgColor->setPaperSize("a4");
					if(t_spool->getPaperFormat() == KpcSpool::a5) t_apsCfgColor->setPaperSize("a5");
					if(t_spool->getPaperFormat() == KpcSpool::b5) t_apsCfgColor->setPaperSize("b5");
          if(t_spool->getPaperFormat() == KpcSpool::Letter) t_apsCfgColor->setPaperSize("Letter");
	        if(t_spool->getPaperFormat() == KpcSpool::legal) t_apsCfgColor->setPaperSize("legal");
          t_aps->setup(*(new apsfilterConfig(*t_apsCfgColor)));
				// additional lpdfilter stuff......
					LPDfilter *t_lpdfilter = new LPDfilter(*t_aps,t_kpcPrt->getRemoteMachine(),t_kpcPrt->getRemoteQueue());
					t_lpdfilter->setup();
				// 3rd step: do the printcap stuff
					*t_alias = t_spool->getName();
					if(t_spool->isDefaultSpool()) t_PrintcapEntryColor->setDefaultQueue(true);
					t_PrintcapEntryColor->addAlias(t_spool->getName());
					t_PrintcapEntryColor->setLogFile(*(new QString(*t_SpoolDir + "/log")));
          t_PrintcapEntryColor->setAccountFile(*(new QString(*t_SpoolDir + "/acct")));
					t_PrintcapEntryColor->setSpoolDir(t_SpoolDir->data());
					t_PrintcapEntryColor->setPrinterPort("/dev/null");
					t_PrintcapEntryColor->setFilterName(*(new QString(t_lpdfilter->getFilterName())));
					t_Printcap->write(new printcapEntry(*t_PrintcapEntryColor));
			}

				
			// last but not least...mem cleanup
      delete(t_PrintcapEntryColor);
		} else if(t_kpcPrt->getNetworkType() == KpcPrinter::smb) {
		} else if(t_kpcPrt->getNetworkType() == KpcPrinter::appletalk) {
		} else if(t_kpcPrt->getNetworkType() == KpcPrinter::netware) {
		} else if(t_kpcPrt->getNetworkType() == KpcPrinter::ethernet) {
		}
	}
	// update kpcs own database of installed printers....
	t_cfg->sync();
  // mem clean up
	t_Printcap->sync("/etc/printcap");
	delete(t_alias);
	delete(t_SpoolDir);
	delete(t_dir);
	delete(t_DbEntry);
	delete(t_Printcap); delete(t_apsCfgMono); delete(t_apsCfgColor);  delete(t_aps);
	delete(t_spool); delete(t_spoolLst);
}
























