/***************************************************************************
                          ki.h  -  Header of ki.cpp
                             -------------------                                         
    begin                : Sat Apr 10 1999                                           
    copyright            : (C) 1999 by Hugo Santos                         
    email                : hugo_santos@bigfoot.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KI_H
#define KI_H

#include <kinstall.h>

#include "page1.h"
#include "page2.h"
#include "page3.h"
#include "page4.h"
#include "page5.h"
#include "pageabout.h"
#include "pageuninstall.h"

/**
  *@author Hugo Santos
  */

class KI : public _KInstall  {
   Q_OBJECT
public: 
	KI( QString );
	~KI();
private slots:
	void slotCancelClicked();
	void slotHelpClicked();
	void slotGotoPage1();
	void slotGotoPage2();
	void slotGotoPage3();
	void slotGotoPage4();
	void slotGotoPage5();
	void slotFinishInstallation();
	void slotCleanDirs();
	void slotFinishedAbout();
private:
	QString resoInstName( QString argv );
	void extrPackage( QString archive );
	void verifyPackage();
	void chooseFileAndLaunch();
	Page1 *p1;
	Page2 *p2;
	Page3 *p3;
	Page4 *p4;
	Page5 *p5;
};

#endif
