/* -*- C++ -*-
 * This source file is part of the KInetEd program.
 *
 * Copyright (C) 1998 by Jrgen Sigvardsson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */                          
#ifndef __KINETED_H__
#define __KINETED_H__

#include <ktopwidget.h>
#include <kmenubar.h>
#include <ktoolbar.h>
class KMenuBar;
class KTabListBox;
class QPopupMenu;
class KToolBar;

class KInetEd : public KTopLevelWidget {
  Q_OBJECT
private:
  KMenuBar* m_pMenuBar;
  KToolBar* m_pToolBar;

  KTabListBox* m_pListBox;
  QPopupMenu* m_pStatusPopup;
  QPopupMenu* m_pNamePopup;
  QPopupMenu* m_pSockPopup;
  QPopupMenu* m_pProtoPopup;
  QPopupMenu* m_pFlagPopup;
  QPopupMenu* m_pUserPopup;
  QPopupMenu* m_pPathPopup;
  QPopupMenu* m_pArgPopup;

  typedef KToolBar::BarPosition BarPosition;
  typedef KMenuBar::menuPosition menuPosition;

  void doSaveConfigFile(const char*);
  
public:
  KInetEd();

protected slots:
  void openConfigFile();
  void onNewConfig();
  void onNewService();
  void onSaveConfigFileAs();
  void onDeleteService();
  void quit();
  void itemSelected(int, int);
  void onStatusPopup(int);
  void onSockPopup(int);
  void onNamePopup(int);
  void onProtoPopup(int);
  void onFlagPopup(int);
  void onUserPopup(int);
  void onPathPopup(int);
  void onArgPopup(int);
};

#endif // __KINETED_H__
