/***************************************************************************
                          khtab2.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Aug 9 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "khtab2.h"
#include "khdockwidget.h"

KHTab2::KHTab2( QWidget *parent, const char* name ) : QWidget( parent, name ){

	d = new KHTab2Private;

	config = kapp->getConfig();

	d->toplayout = new QBoxLayout( this, QBoxLayout::Down, 12, 0 );


	d->group = new QGroupBox( i18n( "Notification Interval" ), this );
	d->toplayout->addWidget( d->group );

	d->notifylayout = new QBoxLayout( d->group, QBoxLayout::Down, 12, 0 );
	d->notifylayout->addSpacing( 12 );
	
	d->hbox = new QBoxLayout( QBoxLayout::LeftToRight	);
	d->notifylayout->addLayout( d->hbox );

	d->l = new QLabel( i18n( "Notification Interval" ), d->group );
	d->hbox->addWidget( d->l );

	d->s = new QSpinBox( 10, 60, 2, d->group );
 	d->s->setFixedHeight( d->s->sizeHint().height() );
	d->s->setMaximumWidth( 60 );
  config->setGroup( "General" );
	d->s->setValue( config->readNumEntry( GeneralKeys[0], 5 ) );
	d->hbox->addWidget( d->s );
	connect( d->s, SIGNAL( valueChanged ( int ) ),
					 this,		SLOT	( writeNotificationInterval ( int ) ) );

	d->toplayout->addSpacing( 12 );


	d->group = new QGroupBox( i18n( "Docking" ), this );
	d->toplayout->addWidget( d->group );

	d->dockinglayout = new QBoxLayout( d->group, QBoxLayout::Down, 12, 10 );
	d->dockinglayout->addSpacing( 12 );
	
	d->hbox = new QBoxLayout( QBoxLayout::LeftToRight	);
	d->dockinglayout->addLayout( d->hbox );

 	d->bg = new QButtonGroup( this );
	d->bg->hide();

	d->rb = new QRadioButton( i18n( "Disabled" ), d->group );
	d->rb->setFixedHeight( d->rb->sizeHint().height() );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );

	d->rb = new QRadioButton( i18n( "Enabled" ), d->group );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );
	config->setGroup( "General" );
	d->bg->setButton( static_cast<int>( config->readBoolEntry( GeneralKeys[4], true ) ) );
	connect( d->bg, SIGNAL( pressed( int ) ),
					 this, SLOT( writeDockingEnabled( int ) ) );
	connect( d->bg, SIGNAL( pressed( int ) ),
					 kapp, SLOT( setDocking( int ) ) );

	d->hbox = new QBoxLayout( QBoxLayout::LeftToRight );
	d->dockinglayout->addLayout( d->hbox );
	
	d->l = new QLabel( i18n( "Display Item: " ), d->group );
	d->hbox->addWidget( d->l );

	d->cb = new QComboBox( d->group );
	static const char* items[] = { 	i18n( "Fan 1" ), i18n( "Fan 2" ),
																	i18n( "Fan 3" ), i18n( "Temp 1" ),
																	i18n( "Temp 2" ), i18n( "Temp 3" ),
																	i18n( "V core"), i18n( "+3.3 V" ),
																	i18n( "+5 V" ), i18n( "-5 V" ),
																	i18n( "+12 V" ),i18n( "-12 V" ) };
	d->cb->insertStrList( items, 6 ); 																// voltages are currently disabled
	d->cb->setFixedHeight( d->cb->sizeHint().height() );
	config->setGroup( "General" );
	d->cb->setCurrentItem( config->readNumEntry( GeneralKeys[5], 0 ) );
	d->hbox->addWidget( d->cb );
	connect( d->cb, SIGNAL( activated( int ) ),
					 this, SLOT( writeDisplayDocking( int ) ) );

	d->toplayout->addSpacing( 12 );

	d->group = new QGroupBox( i18n( "Automatic shutdown" ), this );
	d->toplayout->addWidget( d->group );

	d->shutdownlayout = new QBoxLayout( d->group, QBoxLayout::Down, 12, 10 );
	
	d->shutdownlayout->addSpacing( 12 );

	d->hbox = new QBoxLayout( QBoxLayout::LeftToRight );
	d->shutdownlayout->addLayout( d->hbox );

	d->bg = new QButtonGroup( this );
	d->bg->hide();
	d->rb = new QRadioButton( i18n( "Disabled" ), d->group );
	d->rb->setFixedHeight( d->rb->sizeHint().height() );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );

	d->rb = new QRadioButton( i18n( "Enabled" ), d->group );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );
	
	d->bg->setButton( static_cast<int>( config->readBoolEntry( GeneralKeys[1], false ) ) );
	connect( d->bg, SIGNAL( pressed( int ) ),
					 this, SLOT( writeShutdownEnabled( int ) ) );

	d->shutdownlayout->addSpacing( 6 );

	d->hbox = new QBoxLayout( QBoxLayout::LeftToRight );
	d->shutdownlayout->addLayout( d->hbox );
	
	d->l = new QLabel( i18n( "Shutdown countdown" ), d->group );
	d->hbox->addWidget( d->l );

	d->s = new QSpinBox( d->group );
 	d->s->setFixedHeight( d->s->sizeHint().height() );
	d->s->setMaximumWidth( 60 );
	d->s->setSteps( 5, 10 );
	d->s->setRange( 60, 300 );
  config->setGroup( "General" );
	d->s->setValue( config->readNumEntry( GeneralKeys[2], 60 ) );
	d->hbox->addWidget( d->s );	
	connect( d->s, SIGNAL( valueChanged ( int ) ),
					 this,		SLOT	( writeReactionTime ( int ) ) );
	d->shutdownlayout->addSpacing( 4 );

	d->hbox = new QBoxLayout( QBoxLayout::LeftToRight );
	d->shutdownlayout->addLayout( d->hbox );
	
	d->l = new QLabel( i18n( "Shutdown notification" ), d->group );
	d->hbox->addWidget( d->l );
	
	d->s = new QSpinBox( d->group );
	d->s->setFixedHeight( d->s->sizeHint().height() );
	d->s->setMaximumWidth( 60 );
	d->s->setSteps( 5, 10 );
	d->s->setRange( 15, 300 );
  config->setGroup( "General" );
	d->s->setValue( config->readNumEntry( GeneralKeys[3], 20 ) );
	d->hbox->addWidget( d->s );	
	connect( d->s, 	SIGNAL( valueChanged ( int ) ),
					 this,SLOT	( writeShutdownNotification ( int ) ) );

	d->toplayout->activate();

}


KHTab2::~KHTab2(){
	//debug( "destroying KHTab2" );
	delete d;
}

void KHTab2::writeNotificationInterval( int value ){
	config->setGroup( "General" );
	config->writeEntry( GeneralKeys[0], value );	
}

void KHTab2::writeReactionTime( int value ){
	config->setGroup( "General" );
	config->writeEntry( GeneralKeys[2], value );
}

void KHTab2::writeShutdownEnabled( int value ){
	config->setGroup( "General" );
	config->writeEntry( GeneralKeys[1], static_cast<bool>( value ) );
}

void KHTab2::writeShutdownNotification( int value ){
	config->setGroup( "General" );
	config->writeEntry( GeneralKeys[3], value );	
}

void KHTab2::writeDockingEnabled( int value ){
 	config->setGroup( "General" );
	config->writeEntry( GeneralKeys[4], static_cast<bool>( value ) );
}

void KHTab2::writeDisplayDocking( int item ){
	config->setGroup( "General" );
	config->writeEntry( GeneralKeys[5], item );
}























