/***************************************************************************
                          khglobals.cpp  -  description
                             -------------------                                         
    begin                : Thu Aug 5 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qmessagebox.h>
#include "sensors.h"
#include "khdockwidget.h"

KHDockWidget *dockwidget = 0;

/** iterator for SensorId */
SensorId &operator++( SensorId &sid, int ) {
	return sid = ( End == sid ) ? Fan1 : SensorId( sid + 1 );
}

/////////////////////// IMPORTANT !!! ////////////////////////////
// All keys must have the same order, which must reflect the
// order of SensorId. This way the program will stay consistent
// and easy to maintain
//////////////////////////////////////////////////////////////////

// this array has one more element than the others: VIDEnabled
// VID is for informative purposes only and has no configuration
// possibilities at all, therefore it is of minor importance
// for the rest of the application, except from the key which
// has to be existant for compatibility reasons, and feature detection
QString EnableKeys[SensorIdSize + 1] = {	"Fan1Enabled", "Fan2Enabled", "Fan3Enabled",
																					"Sensor1Enabled","Sensor2Enabled","Sensor3Enabled",
																					"VCoreEnabled", "VCore2Enabled", "V33Enabled","V5Enabled",
																					"Vm5Enabled","V12Enabled","Vm12Enabled", "VIDEnabled" };
																			
QString BeepKeys	[SensorIdSize] = {	"Fan1Beeps","Fan2Beeps","Fan3Beeps",
																			"Sensor1Beeps","Sensor2Beeps","Sensor3Beeps",
																			"VCoreBeeps", "VCore2Beeps", "V33Beeps","V5Beeps",
																			"Vm5Beeps","V12Beeps","Vm12Beeps" };

QString FaultsKeys[SensorIdSize] = {	"Fan1Faults","Fan2Faults","Fan3Faults",
																			"Sensor1Faults","Sensor2Faults","Sensor3Faults",
																			"VCoreFaults", "VCore2Faults", "V33Faults","V5Faults",
																			"Vm5Faults","V12Faults","Vm12Faults" };

QString AlarmKeysLo[SensorIdSize] = {	"Fan1Alarm", "Fan2Alarm", "Fan3Alarm",
																			0, 0, 0,
																			"VCoreLoAlarm", "VCore2LoAlarm", "V33LoAlarm","V5LoAlarm",
						                          "Vm5LoAlarm", "V12LoAlarm", "Vm12LoAlarm" };
												
QString AlarmKeysHi[SensorIdSize] = { 0, 0, 0, "Temp1HiAlarm", "Temp2HiAlarm", "Temp3HiAlarm",
																			"VCoreHiAlarm", "VCore2HiAlarm", "V33HiAlarm","V5HiAlarm",
            						              "Vm5HiAlarm", "V12HiAlarm", "Vm12HiAlarm" };

QString GeneralKeys[] = { "NotificationInterval", "ShutdownEnabled", "ShutdownTimeout", "ShutdownNotification", "DockingEnabled", "DockingDisplay" };


QString SensorKeys[] = { "Sensor1Type", "Sensor2Type", "Sensor3Type" };


int alarmBindings[][16] = { // w83781d
													{ W83781D_ALARM_IN0, 		W83781D_ALARM_IN1,  W83781D_ALARM_IN2, 		W83781D_ALARM_IN3,
														W83781D_ALARM_IN4, 		W83781D_ALARM_IN5,  W83781D_ALARM_IN6, 		W83782D_ALARM_IN7,
														W83782D_ALARM_IN8,		W83781D_ALARM_FAN1, W83781D_ALARM_FAN2,		W83781D_ALARM_FAN3,
														W83781D_ALARM_TEMP1,  W83781D_ALARM_TEMP23,0,									  W83781D_ALARM_CHAS
													},
													 	// w83782d
													{	W83781D_ALARM_IN0, 		W83781D_ALARM_IN1,  W83781D_ALARM_IN2, 		W83781D_ALARM_IN3,
														W83781D_ALARM_IN4, 		W83781D_ALARM_IN5,  W83781D_ALARM_IN6, 		W83782D_ALARM_IN7,		
														W83782D_ALARM_IN8,		W83781D_ALARM_FAN1, W83781D_ALARM_FAN2, 	W83781D_ALARM_FAN3,
														W83781D_ALARM_TEMP1,  W83781D_ALARM_TEMP2,W83781D_ALARM_TEMP3,	W83781D_ALARM_CHAS
													},
														// w83783s
													{ W83781D_ALARM_IN0, 		W83781D_ALARM_IN1,    W83781D_ALARM_IN2,	W83781D_ALARM_IN3,
												    W83781D_ALARM_IN4, 		W83781D_ALARM_IN5,    W83781D_ALARM_IN6, 	W83782D_ALARM_IN7,
														W83782D_ALARM_IN8,		W83781D_ALARM_FAN1, 	W83781D_ALARM_FAN2,	W83781D_ALARM_FAN3,	
														W83781D_ALARM_TEMP1,  W83781D_ALARM_TEMP2, 	0,									W83781D_ALARM_CHAS
													},
														// LM 75, LM78, LM79, LM79-J
													{ LM78_ALARM_IN0, 			LM78_ALARM_IN1,       LM78_ALARM_IN2, 		LM78_ALARM_IN3,
														LM78_ALARM_IN4,				LM78_ALARM_IN5,       LM78_ALARM_IN6, 		0,
														0,                 		LM78_ALARM_FAN1,			LM78_ALARM_FAN2, 		LM78_ALARM_FAN3,
														LM78_ALARM_TEMP,      0,										0,								  LM78_ALARM_CHAS
													},
														// LM80
													{ LM80_ALARM_IN0, 			LM80_ALARM_IN1,       LM80_ALARM_IN2, 		LM80_ALARM_IN3,
										 	      LM80_ALARM_IN4, 			LM80_ALARM_IN5,       LM80_ALARM_IN6,			0,
				                    0, 										LM80_ALARM_FAN1, 			LM80_ALARM_FAN2, 		0,									
														LM80_ALARM_TEMP_HOT,  LM80_ALARM_TEMP_OS, 	0,									LM80_ALARM_CHAS
													},
														// SIS5595
													{ SIS5595_ALARM_IN0, 	SIS5595_ALARM_IN1, 	SIS5595_ALARM_IN2, 	SIS5595_ALARM_IN3,
														0,								 	0,								 	0,									0,
														0,									SIS5595_ALARM_FAN1, SIS5595_ALARM_FAN2, 0,
														SIS5595_ALARM_TEMP,	0,									0,									0
													},
														// ADM9240
													{	ADM9240_ALARM_IN0, 	ADM9240_ALARM_IN1,	ADM9240_ALARM_IN2,	ADM9240_ALARM_IN3,
														ADM9240_ALARM_IN4, 	ADM9240_ALARM_IN5, 	0,									0,
														0,									ADM9240_ALARM_FAN1,	ADM9240_ALARM_FAN2,	0,
														ADM9240_ALARM_TEMP,	0,									0,									ADM9240_ALARM_CHAS
													},
														// GL518 andGL520
													{ GL520_ALARM_VDD,		GL520_ALARM_VIN1,		GL520_ALARM_VIN2,		GL520_ALARM_VIN3,
														GL520_ALARM_VIN4,		0,									0,									0,
														0,									GL520_ALARM_FAN1,		GL520_ALARM_FAN2,		0,
														GL520_ALARM_TEMP1,	GL520_ALARM_TEMP2,	0,									0
													}
											 };		

void abort( QString message ){
	QMessageBox::critical( NULL, i18n( "KHealthCare fatal error" ), message );
	exit( 1 );
}
















