/***************************************************************************
                          khdockwidget.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Aug 9 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qmessagebox.h>
#include "khdisplaywidget.h"
#include "khglobals.h"
#include "khdockwidget.h"

KHDockWidget::KHDockWidget( KHDisplayWidget *mainwidget ){
	this->mainwidget = mainwidget;
	setUpdatesEnabled( true );
	/*QFont font( font() );
	font.setPointSize( 8 );
	setFont( font );*/
	connect( kapp, SIGNAL( saveYourself() ),
					 this, SLOT	 ( saveMyself() ) );
}

KHDockWidget::~KHDockWidget(){
	//debug( "destroying KHDockWidget" );
}

bool KHDockWidget::event( QEvent* event ){

	if( event->type() == Event_MouseButtonPress){
		if( static_cast<QMouseEvent*> ( event )->button() == RightButton ){
			switch( QMessageBox::information( this, NULL,
							i18n( "This will end the application.\nAre you sure ?" ),
							i18n( "&Yes" ), i18n( "&No" ),
							0,      // Enter == button 0
							1 ) ) { // Escape == button 1
			case 0: // Yes clicked, Alt-Y or Enter pressed.
				kapp->quit();
				return true;
			break;
			}
		} else if( static_cast<QMouseEvent*> ( event )->button() == LeftButton ){
			mainwidget->show();
			return true;
		}
	}
	return false;
}

void KHDockWidget::display( int value, SensorId sid ){
	static SensorId item;

	kapp->getConfig()->setGroup( "General" );
	item = static_cast<SensorId>( kapp->getConfig()->readNumEntry( GeneralKeys[5], 0 ) );	
	if ( item == sid ) {
		setNum( value );
		repaint();
	}
}

void KHDockWidget::display( float value, SensorId sid ){
	static SensorId item;

	kapp->getConfig()->setGroup( "General" );
	item = static_cast<SensorId>( kapp->getConfig()->readNumEntry( GeneralKeys[5], 0 ) );	
	if ( item == sid ) {
		setText( QString().sprintf( "%2.2f", value ) );
		repaint();
	}
}

void KHDockWidget::repaint(){
	paintEvent( new QPaintEvent( this->rect() ) );
}

void KHDockWidget::saveMyself(){
	KConfig *sc = kapp->getSessionConfig();
	sc->setGroup( "Default" );
	sc->writeEntry( "DockingWidgetVisible", isVisible() );
}









