/***************************************************************************
                          khconfigitem.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Sep 29 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qgroupbox.h>
#include "khtab1.h"
#include "khbuttonpair.h"
#include "khfeatureprofile.h"
#include "khconfigitem.h"

int KHConfigItem::itemCount = 0;
QGridLayout *KHConfigItem::grid;

KHConfigItem::KHConfigItem( SensorId sid, QWidget *parent, const char *name ) {

	if ( sid == Fan1 ) itemCount = 1;
	else itemCount++;
	if ( itemCount ) {
		grid->expand( itemCount + 1, grid->numCols() );
		grid->setRowStretch( itemCount, 1 );
	}

	label = new QLabel ( KHFeatureProfile::name( sid ) ,parent );
	label->setMinimumSize( label->sizeHint() );
	label->setMaximumSize( label->sizeHint().width() + 10, label->sizeHint().height() + 10 );
	grid->addWidget( label, itemCount, 1, AlignLeft | AlignVCenter );

	enable = new QCheckBox( parent );
	enable->setMinimumSize( enable->sizeHint() );
	enable->setMaximumSize( enable->sizeHint().width() + 10, enable->sizeHint().height() + 10 );
  grid->addWidget( enable, itemCount, 2, AlignCenter );
	connect( enable,SIGNAL( clicked() ),
					 this, 	SLOT	( forwardClick() ) );
	QToolTip::add( enable, QString( "enable / disable " ).append( KHFeatureProfile::name( sid ) ).append( " monitoring" ) );

	faults = new KHButtonPair( parent );
	faults->setMinimumSize( faults->size() );
	faults->setMaximumSize( faults->size().width() + 10, faults->size().height() + 10 );
	grid->addWidget( faults, itemCount, 3, AlignCenter );
  connect( faults,SIGNAL( clicked() ),
					 this, 	SLOT	( forwardClick() ) );
	QToolTip::add( faults, QString( "set " ).append( KHFeatureProfile::name( sid ) ).append( " to 1 or 3 consecutive faults" ) );

	if ( KHFeatureProfile::checkFeature( BeepControl ) ) {
		beep = new QCheckBox( parent );
		beep->setMinimumSize( beep->sizeHint() );
		beep->setMaximumSize( beep->sizeHint().width() + 10, beep->sizeHint().height() + 10 );
		grid->addWidget( beep, itemCount, 4, AlignCenter );
		connect( beep, SIGNAL	( clicked() ),
 						 this, SLOT	 	( forwardClick() ) );
		QToolTip::add( beep, QString( "enable / disable beeping for " ).append( KHFeatureProfile::name( sid ) ) );
	}
	else beep = 0;

}

KHConfigItem::~KHConfigItem(){
}

/**  */
void KHConfigItem::setEnableButton( bool enabled ){
	enable->setChecked( enabled );
}

/**  */
void KHConfigItem::setFaultsButton( int value ){
	if ( value == 1 ) faults->setLeftButtonDown( true );
	else faults->setLeftButtonDown( false );
}

/**  */
void KHConfigItem::setBeepButton( bool pressed ){
	beep->setChecked( pressed );
}

/**  */
bool KHConfigItem::beepIsActivated(){
	if ( beep ) return beep->isChecked();
	else return false;
}

/**  */
void KHConfigItem::forwardClick(){
	if ( sender() == enable ) {
		emit clicked( ButtonEnable );
	}
	else if ( sender() == faults ) {
		if ( faults->leftPressed() )
			emit clicked( ButtonFaultsLeft );
		else
			emit clicked( ButtonFaultsRight );
	}
	else if ( ( beep ) && ( sender() == beep ) ) {
		emit clicked( ButtonBeep );
	} else debug( "KHConfigItem::forwardClick(): unknown sender encountered" );
}

/**  */
bool KHConfigItem::enableIsActivated(){
	return enable->isChecked();
}

/**  */
bool KHConfigItem::hasBeepButton(){
	return beep;
}

void KHConfigItem::setLayout( QGridLayout *layout ){
 	grid = layout;
}









































