#ifndef VARTABLE_H
#define VARTABLE_H

#include "krowtable.h"


// -- class VarRow

class VarRow: public KRow
{
public:
  VarRow();
  VarRow(QString name, QString value);
  ~VarRow() {}	  

  QString line();

  QString getName()            { return _name; }
  QString getValue()           { return _value; }

  void setName(QString value)  { _name = value; }
  void setValue(QString value) { _value = value; }
protected:
  void paint(QPainter *p, int col, int width);

  QString _name;
  QString _value;
};

// -- class VarTable

class VarTable: public KRowTable
{
 Q_OBJECT
signals:
  void doubleClick();
  void rightClick();
public:
  VarTable(QWidget *parent = 0, const char *name = 0);
  ~VarTable() {}

  void addItem(QString name, QString value);
  void addItem(VarRow *row);
  void clear();
  int  currentItem()    { return currentRow(); }
  void setCurrentItem(int row);

  QString line(int row) { return ((VarRow *) getRow(row))->line(); }

  int count()           { return numRows(); }
protected:
  void mousePressEvent(QMouseEvent *e);
  void mouseDoubleClickEvent(QMouseEvent *);
};

#endif // VARTABLE_H
