#include "editvariable.moc"


// -- class EditVariable implementation

EditVariable::EditVariable(QWidget *parent, const char *name, QStrList *list)
 : QWidget(parent, name)
{
  intList = list;

  setCaption(i18n("Edit Variables"));

  header = new KHeader(this, "header", 2);
  header->setGeometry(10, 10, 400, 20);
  header->setHeaderLabel(0, i18n("Variable"), AlignLeft | AlignVCenter);
  header->setHeaderLabel(1, i18n("Value"), AlignLeft | AlignVCenter);

  variables = new VarTable(this, "vartable");
  variables->setGeometry(10, 30, 400, 155);
  variables->setFrameStyle(51);
  variables->setLineWidth(2);
  variables->setAutoDelete(TRUE);
  
  connect(header, SIGNAL(sizeChanged(int, int)),
          variables, SLOT(setColumnWidth(int, int)));
  connect(variables, SIGNAL(hSliderMoved(int)),
	  header, SLOT(setOrigin(int)));

  connect(variables, SIGNAL(doubleClick()),
          this, SLOT(slotSelected()));

  header->setHeaderSize(0, 100);
  header->setHeaderSize(1, 280);

  variables->setUpdatesEnabled(FALSE);
  if (intList)
  {
    QString temp;

    for (int i = 0; i < (int) intList->count(); i++)
    {
      temp = intList->at(i);
      variables->addItem(strtok(temp.data(), "="), strtok(0, ""));
    }
    variables->setCurrentItem(0);
  }
  variables->setUpdatesEnabled(TRUE);
  variables->repaint();


  labVariable = new QLabel(i18n("&Variable:"), this, "labVariable");
  labVariable->setGeometry(10, 200, 60, 30);

  leVariable = new QLineEdit(this, "leVariable");
  leVariable->setGeometry(70, 200, 230, 30);
  leVariable->setMaxLength(100);
  labVariable->setBuddy(leVariable);

  labValue = new QLabel(i18n("&Value:"), this, "labValue");
  labValue->setGeometry(10, 240, 60, 30);

  leValue = new QLineEdit(this, "leValue");
  leValue->setGeometry(70, 240, 230, 30);
  leValue->setMaxLength(1000);
  labValue->setBuddy(leValue);

  pbEdit = new QPushButton(this, "pbEdit");
  pbEdit->setGeometry(310, 200, 100, 30);
  pbEdit->setText(i18n("&Edit"));
  connect(pbEdit, SIGNAL(clicked()), this, SLOT(slotEdit()));

  pbRemove = new QPushButton(this, "pbRemove");
  pbRemove->setGeometry(310, 240, 100, 30);
  pbRemove->setText(i18n("&Remove"));
  connect(pbRemove, SIGNAL(clicked()), this, SLOT(slotRemove()));

  frButton = new QFrame(this, "frButton");
  frButton->setGeometry(10, 280, 400, 50);
  frButton->setFrameStyle(QFrame::Box | QFrame::Sunken);

  pbOk = new QPushButton(this, "pbOk");
  pbOk->setGeometry(20, 290, 100, 30);
  pbOk->setText(i18n("OK"));
  connect(pbOk, SIGNAL(clicked()), this, SLOT(slotOk()));

  pbCancel = new QPushButton(this, "pbCancel");
  pbCancel->setGeometry(130, 290, 100, 30);
  pbCancel->setText(i18n("Cancel"));
  connect(pbCancel, SIGNAL(clicked()), this, SLOT(slotCancel()));

  pbHelp = new QPushButton(this, "pbHelp");
  pbHelp->setGeometry(300, 290, 100, 30);
  pbHelp->setText(i18n("Help"));
  connect(pbHelp, SIGNAL(clicked()), this, SLOT(slotHelp()));

  QAccel *accel = new QAccel(this);
  accel->connectItem(accel->insertItem(Key_Return), this, SLOT(slotEdit()));
  accel->connectItem(accel->insertItem(Key_Escape), this, SLOT(slotCancel()));

  setFixedSize(420, 340);
  leVariable->setFocus();
  
  changed = FALSE;
}

EditVariable::~EditVariable()
{
}

void EditVariable::closeEvent(QCloseEvent *e)
{
  emit onClose(changed);
  QWidget::closeEvent(e);
}

// -- Slots

void EditVariable::slotSelected()
{
  int index = variables->currentItem();

  if (index == -1) return;
  
  VarRow *row = (VarRow *) variables->getRow(index);
  leVariable->setText(row->getName());
  leValue->setText(row->getValue());
  leValue->setFocus();
}

void EditVariable::slotEdit()
{
  QString variable = leVariable->text();
  QString value    = leValue->text();

  if (!variable.isEmpty() && !value.isEmpty())
  {
    VarRow *row;

    leVariable->setText("");
    leValue->setText("");

    for (int i = 0; i < (int) variables->count(); i++)
    {
      row = (VarRow *) variables->getRow(i);
      if ((stricmp(row->getName(), variable.data())) == 0)
      {
        changed = TRUE;
        row->setValue(value);
	variables->setCurrentItem(i);
	variables->repaint();
        return;
      }
    }

    changed = TRUE;
    variables->addItem(variable, value);
    variables->setCurrentItem(variables->count() - 1);
  }
}

void EditVariable::slotRemove()
{
  int index = variables->currentItem();

  if (index != -1)
  {
    changed = TRUE;
    variables->deleteRow(index);
  }
}

void EditVariable::slotOk()
{
  if (intList)
  {
    intList->clear();

    for (int i = 0; i < (int) variables->count(); i++)
      intList->append(variables->line(i));
  }

  emit onClose(changed);
  close();
}

void EditVariable::slotCancel()
{
  emit onClose(changed);
  close();
}

void EditVariable::slotHelp()
{
  kapp->invokeHTMLHelp("kcrontab/3.2.html", "");
}
