#ifndef EDITENTRY_H
#define EDITENTRY_H

#include <kapp.h>
#include <klocale.h>

#include <stdlib.h>
#include <ctype.h>

#include <qwidget.h>
#include <qmsgbox.h>
#include <qaccel.h>
#include <qchkbox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qcombo.h>

#include <kbuttonbox.h>

#include "numtbl.h"
#include "crontable.h"
#include "cronvalidator.h"


// -- class EditEntry

class EditEntry : public QWidget
{
  Q_OBJECT
public:
  EditEntry(bool _syscron, CronRow *row = 0, QWidget* parent = 0,
            const char* name = 0);
  ~EditEntry();

  void setUser(QStrList *_userList, QString user);
signals:
  void newEntry(CronRow *, bool);
protected slots:
  void slotDropAction(KDNDDropZone *);
  void slotWeekdaySelected(bool); 
  void slotEveryWeekday(); 
  void slotMonthSelected(bool); 
  void slotEveryMonth(); 
  void slotOk();
  void slotCancel();
  void slotHelp();
protected:
  void closeEvent(QCloseEvent *e);

  QLabel	*labCommand;
  QLineEdit	*leCommand;

  KDNDDropZone	*dropZone;

  QLabel	*labUser;
  QComboBox	*qbUserList;

  QLabel	*labHour;
  QLineEdit	*leHour;

  QLabel	*labMinute;
  QLineEdit	*leMinute;

  QLabel	*labDay;
  NumTbl	*ntDay;

  QLabel	*labWeekday;
  QFrame	*frWeekday;
  QCheckBox	*cbWeekday[7];
  QRadioButton	*rbEveryWeekday;

  QLabel	*labMonth;
  QFrame	*frMonth;
  QCheckBox	*cbMonth[12];
  QRadioButton	*rbEveryMonth;

  QLabel	*labComment;
  QLineEdit	*leComment;

  QFrame	*frButtons;
  QPushButton	*pbOk;
  QPushButton	*pbCancel;
  QPushButton	*pbHelp2;

  QAccel	*accel;
private:
  void		setupArrays();
  void		setWidgets();
  bool		*parse(QString, int, int);
  QString	preParse(QString entry);

  bool		syscron;
  CronRow	*editRow;
  bool		editMode;

  int		activatedDays;
  int		activatedMonth;

  const char	*weekdays[7];
  const char	*months[12];
};

#endif // EDITENTRY_H
