/*
 *  Copyright 2013-2015  Andreas Cord-Landwehr <cordlandwehr@kde.org>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License or (at your option) version 3 or any later version
 *  accepted by the membership of KDE e.V. (or its successor approved
 *  by the membership of KDE e.V.), which shall act as a proxy
 *  defined in Section 14 of version 3 of the license.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LANGUAGEMODEL_H
#define LANGUAGEMODEL_H

#include <QSortFilterProxyModel>

class LanguageResourceModel;
class Language;

class LanguageModel : public QSortFilterProxyModel
{
    Q_OBJECT
    Q_PROPERTY(LanguageResourceModel *resourceModel READ resourceModel WRITE setResourceModel NOTIFY resourceModelChanged)
    Q_PROPERTY(LanguageResourceView view READ view WRITE setView NOTIFY viewChanged)

public:
    enum LanguageResourceView {
        NonEmptyContributorOnlyResources,
        NonEmptyGhnsOnlyLanguages,
        NonEmptyLanguages,
        AllLanguages
    };
    Q_ENUM(LanguageResourceView)

    explicit LanguageModel(QObject *parent = nullptr);
    LanguageResourceModel * resourceModel() const;
    void setResourceModel(LanguageResourceModel *resourceModel);
    bool lessThan(const QModelIndex &left, const QModelIndex &right) const override;
    void setView(LanguageResourceView view);
    LanguageResourceView view() const;
    Q_INVOKABLE QVariant language(int index) const;

Q_SIGNALS:
    void resourceModelChanged();
    void viewChanged();

private:
    LanguageResourceModel *m_resourceModel;
    LanguageResourceView m_view;
};

#endif
