/*
   Copyright (C) 2016-2017 Montel Laurent <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef IMPORTIMAPSETTINGWIZARD_H
#define IMPORTIMAPSETTINGWIZARD_H

#include <KAssistantDialog>
#include "libsieveeditor_export.h"

class ImportImapSettingSearchPage;
class ImportImapSettingNoFoundPage;
class ImportImapSettingProgressPage;
class ImportImapSettingFinishPage;
class KPageWidgetItem;
class AbstractImapSettingsCheckJob;
class LIBSIEVEEDITOR_EXPORT ImportImapSettingWizard : public KAssistantDialog
{
    Q_OBJECT
public:
    explicit ImportImapSettingWizard(QWidget *parent = nullptr);
    ~ImportImapSettingWizard();

    void next() override;

private:
    void readConfig();
    void writeConfig();
    void initializeWizard();
    void slotHelpClicked();
    void slotFinishImportData();
    void slotAddSummaryInfo(const QString &name);
    void slotNeedToImportSettings(bool b);
    QMap<QString, AbstractImapSettingsCheckJob *> mListCheckJob;

    ImportImapSettingSearchPage *mSearchPage;
    KPageWidgetItem *mSearchPageItem;

    ImportImapSettingNoFoundPage *mNoFoundPage;
    KPageWidgetItem *mNoFoundPageItem;

    ImportImapSettingProgressPage *mProgressPage;
    KPageWidgetItem *mProgressPageItem;

    ImportImapSettingFinishPage *mFinishPage;
    KPageWidgetItem *mFinishPageItem;
};

#endif // IMPORTIMAPSETTINGWIZARD_H
