/*
 *  Copyright (C) 2004 Christian Loose <christian.loose@kdemail.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "patchoptiondialog.h"

using Cervisia::PatchOptionDialog;

#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qgroupbox.h>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QBoxLayout>
#include <QButtonGroup>

#include <knuminput.h>
#include <klocale.h>


PatchOptionDialog::PatchOptionDialog(QWidget* parent)
    : KDialog(parent)
{
    setButtons(Ok | Cancel | Help);
    setDefaultButton(Ok);
    setModal(false);
    showButtonSeparator(true);

    QFrame* mainWidget = new QFrame(this);
    setMainWidget(mainWidget);

    QBoxLayout* topLayout = new QVBoxLayout(mainWidget);
    topLayout->setSpacing(spacingHint());
    topLayout->setMargin(0);

    { // format
      m_formatBtnGroup = new QButtonGroup(mainWidget);

      connect(m_formatBtnGroup, SIGNAL(buttonClicked(int)),
              this,             SLOT(formatChanged(int)));

      m_formatBtnGroup->addButton(new QRadioButton(i18n("Context")), 0);
      m_formatBtnGroup->addButton(new QRadioButton(i18n("Normal")), 1);
      QRadioButton* unifiedFormatBtn = new QRadioButton(i18n("Unified"));
      unifiedFormatBtn->setChecked(true);
      m_formatBtnGroup->addButton(unifiedFormatBtn, 2);

      QGroupBox *box = new QGroupBox(i18n("Output Format"), mainWidget);
      QVBoxLayout *v = new QVBoxLayout(box);
      v->addWidget(m_formatBtnGroup->button(0));
      v->addWidget(m_formatBtnGroup->button(1));
      v->addWidget(m_formatBtnGroup->button(2));

      topLayout->addWidget(box);
    }

    QLabel* contextLinesLbl = new QLabel(i18n("&Number of context lines:"),
                                         mainWidget);
    m_contextLines = new KIntNumInput(3, mainWidget);
    m_contextLines->setRange(2, 65535, 1);
    m_contextLines->setSliderEnabled(false);
    contextLinesLbl->setBuddy(m_contextLines);

    QBoxLayout* contextLinesLayout = new QHBoxLayout();
    topLayout->addLayout(contextLinesLayout);
    contextLinesLayout->addWidget(contextLinesLbl);
    contextLinesLayout->addWidget(m_contextLines);

    { // ignore options
      QButtonGroup *group = new QButtonGroup(mainWidget);

      m_blankLineChk   = new QCheckBox(i18n("Ignore added or removed empty lines"));
      m_spaceChangeChk = new QCheckBox(i18n("Ignore changes in the amount of whitespace"));
      m_allSpaceChk    = new QCheckBox(i18n("Ignore all whitespace"));
      m_caseChangesChk = new QCheckBox(i18n("Ignore changes in case"));

      group->addButton(m_blankLineChk);
      group->addButton(m_spaceChangeChk);
      group->addButton(m_allSpaceChk);
      group->addButton(m_caseChangesChk);

      QGroupBox *box = new QGroupBox(i18n("Ignore Options"), mainWidget);
      QVBoxLayout *v = new QVBoxLayout(box);
      v->addWidget(m_blankLineChk);
      v->addWidget(m_spaceChangeChk);
      v->addWidget(m_allSpaceChk);
      v->addWidget(m_caseChangesChk);

      topLayout->addWidget(box);
    }
}


PatchOptionDialog::~PatchOptionDialog()
{
}


QString PatchOptionDialog::diffOptions() const
{
    QString options;

    if( m_blankLineChk->isChecked() )
        options += " -B ";

    if( m_spaceChangeChk->isChecked() )
        options += " -b ";

    if( m_allSpaceChk->isChecked() )
        options += " -w ";

    if( m_caseChangesChk->isChecked() )
        options += " -i ";

    return options;
}


QString PatchOptionDialog::formatOption() const
{
    switch( m_formatBtnGroup->checkedId() )
    {
        case 0: return "-C " + QString::number(m_contextLines->value());
        case 1: return "";
        case 2: return "-U " + QString::number(m_contextLines->value());
    }

    return "";
}


void PatchOptionDialog::formatChanged(int buttonId)
{
    bool enabled = ( buttonId == 0 || buttonId == 2 );
    m_contextLines->setEnabled(enabled);
}

#include "patchoptiondialog.moc"
