/****************************************************************************************
 * Copyright (c) 2010 Téo Mrnjavac <teo@kde.org>                                        *
 *                                                                                      *
 * This program is free software; you can redistribute it and/or modify it under        *
 * the terms of the GNU General Public License as published by the Free Software        *
 * Foundation; either version 2 of the License, or (at your option) any later           *
 * version.                                                                             *
 *                                                                                      *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY      *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      *
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.             *
 *                                                                                      *
 * You should have received a copy of the GNU General Public License along with         *
 * this program.  If not, see <http://www.gnu.org/licenses/>.                           *
 ****************************************************************************************/

#ifndef TRANSCODING_CONTROLLER_H
#define TRANSCODING_CONTROLLER_H

#include "amarok_export.h"
#include "core/support/Components.h"
#include "core/transcoding/TranscodingDefines.h"
#include "core/transcoding/TranscodingFormat.h"

#include <KProcess>

#include <QList>
#include <QMap>
#include <QObject>
#include <QSet>


namespace Transcoding
{

/**
 * Singleton class that handles and wraps around the Transcoding architecture.
 * @author Téo Mrnjavac <teo@kde.org>
 */
class AMAROK_CORE_EXPORT Controller : public QObject
{
    Q_OBJECT
public:
    Controller( QObject *parent = 0 );
    ~Controller();

    /**
     * Return set of all encoders, available or not.
     */
    QSet<Encoder> allEncoders() const { return m_formats.uniqueKeys().toSet(); }

    /**
     * Return a set of all available encoders. You can use @see format() to get all
     * available formats.
     */
    QSet<Encoder> availableEncoders() const { return m_availableEncoders; }

    /**
     * Return pointer to format that encodes using @param encoder. You must ensure that
     * @param encoder is in @see allEncoders(). Always returns non-null pointer which
     * remains owned by Transcoding::Controller.
     */
    Format *format( Encoder encoder ) const;

private slots:
    void onAvailabilityVerified( int exitCode, QProcess::ExitStatus exitStatus );

private:
    QMap<Encoder, Format *> m_formats; // due to Format being polymorphic, we must store pointers
    QSet<Encoder> m_availableEncoders;
};

} //namespace Transcoding

#endif //TRANSCODING_CONTROLLER_H
