/*
 *   Copyright 2010 Marco Martin <notmart@gmail.com>
 *   Copyright 2012 Sebastian Kügler <sebas@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
import QtQuick 1.1
import org.kde.plasma.components 0.1 as PlasmaComponents
import org.kde.plasma.core 0.1 as PlasmaCore

ListItem {
    id: listItem
    property string text;
    property string date;
    property bool articleRead: false
    height: childrenRect.height

    Item {
        anchors.leftMargin: 12
        height: titleLabel.height + authorLabel.height
        width: parent.width - 24
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.verticalCenter: parent.verticalCenter

        PlasmaComponents.Label  {
            id: titleLabel
            width: parent.width - 24
            wrapMode: Text.WordWrap
            textFormat: Text.RichText
            text: listItem.text
            anchors { leftMargin: 12; bottomMargin: 2; topMargin: 2; top: parent.top; }
        }
        PlasmaComponents.Label  {
            id: dateLabel
            width: parent.width
            horizontalAlignment: Text.AlignRight
            font.pointSize: theme.smallestFont.pointSize
            text: listItem.date
            opacity: 0.5
            visible: 0 < listItem.width - authorLabel.paintedWidth - paintedWidth - 48;
            anchors { top: titleLabel.bottom; right: titleLabel.right; }
        }
        PlasmaComponents.Label  {
            id: authorLabel
            width: parent.width
            font.pointSize: theme.smallestFont.pointSize
            text: i18n("by %1", author)
            anchors { top: titleLabel.bottom; left: titleLabel.left; }
        }
    }
}
