
#include "wmxkb.h"

#if HAVE_FSLIB
# include <X11/fonts/FSlib.h>
#endif

#include <string.h>
#include <stdlib.h>

extern Display *disp;


#if HAVE_FSLIB

char *fServerName;

//====================================================
Bool initFontServer(void)
{
	int npaths, i;
	
	char **xFontPaths = XGetFontPath(disp, &npaths);
	char *fPath, *sep;
	Bool stat = False;
	FSServer *svrHandle;
	
	fServerName = NULL;
	
	if (xFontPaths == NULL || npaths == 0)
		goto Arrivederci;
		

	for (i=0; i<npaths; i++) {
		fPath = xFontPaths[i];
		sep = strchr(fPath, '/');
		if (sep != NULL && *(sep+1)==':') {
			svrHandle = FSOpenServer(fPath);	
			if (svrHandle != NULL) {
				FSCloseServer(svrHandle);
				fServerName = strdup(fPath);			
				stat = True;
			}
			break;
		}	
	}	


Arrivederci:
	XFreeFontPath(xFontPaths);
	return stat;
	
} 

void deinitFontServer(void)
{
	if (fServerName != NULL)
		free(fServerName);
}

#endif	

char **getFontPaths(int *count)
{
#if HAVE_FSLIB	
	if (fServerName != NULL) {
		char **result = NULL;
		FSServer *svrHandle = FSOpenServer(fServerName);
		if (svrHandle != NULL) {
		 //   result = FSListExtensions (svrHandle, count);
		//	FSFreeExtensionList(result);

			result = FSListCatalogues (svrHandle, NULL,
                                  100, count);
		//	result = FSGetCatalogues (svrHandle, count);
			FSFreeCatalogues(result);

		//	result = FSListFonts (svrHandle, "*",
        //                          100, count);
		//	FSFreeFontNames(result);
								  
			FSCloseServer(svrHandle);
		}
		return result;	
	} else
#endif	
		return XGetFontPath(disp, count);
}		

void setFontPaths(int count, char **allPaths)
{
#if HAVE_FSLIB	
	if (fServerName != NULL) {
		Bool result = False;
		FSServer *svrHandle = FSOpenServer(fServerName);
		if (svrHandle != NULL) {
			result = (FSSetCatalogues (svrHandle, count, allPaths) == 0);
			FSCloseServer(svrHandle);
		}
	} else
#endif	
		XSetFontPath(disp, allPaths, count);
}		

