/*
 * uptime.c - module to get uptime in seconds for freebsd
 * Copyright(C) 2003 Justin Spadea <jzs@mail.rit.edu>
 *
 * submitted by Kate Ward <kate.ward@forestent.com>
 *
 * This function is taken directly from the Solaris 8 patch for wmmon.  The
 * full wmmon source can be found at http://www.rampant.org/~dp/.
 *
 * licensed under the GPL
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <utmpx.h>

/* return uptime in seconds */
int get_uptime()
{
   struct utmpx *u, id;

   id.ut_type = BOOT_TIME;
   u = getutxid(&id);

   return (time(0) - u->ut_xtime);
}
