/*
 * uptime.c - module to get uptime in seconds for OS/2
 * Copyright(C) 2003 Thomas Hoffmann
 *
 *
 * Much of this function is from wmUptime,
 * Copyright(C) 1999 Joakim Elofsson <basemetal@linux.nu>
 *
 *
 * licensed under the GPL
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define INCL_BASE
#define INCL_DOSMISC       /* DOS Miscellaneous values */
#define INCL_DOSERRORS     /* DOS Error values         */

#include <os2.h>
#include <stdio.h>

// #include <sys/stat.h>
// #include <sys/sysctl.h>

/* return uptime in seconds */
int get_uptime()
{
 int uptime;
 ULONG msuptime;
 APIRET      rc;

 rc = DosQuerySysInfo(QSV_MS_COUNT, QSV_MS_COUNT,
              (PVOID)(&msuptime),sizeof(ULONG));

 if (rc) {    fprintf(stderr, "DosQuerySysInfo error  return code = %u\n", rc);
   return(0);
 }

 uptime = (int)(msuptime/1000L);
#if DEBUG
     printf("-----------------------\n");
     printf("Uptime in seconds:\t%s\n", uptime);
     printf("-----------------------\n\n");
#endif
     return uptime;
}
