/*
 * uptime.c - module to get uptime in seconds for linux
 * Copyright(C) 2003  Justin Spadea <justin@j-z-s.com>
 *
 * licensed under the GPL
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <fcntl.h>

/* return uptime in seconds */
int get_uptime()
{
   char buffer[BUFSIZ];
   int fd, len, i=0;

   /* read /proc/uptime */
   fd = open("/proc/uptime", O_RDONLY);
   if (fd < 0) {
      perror("can't open /proc/uptime");
      exit(1);
   }
   len = read(fd, buffer, BUFSIZ - 1);
   if (len < 0) {
      perror("can't read /proc/uptime");
      exit(1);
   }
   close(fd);

   while( *(buffer+i) != '.') i++;
   buffer[i] = '\0';

#if DEBUG
   printf("-----------------------\n");
   printf("Uptime in seconds:\t%s\n", buffer);
   printf("-----------------------\n\n");
#endif

   return atoi(buffer);
}
