/*
 * uptime.c - module to get uptime in seconds for freebsd
 * Copyright(C) 2003 Justin Spadea <justin@j-z-s.com>
 *
 *
 * Much of this function is from wmUptime,
 * Copyright(C) 1999 Joakim Elofsson <basemetal@linux.nu>
 *
 *
 * licensed under the GPL
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <sys/stat.h>
#include <sys/sysctl.h>

/* return uptime in seconds */
int get_uptime()
{
	
   int mib[2] = {CTL_KERN, KERN_BOOTTIME};
   struct timeval boottime;
   time_t now;
   int size = sizeof(boottime);
   int uptime;
 
   if((sysctl(mib, 2, &boottime, &size, NULL, 0) != -1)
	   && (boottime.tv_sec != 0)) {
      time(&now);
      uptime = now - boottime.tv_sec;
#if DEBUG
      printf("-----------------------\n");
      printf("Uptime in seconds:\t%s\n", uptime);
      printf("-----------------------\n\n");
#endif
      return uptime;
   }
   return 0;
}
