/*  ---------------------------------------------------------------
    wmALMS.  Another LM Sensors applet.
    Copyright (C) 2001,  Michael Glickman  <wmalms@yahoo.com>
    License: GPL
    --------------------------------------------------------------- */

#include "wmalms.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAS_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAS_LIMITS_H
#include <limits.h>
#endif

#ifdef LONG_MAX
#define LONG_MAX  0x7fffffffl
#endif

#ifndef LONG_MIN
#define LONG_MIN (-LONG_MAX - 1)
#endif

#include <ctype.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xresource.h>
#include <X11/xpm.h>
#include "wmalms.xpm"
#include "wmalms48.xpm"

#if TRY_SHAPES
#include <X11/extensions/shape.h>
#endif

#define FreeString(str) if ((str) != NULL) \
               { free(str); (str) = NULL; }

extern int ValueCount;
extern int PaneCount, CurPane;
extern const int PaneValueCount;
extern const int WndNormSize, WndSmallSize;

Display *disp = NULL;
Colormap cmap = None;

int	screen;
int wndmode = 0;
int IconTitleIndices[ICON_TITLE_INDEX_COUNT_MAX];
int IconTitleIndexCount;
Bool ShapePresent;
unsigned long black, white;
unsigned long  fgcolt[PANE_COUNT_MAX];
XColor bgcol[PANE_COUNT_MAX];
XColor fgled[2];
char *FontName;
char *dispname;

static Pixmap pmp_bkgr[PANE_COUNT_MAX];
static Pixmap mask_bkgr[PANE_COUNT_MAX];

static Window wndmain = None, wndicon = None, wndroot;
static Window wndused;
static GC	gc = None;
static Atom   WMProtAtom, WMDelAtom;

static int	depth;

Bool Transient;
int WndSize, WndX, WndY, IsXY;

extern LMS_VALUE lmsval[VALUE_COUNT_MAX];
extern char *DevName;

static Bool HasDocketSupport(void);


			
Bool OpenAllWindows(int argc, char **argv)
{
  XClassHint xch;
  XGCValues xgcv;
  XWMHints xwmh;
  XSizeHints xsh;
  XTextProperty tpname;
  char *classname;
  const char *progname;
    
  progname = argv[0];
  classname = strrchr(progname, '/');
  if (classname) progname = classname+1;

  XrmInitialize();

  if (!ProcessNonStoredOptions(&argc, argv)) return False;
  

  if (!(disp = XOpenDisplay(dispname))) {
	fprintf(stderr, "%s: can't open display %s.\nFYI: This is an X application\n", 
    	    progname, XDisplayName(dispname));
	return False;
  }

  screen  = DefaultScreen(disp);
  wndroot = RootWindow(disp, screen);
  depth = DefaultDepth(disp, screen);
  black = BlackPixel(disp, screen);
  white = WhitePixel(disp, screen);
  cmap = DefaultColormap(disp, screen);    


#if TRY_SHAPES
  { int event_base, error_base;
	ShapePresent = XShapeQueryExtension(disp, &event_base, &error_base);
  }	
#endif

  if (!ProcessOptions(argc, argv)) return False;

  wndmain = XCreateSimpleWindow(disp, wndroot,
			 WndX, WndY, WndSize, WndSize, 1, white, black);
  if (wndmain == None) return False;

  XSetCommand(disp, wndmain, argv, argc);

  if (XStringListToTextProperty((char **)&progname, 1, &tpname))
  XSetWMName(disp, wndmain, &tpname);
  XSetWMIconName(disp, wndmain, &tpname);

  if (wndmode < 0 || wndmode > 2) 
	wndmode = HasDocketSupport() ? 0 : 1;  
  	

  if (wndmode == 0)
  {
    wndicon = XCreateSimpleWindow(disp, wndmain,
		          0, 0, WndSize, WndSize, 1, white, black);
	if (wndicon == None) return False;
	wndused = wndicon;
  }
  else
  {	  
	wndicon = None;
	wndused = wndmain;

    if (Transient)
		XSetTransientForHint(disp, wndmain, wndroot);
  }
    	
		
  xch.res_name = (char *)progname;
  classname = strdup(progname);
  *classname = toupper(*classname);
  *(classname+1) = toupper(*(classname+1));
  xch.res_class = classname;
  XSetClassHint(disp, wndmain, &xch);
  free(classname);

  XSetWindowBackgroundPixmap(disp, wndused, None);

  XSelectInput(disp, wndused, ButtonPressMask | ExposureMask);
	/*ButtonReleaseMask | PointerMotionMask | StructureNotifyMask); */


  /* Create GC for drawing */
  xgcv.function = GXcopy;
  xgcv.foreground = white;
  xgcv.background = black;
  xgcv.graphics_exposures = 0;
  gc = XCreateGC(disp, wndroot,
	  GCFunction | GCForeground | GCBackground | GCGraphicsExposures, &xgcv);


  xsh.height = WndSize;
  xsh.width = WndSize;
  xsh.min_height = WndSize;
  xsh.min_width = WndSize;
  xsh.max_height = WndSize;
  xsh.max_width = WndSize;
  xsh.base_width = WndSize;
  xsh.base_height = WndSize; 
  xsh.flags =   USSize | PMinSize | PMaxSize | PBaseSize;
  
  if (IsXY)
  {   xsh.x = WndX;	/* Though it's obsolete I don't see another way */
	  xsh.y = WndY;   /* of preventing wmaker & fvwm from mouse placement */
	  xsh.flags |=  (USPosition | PPosition) ;
  }	  
  
  XSetWMNormalHints(disp, wndused, &xsh);

  if (IsXY)
	XMoveWindow(disp, wndused, WndX, WndY);	/* In imaginary case USPosition does not work */

  if (wndused == wndicon)
  { 
	xsh.x = 0; xsh.y = 0;
	xsh.flags =  USPosition;
	XSetWMNormalHints(disp, wndmain, &xsh);
  	XMoveWindow(disp, wndmain, 0, 0);
  }	
  

  WMProtAtom = XInternAtom(disp, "WM_PROTOCOLS", True);
  WMDelAtom = XInternAtom(disp, "WM_DELETE_WINDOW", True);
    
  if (WMProtAtom != (Atom)None && WMDelAtom != (Atom)None)
        XSetWMProtocols(disp, wndmain, &WMDelAtom, 1);

  if (wndmode == 2) {
	xwmh.flags =  StateHint;
    xwmh.initial_state = IconicState;
    XSetWMHints(disp, wndmain, &xwmh);
  }
  else
  if (wndicon != None)
  {
	xwmh.flags =  StateHint |  IconWindowHint | IconPositionHint | WindowGroupHint;
    xwmh.initial_state = WithdrawnState;
    xwmh.icon_window = wndicon;
    xwmh.icon_x = 0;
	xwmh.icon_y = 0;
    xwmh.window_group = wndmain;
	
    XSetWMHints(disp, wndmain, &xwmh);
  }	
    
    
  return True;
}

void CloseAllWindows(void)
{

  if (wndicon)
  {
	XDestroyWindow (disp, wndicon);
	wndicon = None;
  }	

  if (wndmain != None)
  {
	XDestroyWindow (disp, wndmain);
	wndmain = None;
  }	

  if (gc != None)
  {
	XFreeGC(disp, gc);
	gc = None;
  }	


  if (disp != NULL)
  {
	XCloseDisplay(disp);
    disp = NULL;		
  }	

    
}



Bool CreateAllPixmaps(void)
{
  int xpm_err;
  int i;
  XpmAttributes xpma;
  static char lineled1[21];
  static char lineled2[21];
  static char linebg[21];
	
  for (i=0; i<PaneCount; i++)
  { pmp_bkgr[i] = None;
	mask_bkgr[i] = None;
  }


  sprintf (lineled1, "@\tc #%04X%04X%04X", (unsigned int) fgled[0].red,
	      (unsigned int)fgled[0].green, (unsigned int)fgled[0].blue);

  sprintf (lineled2, "1\tc #%04X%04X%04X", (unsigned int) fgled[1].red,
	      (unsigned int)fgled[1].green, (unsigned int)fgled[1].blue);

  for (i=0; i<PaneCount; i++)
  {


    if (bgcol[i].pixel == NO_COLOUR)
	   	strcpy (linebg, " \tc None");
  	else
	{   
		sprintf (linebg, " \tc #%04X%04X%04X", (unsigned int) bgcol[i].red,
	        (unsigned int)bgcol[i].green, (unsigned int)bgcol[i].blue);
  	}	    		    
  
	memset(&xpma, '\0', sizeof(XpmAttributes));
	xpma.valuemask = XpmReturnPixels | XpmReturnExtensions;


    if (WndSize == WndNormSize)
	{  
  	  wmalms_xpm[1] = linebg;
	  wmalms_xpm[2] = lineled1;
      wmalms_xpm[3] = lineled2;
	  xpm_err = XpmCreatePixmapFromData(disp, wndroot, wmalms_xpm,
				&pmp_bkgr[i], &mask_bkgr[i], &xpma);
    }
	else
    {
	  wmalms48_xpm[1] = linebg;
	  wmalms48_xpm[2] = lineled1;
  	  wmalms48_xpm[3] = lineled2;
      xpm_err = XpmCreatePixmapFromData(disp, wndroot, wmalms48_xpm,
				&pmp_bkgr[i], &mask_bkgr[i], &xpma);
	}				
  				

    if (xpm_err != XpmSuccess)
    {
			fprintf (stderr, "Error creating pixmap, code %d\n", xpm_err);
			return False;
    }

  }

  return True;	
			
}


void DestroyAllPixmaps(void)
{
  int i;

  for (i=0; i<PaneCount; i++)
  {
	if (pmp_bkgr[i])
  	{	
	  XFreePixmap(disp, pmp_bkgr[i]);
	  pmp_bkgr[i] = None;
	}

	if (mask_bkgr[i])
	{	
	  XFreePixmap(disp, mask_bkgr[i]);
	  mask_bkgr[i] = None;
    }

	if (fgcolt[i] != white)
    	XFreeColors(disp, cmap, fgcolt+i, 1, 0);
	
  }	  

}

void FreeAllString(void)
{
	FreeString(dispname);
	FreeString(DevName);
}


Bool DrawTitles(void)
{
  int i, j, k, len;
  XFontStruct *xfs;
  Pixmap cur_pixmap, cur_mask;
  int ascent, descent, height;
  char *str;
  int x, y, yoff;
  GC  bwgc = None;
  XGCValues xgcv;
  unsigned long gcmask;
  
  xfs = XLoadQueryFont(disp, FontName);
  if (xfs == None) 
    xfs = XLoadQueryFont(disp, "fixed");
  if (xfs == None) return False;	
  
  ascent = xfs->ascent;
  descent = xfs->descent;
  height = ascent + descent;
  yoff = (14 - height) / 2;
  
	
  XSetFont(disp, gc, xfs->fid);
  k = 0;

  xgcv.function = GXcopy;
  xgcv.plane_mask = 1;
  xgcv.foreground =  1;
  xgcv.background = 0;
	 
  gcmask = GCFunction | GCPlaneMask | GCForeground | GCBackground;
  bwgc = None;

     
  for (i=0; i<PaneCount; i++)
  {
	cur_pixmap = pmp_bkgr[i];
	cur_mask = mask_bkgr[i];	  
	if (cur_mask != None && bwgc == None) 
	{
	  bwgc = XCreateGC(disp, cur_mask, gcmask, &xgcv);
	  XSetFont(disp, bwgc, xfs->fid);
	}	  

    XSetForeground(disp, gc, fgcolt[i]);

	for (j=0; j<PaneValueCount; j++)
	{
		if (lmsval[k].number >= 0)
		{	
			str = lmsval[k].label;
			len = strlen(str);
			if (WndSize == WndNormSize)
			{  x = 29 - XTextWidth(xfs, str, len);
			   y = j * 14 + 3 + yoff + ascent;
			}
			else
			{  x = 22 - XTextWidth(xfs, str, len);
			   y = j * 12 + yoff -1 + ascent;
			}
						   
		    XDrawString(disp, cur_pixmap, gc, x, y, str, len); 
			if (cur_mask != None && bwgc != None)
				XDrawString(disp, cur_mask, bwgc, x, y, str, len); 
	    }
		
		k++;		
	 }
  
  }

  XFreeFont(disp, xfs);
  
  return True;
}

void ProcessEvents(void)
{
  XEvent evnt;

#if TRY_SHAPES
  static Pixmap OldShape=None;
  Pixmap NewShape;
#endif
    
  while (1)
  {    
    
	XNextEvent(disp, &evnt);

	switch(evnt.type)
	{ 
	  case Expose:
		if (evnt.xexpose.count == 0)
		{
		  ShowLMS();

#if TRY_SHAPES
		  NewShape = mask_bkgr[CurPane];

		  if (NewShape != OldShape)
		  {
    		 XShapeCombineMask(disp, wndused, ShapeBounding, 0, 0, NewShape, ShapeSet);
			 OldShape = NewShape;
		  }			 			 
#endif
		  XCopyArea(disp, pmp_bkgr[CurPane], evnt.xexpose.window,  gc, 0, 0,
        	  WndSize, WndSize, 0, 0);

		}	       
		break;
		
	  case ButtonPress:
		if (evnt.xbutton.state & ShiftMask)
		{  int btn = evnt.xbutton.button;
		   if (btn == Button1)
		   {
		     SetCurrentPage((CurPane+PaneCount-1) % PaneCount);
		     SendExposeEvent();
		   }		 
		   else
		   if (btn == Button3)
		   {
		     SetCurrentPage((CurPane+1) % PaneCount);
		     SendExposeEvent();
		   }		 
		}
		else
		if ((evnt.xbutton.state & ControlMask) 
		                       && evnt.xbutton.button == Button3)
		    return;							   
		  
		break;		
		
	  case ClientMessage:
		if (evnt.xclient.message_type == WMProtAtom &&	
            evnt.xclient.data.l[0] == WMDelAtom)
			  return;
	}    
  }
}

Bool HasDocketSupport(void)
{
	static const char *propNames[] = { "_WINDOWMAKER_WM_PROTOCOLS",
	                                  "_BLACKBOX_PID", "_PWM_WORKSPACE_INFO"};
	static const int propTypes[] = { XA_ATOM, XA_CARDINAL, XA_INTEGER };
	static const int count = sizeof(propNames) / sizeof(char *);
    Atom property;
	Bool result = False;
	int i;


	for (i=0; i<count && result==False; i++) {
	    property = XInternAtom(disp, propNames[i], True);

    	if (property != None) {

	    	Atom actual_type;
	    	int actual_format;
		    unsigned long nitems, bytes_after;
    		unsigned long *data;
    
		    XGetWindowProperty(disp, wndroot, property, 0, 1,
                 False, propTypes[i],
                 &actual_type,  &actual_format,
                 &nitems, &bytes_after, (unsigned char **)&data);

			if (actual_type != None) result = True;
		}
	}
	
	return result;

}    


void ShowIt(void)
{
    if (disp != NULL && wndmain != None)
    {
		UpdateLMS();
		UpdateIconTitle();
        XMapWindow(disp, wndmain);
        XFlush(disp);
    }	
}

void SendExposeEvent(void)
{
    XExposeEvent xev;

    if (disp == NULL || wndused == None)
			return;

    xev.type = Expose;
    xev.serial = 0;
    xev.send_event = True;
    xev.display = disp;
    xev.x = 0;
    xev.y = 0;
    xev.width = WndSize;
    xev.height = WndSize;
    xev.count = 0;
    

/*	XClearArea(disp, wndicon, 0, 0, WndSize, WndSize, True); */
    xev.window = wndused;
    XSendEvent(disp, wndused, True, ExposureMask, (XEvent *) &xev);
	
/*
	XClearArea(disp, wndicon, 0, 0, WndSize, WndSize, True);
    xev.window = wndicon;
    XSendEvent(disp, wndicon, True, ExposureMask, (XEvent *) &xev);
*/
    XFlush(disp);  /* Wakes up event waiting */
}

void CopyPixmap(int sx, int sy, int w, int h, int dx, int dy)
{
	Pixmap CurPmpBkgr;

	CurPmpBkgr = pmp_bkgr[CurPane];

	if (disp != NULL && CurPmpBkgr != None && gc != None)
		XCopyArea(disp, CurPmpBkgr, CurPmpBkgr, gc,  sx, sy, w, h, dx, dy) ;
}


void UpdateIconTitle(void)
{
	int i, index;
	long value;
	int decimals;
	char fullTxt[33*ICON_TITLE_INDEX_COUNT_MAX];
	char valueTxt[12];
	const char *sep;

	*fullTxt = '\0';

	for (i=0; i<IconTitleIndexCount; i++) {
		index = IconTitleIndices[i];
		if (index < 0 || index >= ValueCount) continue;

		value = lmsval[index].new_value;
		decimals = lmsval[index].decimals;
		
		if (decimals == 0)		
			sprintf (valueTxt, "%ld", value);
		else {
			int num = 1;
			while (--decimals >= 0) num *=10;
			sprintf (valueTxt, "%ld.%ld", value/num, value%num);
		}	

		sep = (*fullTxt == '\0') ? "" : " ";
		sprintf(fullTxt+strlen(fullTxt), "%s%s: %s", sep, lmsval[index].label, valueTxt);	
	}			 

	if (*fullTxt != '\0') {
		XTextProperty iconName;
		char *fullTxtPtr = fullTxt;

		if (XStringListToTextProperty(&fullTxtPtr, 1, &iconName))
		 XSetWMIconName(disp, wndmain, &iconName);
	}	 
}

void JustBeep(void)
{
  XBell(disp, 100);
}
