/*  ---------------------------------------------------------------
    wmALMS.  Another LM Sensors applet.
    Copyright (C) 2001,  Michael Glickman  <wmalms@yahoo.com>
    License: GPL
    --------------------------------------------------------------- */

#include "wmalms.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#ifdef HAS_UNISTD_H
#include <unistd.h>
#endif
/*
#ifdef HAS_LIMITS_H
#include <limits.h>
#endif

#ifdef LONG_MAX
#define LONG_MAX  0x7fffffffl
#endif

#ifndef LONG_MIN
#define LONG_MIN (-LONG_MAX - 1)
#endif

#include <ctype.h>
*/
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>

#define GlobalResDir "/usr/lib/X11/app-defaults"

#define ResFileName  "WMalms"
#define ResClassName  "WMalms"
#define ResModuleName "wmalms"

#define FreeString(str) if ((str) != NULL) \
               { free(str); (str) = NULL; }

extern int ValueCount;
extern int PaneCount, CurPane;
extern int RefreshInterv, BeepInterv;
extern int PageShiftInterv[PANE_COUNT_MAX];
extern int screen;
extern Bool ShapePresent;

extern LMS_VALUE lmsval[VALUE_COUNT_MAX];

extern Display *disp;
extern Colormap cmap;

extern int wndmode;
extern int IconTitleIndices[ICON_TITLE_INDEX_COUNT_MAX];
extern int IconTitleIndexCount;
extern unsigned long black, white;
extern unsigned long  fgcolt[PANE_COUNT_MAX];
extern XColor bgcol[PANE_COUNT_MAX];
extern XColor fgled[2];
extern char *FontName;
extern char *dispname;
extern char *DevName;

extern int ProcessAlarm;
extern int wndmode;
extern const int WndNormSize, WndSmallSize;
extern const int PaneValueCount;
extern const char *DefaultFontNameNormSize, *DefaultFontNameSmallSize;
extern int WndX, WndY, WndSize, IsXY;


extern const int RefreshIntervMin, RefreshIntervMax, RefreshIntervDefault;
extern const int PageShiftIntervMin, PageShiftIntervMax, PageShiftIntervDefault;
extern const int BeepIntervMin, BeepIntervMax, BeepIntervDefault;
extern const int PaneCountDefault;
extern const char *NamesDefault[PANE_COUNT_MAX];
extern const char *DefaultTextColour[PANE_COUNT_MAX];
extern const char *DefaultBgColour[PANE_COUNT_MAX];
extern const char *DefaultLedColour[2];  /* Led normal, led alarm */
extern const int FldSeparator;

extern Bool Fahrenheit, Transient;


static const XrmOptionDescRec nonStoredTable[] =
{
	{"-display",  "*display",  XrmoptionSepArg,  (XPointer)NULL },
	{"-help",     "*help",   XrmoptionNoArg,  (XPointer)"1" },
	{"-save",     "*save",   XrmoptionNoArg,  (XPointer)"1" }
};	

static const int nonStoredTabCount = sizeof(nonStoredTable) / sizeof(XrmOptionDescRec);


static const XrmOptionDescRec opttable[] =
{
	{"-geometry",  "*geometry",  XrmoptionSepArg,  (XPointer)NULL },
	{"-nogeometry", "*geometry",  XrmoptionNoArg,  (XPointer)"" },
	{"-device",    "*device",  XrmoptionSepArg,  (XPointer)NULL },
	{"-pages",     "*pageCount",  XrmoptionSepArg,  (XPointer)NULL },
	{"-refresh",   "*refreshInterval",  XrmoptionSepArg,  (XPointer)NULL },
	{"-shift",     "*pageShiftInterval",  XrmoptionSepArg,  (XPointer)NULL },
	{"-beep",      "*beepInterval",   XrmoptionSepArg,  (XPointer)NULL},
	{"-nobeep",    "*beepInterval",   XrmoptionNoArg,  (XPointer)"0"},
	{"-transient", "*transient",   XrmoptionNoArg,  (XPointer)"1"},
	{"-notransient", "*transient",   XrmoptionNoArg,  (XPointer)"0"},
	{"-alarm",     "*alarm",   XrmoptionNoArg,  (XPointer)"1"},
	{"-noalarm",   "*alarm",   XrmoptionNoArg,  (XPointer)"0"},
	{"-bg",        "*background",  XrmoptionSepArg,  (XPointer)NULL },
	{"-led",       "*foregroundLed",    XrmoptionSepArg,  (XPointer)NULL },
	{"-fg",        "*foregroundTitle",  XrmoptionSepArg,  (XPointer)NULL },
	{"-font",      "*fontName",     XrmoptionSepArg,  (XPointer)NULL },
	{"-wmode",     "*windowMode",  XrmoptionSepArg,  (XPointer)NULL },
	{"-wmode=",    "*windowMode",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-wnd",       "*windowMode",  XrmoptionNoArg,  (XPointer)"W" },
	{"-iconic",    "*windowMode",  XrmoptionNoArg,  (XPointer)"I" },
	{"-docked",    "*windowMode",  XrmoptionNoArg,  (XPointer)"D" },
	{"-fahr",      "*fahrenheit",  XrmoptionNoArg,  (XPointer)"1" },
	{"-cent",      "*fahrenheit",  XrmoptionNoArg,  (XPointer)"0" },
	{"-itind",     "*iconTitleIndices",   XrmoptionSepArg,  (XPointer)NULL },
	{"-itind=",    "*iconTitleIndices",  XrmoptionStickyArg,  (XPointer)NULL },
	{"-noitind",   "*iconTitleIndices",  XrmoptionNoArg,  (XPointer)"" },

	{"-value1",    "*lmsValue1",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value2",    "*lmsValue2",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value3",    "*lmsValue3",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value4",    "*lmsValue4",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value5",    "*lmsValue5",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value6",    "*lmsValue6",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value7",    "*lmsValue7",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value8",    "*lmsValue8",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value9",    "*lmsValue9",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value10",   "*lmsValue10",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value11",   "*lmsValue11",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value12",   "*lmsValue12",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value13",   "*lmsValue13",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value14",   "*lmsValue14",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value15",   "*lmsValue15",  XrmoptionSepArg,  (XPointer)NULL },
	{"-value16",   "*lmsValue16",  XrmoptionSepArg,  (XPointer)NULL },
/*
	{"-	geometry=", "*geometry",    XrmoptionStickyArg,  (XPointer)NULL },
	{"-device=",   "*device",      XrmoptionStickyArg,  (XPointer)NULL },
	{"-bg=",       "*background",  XrmoptionStickyArg,  (XPointer)NULL },
	{"-led=",      "*foregroundLed",     XrmoptionStickyArg,  (XPointer)NULL },
	{"-fg=",       "*foregroundTitle",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-font=",     "*fontName",    XrmoptionStickyArg,  (XPointer)NULL },
	{"-pages=",    "*pageCount",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-refresh=",  "*refreshInterval",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-shift=",    "*pageShiftInterval", XrmoptionStickyArg,  (XPointer)NULL },
	{"-beep=",     "*beepInterval",      XrmoptionStickyArg,  (XPointer)NULL},
*/
	{"-value1=",   "*lmsValue1",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-value2=",   "*lmsValue2",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-value3=",   "*lmsValue3",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-value4=",   "*lmsValue4",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-value5=",   "*lmsValue5",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-value6=",   "*lmsValue6",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-value7=",   "*lmsValue7",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-value8=",   "*lmsValue8",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-value9=",   "*lmsValue9",   XrmoptionStickyArg,  (XPointer)NULL },
	{"-value10=",  "*lmsValue10",  XrmoptionStickyArg,  (XPointer)NULL },
	{"-value11=",  "*lmsValue11",  XrmoptionStickyArg,  (XPointer)NULL },
	{"-value12=",  "*lmsValue12",  XrmoptionStickyArg,  (XPointer)NULL },
	{"-value13=",  "*lmsValue13",  XrmoptionStickyArg,  (XPointer)NULL },
	{"-value14=",  "*lmsValue14",  XrmoptionStickyArg,  (XPointer)NULL },
	{"-value15=",  "*lmsValue15",  XrmoptionStickyArg,  (XPointer)NULL },
	{"-value16=",  "*lmsValue16",  XrmoptionStickyArg,  (XPointer)NULL }
};   

static const int opttabcount = sizeof(opttable) / sizeof(XrmOptionDescRec);
static Bool SaveMode;

typedef struct
{
  const char *argument;
  const char *description;
} HlpTable;

static const HlpTable helptable[] =
{
	{"-display",   "display name"},
	{"-save",      "save settings"},
	{"-geometry",  "geometry: size+x+y, size-x-y, etc"},
	{"",    "size is 64, 48 or omitted"},
	{"-wmode",     "window mode: Window, Docked, Iconic, Guess"},
	{"-itind",     "list of value indices shown as icon title"},
	{"-noitind",   "don't show values in icon title"},
	{"-trans",     "apply transient window status"},
	{"-notrans",   "don't apply transient window status"},
	{"-device",    "sensor device(chip) name"},
	{"-pages",     "number of pages (1-4)"},
	{"-refresh",   "refresh interval (seconds)"},
	{"-shift",     "time interval for each page"},
	{"-beep",      "beep interval (0 - don't beep)"},
	{"-nobeep",    "don't beep (as -beep 0)"},
	{"-alarm",     "alarm mode"},
	{"-noalarm",   "non-alarm mode"},
	{"-bg",        "background colour(-s), none - transparent"},
	{"-led",       "led colours: normal and alarm"},
	{"-fg",        "label colours"},
	{"-font",      "label font name"},
	{"-cent",      "show Centigrade temperatures"},
	{"-fahr",      "show Fahrenheit temperatures"},
	{"-value1",    "settings for value 1"},
	{" ...   ",    "..."},
	{"-value16",   "settings for value 16"},
	{"-help",      "these instructions"}
};   

static const int hlpcount = sizeof(helptable) / sizeof(HlpTable);


/* ---------------------------------------------------------- */
/*               Arguments                                    */
/* ---------------------------------------------------------- */
static Status GetResourceString(XrmDatabase database, const char *parmname,
                         char **string_return)
{

  XrmValue xrmv;
/*  int sz; */
  char *str; 

  if (!XrmGetResource(database, parmname, ResClassName,  &str, &xrmv))
		return False;
/*
  sz = xrmv.size;
  str = malloc(sz+1);
    
  if (str == NULL) return False;

  memcpy(str, xrmv.addr, sz);
  *(str + sz) = '\0';

  *string_return = str;
*/
  *string_return  = strdup(xrmv.addr);
  return True;

}

static Status GetResourceString2(XrmDatabase database, const char *parmname,
                         char *string, int length)
{
  XrmValue xrmv;
  char *argtype;
  int sz;

  if (!XrmGetResource(database, parmname, ResClassName,  &argtype, &xrmv))
		return False;

  sz = xrmv.size;
  if (sz >= length) sz = length;

  memcpy(string, xrmv.addr, sz);
  *(string + sz) = '\0';

  return True;

}

static Bool GetResourceBool(XrmDatabase database, const char *parmname, Bool defval)
{
  XrmValue xrmv;
  char *argtype;
  Bool result = defval;
  
  
  if (XrmGetResource(database, parmname, ResClassName,  &argtype, &xrmv)
           && xrmv.size > 0)
  {	 char chr  = * (char *) xrmv.addr;
     
     if (strchr("Yy1", chr)) result = True;
	 else
     if (strchr("Ny0", chr)) result = False;
  }	 

  return result;

}

static int GetResourceChoice(XrmDatabase database, const char *parmname, const char *choices, int defVal)
{
	XrmValue xrmv;
	char *argtype;
	int result = defVal;

	if (XrmGetResource(database, parmname, ResClassName,  &argtype, &xrmv)
           && xrmv.size > 0) {
		char *codePtr = (char *) xrmv.addr;
		char code =  toupper(*codePtr);
		if (isdigit(code)) {
			int tmp = atoi(codePtr);
			if (tmp >= 0 && tmp < strlen(choices))
				result = tmp;
		} else {
			char *ptr = strchr(choices, code);
			if (ptr != NULL) 
				result = (int) (ptr-choices);		
		}			
	}
	
	return result;
}




static Bool GetParsedColour(const char *colourname, XColor *xc, int isBg)
{

  if (isBg && strcasecmp(colourname, "none") == 0)
  {
	if ( ShapePresent)
	{  memset(xc, 0xff, sizeof(XColor));
	   return True;
	}
	else
	  colourname = "rgb:00/00/00";	   
  }

  return XParseColor(disp, cmap, colourname, xc);
}

static void GetResourceColour(XrmDatabase database, const char *parmname,
               int max_count, XColor *result, const char **defcolour, int isBg)
{
  XrmValue xrmv;
  char *next, *tmp;
  char *strvptr, *strvstart;
  char *defcolptr;
/*  int  sz; */
  Bool stat, advance;
  
  strvstart = NULL;
  defcolptr = (char *) *defcolour;
  advance = True;
  
  if (XrmGetResource(database, parmname, ResClassName,  &tmp, &xrmv))
	strvstart = strdup(xrmv.addr);
/*  
  {
    sz = xrmv.size;
	
	strvstart = malloc(sz+1);

    if (strvstart != NULL) 
	{
	  memcpy(strvstart, xrmv.addr, sz);
	  *(strvstart + sz) = '\0';
	}
  }		  
*/  
  strvptr = strvstart;
  next = NULL;

  while (--max_count >= 0)
  {

	if (strvptr)
	{
	/*  if (max_count > 0) */
  	  {	next = strchr(strvptr, FldSeparator);
  	    if (next) *next++ = '\0';
	  }		

      stat = GetParsedColour(strvptr, result, isBg);
	  if (isBg)
	  {  defcolptr = strvptr;
		 advance = False;
	  }		
  	  strvptr = next;
	}
	else
	  stat = False;
		  
	if (!stat)
		stat = GetParsedColour(defcolptr, result, isBg);	
	
	result++;
	if(advance)
	{  defcolour++; defcolptr = (char *) *defcolour; }
	   
  }	

  if (strvstart) free(strvstart);
  
}

static void GetResourceColourIndex(XrmDatabase database, const char *parmname,
                   int max_count, unsigned long *result, const char **defcolour)
{
  XrmValue xrmv;
  char *next, *tmp;
  char *strvptr, *strvstart;
  XColor xc1, xc2;
  Bool stat;
  
  strvstart = NULL;
  
  if (XrmGetResource(database, parmname, ResClassName,  &tmp, &xrmv))
	strvstart = strdup(xrmv.addr);
/*  
  {
    sz = xrmv.size;
	strvstart = malloc(sz+1);

    if (strvstart != NULL) 
	{
	  memcpy(strvstart, xrmv.addr, sz);
	  *(strvstart + sz) = '\0';
	}
  }		  
*/  
  strvptr = strvstart;
  next = NULL;

  while (--max_count >= 0)
  {

	if (strvptr)
	{
	/*  if (max_count > 0) */
  	  {	next = strchr(strvptr, FldSeparator);
  	    if (next) *next++ = '\0';
	  }		
      stat = XAllocNamedColor(disp, cmap, strvptr, &xc1, &xc2);
  	  strvptr = next;
	}
	else
	  stat = False;
		  
	if (!stat)
		stat = XAllocNamedColor(disp, cmap, *defcolour, &xc1, &xc2);	
	
	*result++ = xc1.pixel;
	defcolour++;
  }	

  if (strvstart) free(strvstart);
  
}

static void GetResourceInteger(XrmDatabase database, const char *parmname,
                         int max_count, int *result,
						 int minvalue, int maxvalue, int defvalue)
{
  XrmValue xrmv;
  char *next, *tmp;
  char *strvptr, *strvstart;
  long lval, lval1;
  int  sz;
  

  strvstart = NULL;
  
  if (XrmGetResource(database, parmname, ResClassName,  &tmp, &xrmv))
  {
    sz = xrmv.size;
	strvstart = malloc(sz+1);

    if (strvstart != NULL) 
	{
	  memcpy(strvstart, xrmv.addr, sz);
	  *(strvstart + sz) = '\0';
	}
  }		  
  
  strvptr = strvstart;
  lval = defvalue;
  next = NULL;

  while (--max_count >= 0)
  {
	
	if (strvptr)
	{
/*	  if (max_count > 0) */
	  {	next = strchr(strvptr, FldSeparator);
  	    if (next) *next++ = '\0';
	  }		
	  lval1 = strtol(strvptr, &tmp, 0);
	  if (*tmp == '\0') lval = lval1;
		 
	}		
  
    if (lval < minvalue) lval = minvalue;
	if (lval > maxvalue) lval = maxvalue;
    *result++ = (int) lval;
	
	strvptr = next;
  }	

  if (strvstart) free(strvstart);
  
}

static int GetResourceList(XrmDatabase database, const char *parmname,
                         int max_count, int *result)
{
	XrmValue xrmv;
	char *strvptr, *strvstart;
	int  i;
	char sep;
  

	strvstart = NULL;
  
	if (XrmGetResource(database, parmname, ResClassName,  &strvptr, &xrmv) == False)
		return 0;

   	i = xrmv.size;
	strvstart = malloc(i+1);

   	if (strvstart != NULL) 
	{
	  memcpy(strvstart, xrmv.addr, i);
	  *(strvstart + i) = '\0';
	}		  

	strvptr = strvstart;
	for (i=0; i<max_count; i++) {
		while(*strvptr == ' ') strvptr++;		
		if (*strvptr == '\0') break;

		result[i] = (int) strtol(strvptr, &strvptr, 0);

		sep = *strvptr;
		if (sep == '\0') continue;
		if (strchr(",; :", sep) == NULL) {
			i = 0;	break;
		}	
		strvptr++;
	}

	if (strvstart) free(strvstart);
	
	return i;
}

static void ShowHelp(FILE *f)
{
  int i;

  fprintf (f, "\n");
  fprintf (f, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
  fprintf (f, "wmALMS. Another LM Sensors dockable/swallowed applet\n");
  fprintf (f, "Version " VERSION_TXT ", compiled " __DATE__ " " __TIME__ "\n");
  fprintf (f, "Copyright (C) 2001 Michael Glickman <wmalms@yahoo.com>\n");
  fprintf (f, "Web site: http://www.geocities.com/wmalms/\n");
  fprintf (f, "------------------------------------------------------------\n");

  for (i=0; i<hlpcount; i++)
	fprintf (f, "%-12s %s\n", helptable[i].argument, helptable[i].description);
	
  fprintf (f, "------------------------------------------------------------\n");
  fprintf (f, "See the manual for details\n");
  fprintf (f, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");

}

static void ProcessGeometry(XrmDatabase database, const char *parmname)
{
  int  x, y, w, h, gmask;
  char *geometry;

  WndSize = WndNormSize;
  WndX = WndY = -1;
  gmask = 0;

  if (GetResourceString(database, parmname, &geometry) && geometry != NULL)
  { 
	if (*geometry != '\0')
	  gmask = XParseGeometry(geometry, &x, &y,  &w, &h);   
	  
	free(geometry);
  }		  

  if ((gmask & WidthValue) && (w == WndSmallSize))
    WndSize = w;

  IsXY = ((gmask & (XValue | YValue)) == (XValue | YValue));

  if (IsXY)
  {
	if (gmask & XNegative)
	  x += DisplayWidth(disp, screen) - WndSize;

	if (gmask & YNegative)
	  y += DisplayHeight(disp, screen) - WndSize;
		  
	WndX = x; WndY = y;
  }

}

Bool ProcessNonStoredOptions(int *argc, char **argv)
{
  XrmDatabase  xrmdb = NULL; 
  Bool rc = True;


  XrmParseCommand(&xrmdb, (XrmOptionDescList)  nonStoredTable, nonStoredTabCount,
         ResModuleName, argc, argv);

  if (xrmdb != NULL)
  {
	
	if (GetResourceBool (xrmdb, ResModuleName ".help",  False))
    {
	  ShowHelp(stderr);
	  rc = False;  
    }
	else
	{  
	  dispname = NULL;
	  GetResourceString(xrmdb, ResModuleName ".display", &dispname);
  	  SaveMode = GetResourceBool (xrmdb, ResModuleName ".save",  False);
	}	  
	XrmDestroyDatabase(xrmdb);
  }	

  return rc;  
}


Bool ProcessOptions(int argc, char **argv)
{
  XrmDatabase  xrmdb = NULL; 
  int	i;
  const char *homedir;
  char *FullResFileName = NULL;
  char parmname[21];

  Bool rc = True;
    
  xrmdb = XrmGetFileDatabase(GlobalResDir "/" ResFileName);

  homedir = getenv("HOME");
  if (homedir != NULL  &&
        (FullResFileName = malloc(strlen(homedir) + 32)) != NULL)
  {
	sprintf (FullResFileName, "%s/.%s", homedir, ResFileName);
    XrmCombineFileDatabase(FullResFileName, &xrmdb, True);
  }            

  XrmParseCommand(&xrmdb, (XrmOptionDescList) opttable, opttabcount,
         ResModuleName, &argc, argv);

  ProcessGeometry(xrmdb, ResModuleName ".geometry");


  if (!GetResourceString(xrmdb, ResModuleName ".device", &DevName))
	 DevName = NULL;
	 
  GetResourceInteger(xrmdb, ResModuleName ".pageCount", 1, &PaneCount, 
	                         PANE_COUNT_MIN, PANE_COUNT_MAX, PaneCountDefault);


  ValueCount = PaneCount * PaneValueCount;


  IconTitleIndexCount = GetResourceList(xrmdb, ResModuleName ".iconTitleIndices",
                         ICON_TITLE_INDEX_COUNT_MAX, IconTitleIndices);
  for (i=0; i<IconTitleIndexCount; i++) IconTitleIndices[i]--;							 

  GetResourceInteger(xrmdb, ResModuleName ".refreshInt", 1, &RefreshInterv,
                   RefreshIntervMin, RefreshIntervMax, RefreshIntervDefault);
							   
  GetResourceInteger(xrmdb, ResModuleName ".pageShiftInterval",
       PaneCount, PageShiftInterv, 
	   PageShiftIntervMin, PageShiftIntervMax, PageShiftIntervDefault);

  GetResourceInteger(xrmdb, ResModuleName ".beepInterval",
       1, &BeepInterv, BeepIntervMin, BeepIntervMax, BeepIntervDefault);

  /* Font name */
  FontName = strdup((WndSize == WndNormSize) ?
                        DefaultFontNameNormSize : DefaultFontNameSmallSize);

  GetResourceString(xrmdb, ResModuleName ".fontName", &FontName);
  
  if (BeepInterv > 0)
    ProcessAlarm = 1;  
  else	
    ProcessAlarm = GetResourceBool(xrmdb, ResModuleName ".alarm", False) ;
	  

  /* Led colours */
  GetResourceColour(xrmdb, ResModuleName ".foregroundLed", 2, fgled, DefaultLedColour, 0);
  		  
  /* Title colours */
  GetResourceColourIndex(xrmdb, ResModuleName ".foregroundTitle", PaneCount, fgcolt, DefaultTextColour);
	
  /* Background colours */
  GetResourceColour(xrmdb, ResModuleName ".background",  PaneCount, bgcol, DefaultBgColour, 1);

  /* Fahrenheit / Centigrade colours */
  Fahrenheit = GetResourceBool(xrmdb, ResModuleName ".fahrenheit",  False);

  /* Fahrenheit / Centigrade colours */
  Transient = GetResourceBool(xrmdb, ResModuleName ".transient",  False);

  ClearLMS();


  for (i=0; i<ValueCount; i++)
  {
    strcpy(lmsval[i].name, NamesDefault[i]);
	sprintf (parmname, ResModuleName ".lmsValue%d", i+1);
	if (GetResourceString2(xrmdb, parmname, parmname, 20))
	  ParseLMSPref(i, parmname);
  }

  /* Window mode */
  wndmode = GetResourceChoice(xrmdb, ResModuleName ".windowMode", "DWIG", 3);
		
	/* Others */
  if (argc > 1)
  {
	  ShowHelp(stderr);
	  fprintf (stderr, "\nParameter '%s' is not recognised\n", argv[1]);			
	  rc = False;
  }
  else
  if (SaveMode && FullResFileName != NULL)
	  XrmPutFileDatabase(xrmdb, FullResFileName);
  						   
  XrmDestroyDatabase(xrmdb);
  if (FullResFileName) free(FullResFileName);
  return rc;    
}
