#include "wmalms_conf.h"

#ifndef Bool
# define Bool int
# define False 0
# define True 1
#endif

#define PANE_COUNT_MIN 1
#define PANE_COUNT_MAX 4
#define PANE_VALUE_COUNT_MAX 4
#define ICON_TITLE_INDEX_COUNT_MAX 8
#define VALUE_COUNT_MAX (PANE_COUNT_MAX * PANE_VALUE_COUNT_MAX)
#define NO_COLOUR ~0l



typedef struct 
{
	int		number;
	int		number_max;
	int		number_min;
	int		decimals;
	long	min_value;
	long	max_value;

	long	old_value;
	long	new_value;

	char 	name[8];
	char	label[5];
	char 	alarm;		/* need  alarm */
	char    alarm_stat;
} LMS_VALUE;


/* x11 interface */
extern Bool OpenAllWindows(int argc, char **argv);
extern Bool CreateAllPixmaps(void);
extern Bool DrawTitles(void);
extern void ProcessEvents(void);
extern void CopyPixmap(int sx, int sy, int w, int h, int dx, int dy);
extern void CloseAllWindows(void);
extern void DestroyAllPixmaps(void);
extern void FreeAllStrings(void);
extern void ShowIt(void);
extern void SendExposeEvent(void);
extern void ClearWindow(void);
extern Bool ProcessNonStoredOptions(int *argc, char **argv);
extern Bool ProcessOptions(int argc, char **argv);
extern void UpdateIconTitle(void);
extern void JustBeep(void);

/* lm_sensors interface */
extern void ClearLMS(void);
extern Bool InitLMS(void);
extern void UpdateLMS(void);
extern Bool ShowLMS(void);
extern Bool ParseLMSPref(int pos, char *pref);

/* wmalms */
extern void SetCurrentPage(int newpage);
extern void SetGlobalAlarmState(Bool new_state);
