/*  ---------------------------------------------------------------
    wmALMS.  Another LM Sensors applet.
    Copyright (C) 2001,  Michael Glickman  <wmalms@yahoo.com>
    License: GPL
    --------------------------------------------------------------- */

#include "wmalms.h"

#include <stdlib.h>

#if HAVE_SYS_TIME_H
#include <sys/time.h>
#elif HAVE_TIME_H
#include <time.h>
#endif

#include <signal.h>


int CurPane, PaneCount, PaneValueCount;
int RefreshInterv, BeepInterv;
int PageShiftInterv[PANE_COUNT_MAX];
int ValueCount;
Bool GlobalAlarmState;
Bool Fahrenheit;

static int RefreshCount, PageChangeCount, BeepCount;
static void TimerAlarmHandler(int signum);
static int euclal(int v1, int v2);

int main(int argc, char *argv[])
{
    int rc = 4;
	int i, q, interv;
    struct itimerval new_timerval, old_timerval;
    
  
    if (!OpenAllWindows(argc, argv)) goto BadLuck;
    if(!InitLMS()) goto BadLuck;
  
    if (!CreateAllPixmaps()) goto BadLuck;
    if (!DrawTitles()) goto BadLuck;

	/* Page change interval must not exceed refresh interval */
	q = RefreshInterv;
	if (BeepInterv > 0)
	{ if (BeepInterv < q)
	     q = euclal(q, BeepInterv);
	  else
	     q = euclal(BeepInterv, q);
    }
	  
	for (i=0; i<PaneCount; i++)
	{
	  interv = PageShiftInterv[i];
	  if (interv < RefreshInterv) interv = RefreshInterv;
  	  q = euclal(interv, q);
	}
	
	for (i=0; i<PaneCount; i++)
		PageShiftInterv[i] /= q;	

	CurPane = 0; BeepCount = 0;
	RefreshCount = RefreshInterv /= q;	
	BeepInterv /= q;	
	PageChangeCount = PageShiftInterv[CurPane];
	
    new_timerval.it_interval.tv_sec = q;
    new_timerval.it_interval.tv_usec = 0;
    new_timerval.it_value.tv_sec = q;
    new_timerval.it_value.tv_usec = 0;

    signal(SIGALRM, TimerAlarmHandler);
    setitimer(ITIMER_REAL, &new_timerval, &old_timerval);	

    ShowIt();

    ProcessEvents();
    	       
    DestroyAllPixmaps();
    CloseAllWindows();
    	

    setitimer(ITIMER_REAL, &old_timerval, NULL);	
    rc = 0;


BadLuck:
    signal(SIGALRM, SIG_DFL);
    return rc;

}


/* -------------------------------------------------------------------------- */
void SetCurrentPage(int newpage)
{
  if (CurPane != newpage)
  {
	  CurPane = newpage; 
	  PageChangeCount = PageShiftInterv[CurPane]; 
	  RefreshCount = RefreshInterv;
  }	  
}	

void SetGlobalAlarmState(Bool new_state)
{
  if (GlobalAlarmState != new_state && BeepInterv > 0)
  {
	GlobalAlarmState = new_state;
	if (new_state)
	{	BeepCount = BeepInterv; 
		JustBeep();
	}
	else
		BeepCount = 0; 
  }	  
}	


static RETSIGTYPE TimerAlarmHandler(int signum)
{	

	if (BeepCount > 0 && --BeepCount <= 0)
	{
	    JustBeep();	
		BeepCount = BeepInterv;
	}	
	if (--PageChangeCount <= 0)
	{
		SetCurrentPage((CurPane + 1) % PaneCount); 
		SendExposeEvent();	
	}
	else
	if (--RefreshCount <= 0)
	{	
		RefreshCount = RefreshInterv;
		UpdateLMS();
	    UpdateIconTitle();
		SendExposeEvent();	
	}

    signal(SIGALRM, TimerAlarmHandler);

}


/*--------------------------------------------------------------------------- */
/* Sapienti sato */
static int euclal(int v1, int v2)
{
	int v3;

	/* Assumed v1 >= v2 >= 0 */

	while (v2 > 0)
	{
		v3 = v1 % v2;
		v1 = v2; v2 = v3;
	}

	return v1;
} 

