/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "aswvdial.h"

void AswvdialUsage()
{
    printf("Usage:\n\n");
    printf("[-v]        Show version and exit\n");
    printf("[-h]        Show this help\n");
    printf("\nASwvdial -- Version: %.4s\n", VERSION);
}

void PressEvent( XButtonEvent *xbe, int *connection, int *entry, int *maxentries)
{
    int x = xbe->x;
    int y = xbe->y;
    char temp[24];
    
    if (xbe->button==Button1)
    {
	if(y>=50 && y<=64)
	/*mouse click on buttons*/
	{
	    if (x>=1 && x<=20 && 0 == *connection)
	    /*mouse click on left button*/
   	    {
		if(*entry==0)
		    *entry=*maxentries;
		else
		    *entry=*entry-1;
	    }
	    if (x>=22 && x<=43)
	    /*mouse click on middle button*/
	    {
		if (0 == *connection)
		{
	 	    copyXPMArea( 1,66,20,15,1,50);
		    copyXPMArea(22,66,22,15,22,50);
	  	    copyXPMArea(45,66,20,15,45,50);
		    *connection = 1;
		    sprintf( temp, "netup %.16s", wvdial_opt[*entry]);
		    if (system( temp) == -1)
			printf("\nError: Cannot execute wvdial\n");
		}
		else
		{
		    copyXPMArea( 1,81,20,15,1,50);
		    copyXPMArea(22,81,22,15,22,50);
		    copyXPMArea(45,81,20,15,45,50);		
		    if (system( "netdown") == -1)
			printf("\nError: Cannot close connection\n");
		    *connection = 0;		    
		}
	    }
	    if (x>=45 && x<=64 && 0 == *connection)
	    /*mouse click on right button*/
	    {
		if (*entry == *maxentries)
		    *entry = 0;
		else
		    *entry = *entry + 1;
	    }
	}
    }
}

void Timing(int start, int *entry)
{
    double hours, minutes, seconds;				
    static int starttimer = 1;

    if (1 == start)
    {
        if (1 == starttimer)
        {
	    starttimer = 0;
	    wvdial.start = time(0);
	    (void) strlcpy( wvdial.provider, wvdial_opt[*entry], 17);
	}
	wvdial.end=time(0);
	wvdial.elapsed=difftime(wvdial.end,wvdial.start);
    }
    else
    {
        if (0 == starttimer)
        {
	    starttimer = 1;
	    wvdial.end = time(0);
	    wvdial.elapsed = difftime( wvdial.end, wvdial.start);
/*	    SaveConnection();*/
	}
    }

    minutes = modf( wvdial.elapsed/3600, &hours);
    minutes = minutes * 60;
    seconds = modf( minutes, &minutes);
    seconds = seconds * 60;
    DrawNumber(  1, 23, hours);
    DrawNumber( 18, 23, minutes);
    DrawNumber( 35, 23, seconds);
}
