/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <unistd.h>

#include "aswvdial.h"

#include "master.xpm"
#include "mask.xbm"


int main(int argc, char **argv)
{
    XEvent Event;
    int c;

    int connection = 0;
    int entry = 0;
    int maxentries = 0;
    unsigned int sleepTime = 1;

    wvdial.start = 0;
    wvdial.end = 0;
    wvdial.elapsed = 0.0;

    for (c=1; c<argc; c++)
    {
        if (argv[c] != NULL)
        {
	    if (0 == strcmp(argv[c], "-v"))
    	    {
        	printf("\naswvdial version %.4s\n\n", VERSION);
                exit( 0);
	    }
    	    else if (0 == strcmp(argv[c], "--help"))
    	    {
        	AswvdialUsage();
        	exit( 0);
    	    }
    	    else if (0 == strcmp(argv[c], "-h"))
    	    {
        	AswvdialUsage();
                exit( 0);
    	    }
    	    else
    	    {
        	printf("\nillegal option\n\n");
                AswvdialUsage();
	        exit( 0);
    	    }
	}
    } /*end of for*/

    if (0 == ReadConfig( &maxentries))
	return 1;

    openXwindow( argc, argv, master_xpm, (char*) mask_bits, mask_width, mask_height);
    
    while (1 == 1)
    {
        while (0 < XPending( display))
        {
            (void) XNextEvent( display, &Event);
            switch (Event.type)
            {
		case Expose:
  	    	    RedrawWindow();
 	        break;
	  	case ButtonPress:
		    PressEvent( &Event.xbutton, &connection, &entry, &maxentries);
		break;
  	        case DestroyNotify:
		    (void) XCloseDisplay( display);
	    	    exit( 0);
		default:
		break;
	    }
	    
	} /*end of while XPending*/

	DrawChar( wvdial_opt[entry]);
	if (ReadProc()==1)
	{
	    copyXPMArea(8,96,7,7,2,42);
	    Timing( 1, &entry);
	}
	else
	{
	    copyXPMArea(1,96,7,7,2,42);
	    Timing( 0, &entry);
	}

	RedrawWindow();
	(void) sleep( sleepTime);
    } /*end of while*/

    return 0;
}
